/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.speaker;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPeripheral;
import dan200.computercraft.shared.util.PauseAwareTimer;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

class DfpwmState {
    private static final long SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final long CLIENT_BUFFER = (long)((double)SECOND * 0.5);
    private static final int PREC = 10;
    private int charge = 0;
    private int strength = 0;
    private boolean previousBit = false;
    private boolean unplayed = true;
    private long clientEndTime = PauseAwareTimer.getTime();
    private float pendingVolume = 1.0f;
    private ByteBuffer pendingAudio;

    DfpwmState() {
    }

    synchronized boolean pushBuffer(LuaTable<?, ?> table, int size, @Nonnull Optional<Double> volume) throws LuaException {
        if (this.pendingAudio != null) {
            return false;
        }
        int outSize = size / 8;
        ByteBuffer buffer = ByteBuffer.allocate(outSize);
        for (int i = 0; i < outSize; ++i) {
            int thisByte = 0;
            for (int j = 1; j <= 8; ++j) {
                int level = table.getInt(i * 8 + j);
                if (level < -128 || level > 127) {
                    throw new LuaException("table item #" + (i * 8 + j) + " must be between -128 and 127");
                }
                boolean currentBit = level > this.charge || level == this.charge && this.charge == 127;
                int target = currentBit ? 127 : -128;
                int nextCharge = this.charge + (this.strength * (target - this.charge) + 512 >> 10);
                if (nextCharge == this.charge && nextCharge != target) {
                    nextCharge += currentBit ? 1 : -1;
                }
                int z = currentBit == this.previousBit ? 1023 : 0;
                int nextStrength = this.strength;
                if (this.strength != z) {
                    nextStrength += currentBit == this.previousBit ? 1 : -1;
                }
                if (nextStrength < 8) {
                    nextStrength = 8;
                }
                this.charge = nextCharge;
                this.strength = nextStrength;
                this.previousBit = currentBit;
                thisByte = (thisByte >> 1) + (currentBit ? 128 : 0);
            }
            buffer.put((byte)thisByte);
        }
        buffer.flip();
        this.pendingAudio = buffer;
        this.pendingVolume = (float)SpeakerPeripheral.clampVolume(volume.orElse(Double.valueOf(this.pendingVolume)));
        return true;
    }

    boolean shouldSendPending(long now) {
        return this.pendingAudio != null && now >= this.clientEndTime - CLIENT_BUFFER;
    }

    ByteBuffer pullPending(long now) {
        ByteBuffer audio = this.pendingAudio;
        this.pendingAudio = null;
        this.clientEndTime = Math.max(now, this.clientEndTime) + (long)audio.remaining() * SECOND * 8L / 48000L;
        this.unplayed = false;
        return audio;
    }

    boolean isPlaying() {
        return this.unplayed || this.clientEndTime >= PauseAwareTimer.getTime();
    }

    float getVolume() {
        return this.pendingVolume;
    }
}

