/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.client.gui.ComputerScreenBase;
import dan200.computercraft.client.gui.OptionScreen;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.NetworkMessage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class UploadResultMessage
implements NetworkMessage {
    private final int containerId;
    private final UploadResult result;
    private final Component errorMessage;

    private UploadResultMessage(AbstractContainerMenu container, UploadResult result, @Nullable Component errorMessage) {
        this.containerId = container.f_38840_;
        this.result = result;
        this.errorMessage = errorMessage;
    }

    public static UploadResultMessage queued(AbstractContainerMenu container) {
        return new UploadResultMessage(container, UploadResult.QUEUED, null);
    }

    public static UploadResultMessage consumed(AbstractContainerMenu container) {
        return new UploadResultMessage(container, UploadResult.CONSUMED, null);
    }

    public static UploadResultMessage error(AbstractContainerMenu container, Component errorMessage) {
        return new UploadResultMessage(container, UploadResult.ERROR, errorMessage);
    }

    public UploadResultMessage(@Nonnull FriendlyByteBuf buf) {
        this.containerId = buf.m_130242_();
        this.result = (UploadResult)buf.m_130066_(UploadResult.class);
        this.errorMessage = this.result == UploadResult.ERROR ? buf.m_130238_() : null;
    }

    @Override
    public void toBytes(@Nonnull FriendlyByteBuf buf) {
        buf.m_130130_(this.containerId);
        buf.m_130068_((Enum)this.result);
        if (this.result == UploadResult.ERROR) {
            buf.m_130083_(this.errorMessage);
        }
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = OptionScreen.unwrap(minecraft.f_91080_);
        if (screen instanceof ComputerScreenBase && ((ContainerComputerBase)((ComputerScreenBase)screen).m_6262_()).f_38840_ == this.containerId) {
            ((ComputerScreenBase)screen).uploadResult(this.result, this.errorMessage);
        }
    }
}

