/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class RecipeModHelpers {
    static final List<ComputerFamily> MAIN_FAMILIES = Arrays.asList(ComputerFamily.NORMAL, ComputerFamily.ADVANCED);

    private RecipeModHelpers() {
    }

    public static boolean shouldRemoveRecipe(ResourceLocation id) {
        if (!id.m_135827_().equals("computercraft")) {
            return false;
        }
        String path = id.m_135815_();
        return path.startsWith("turtle_normal/") || path.startsWith("turtle_advanced/") || path.startsWith("pocket_normal/") || path.startsWith("pocket_advanced/");
    }

    public static List<ItemStack> getExtraStacks() {
        ArrayList<ItemStack> upgradeItems = new ArrayList<ItemStack>();
        for (ComputerFamily family : MAIN_FAMILIES) {
            for (ITurtleUpgrade iTurtleUpgrade : TurtleUpgrades.instance().getUpgrades()) {
                upgradeItems.add(TurtleItemFactory.create(-1, null, -1, family, null, iTurtleUpgrade, 0, null));
            }
            for (IPocketUpgrade iPocketUpgrade : PocketUpgrades.instance().getUpgrades()) {
                upgradeItems.add(PocketComputerItemFactory.create(-1, null, -1, family, iPocketUpgrade));
            }
        }
        return upgradeItems;
    }
}

