/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.metrics.basic;

import com.google.common.collect.MapMaker;
import dan200.computercraft.core.metrics.Metric;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.metrics.ComputerMetricsObserver;
import dan200.computercraft.shared.computer.metrics.GlobalMetrics;
import dan200.computercraft.shared.computer.metrics.basic.ComputerMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BasicComputerMetricsObserver
implements ComputerMetricsObserver {
    private final GlobalMetrics owner;
    private boolean tracking = false;
    private final List<ComputerMetrics> timings = new ArrayList<ComputerMetrics>();
    private final Map<ServerComputer, ComputerMetrics> timingLookup = new MapMaker().weakKeys().makeMap();

    public BasicComputerMetricsObserver(GlobalMetrics owner) {
        this.owner = owner;
    }

    public synchronized void start() {
        if (!this.tracking) {
            this.owner.addObserver(this);
        }
        this.tracking = true;
        this.timings.clear();
        this.timingLookup.clear();
    }

    public synchronized boolean stop() {
        if (!this.tracking) {
            return false;
        }
        this.owner.removeObserver(this);
        this.tracking = false;
        this.timingLookup.clear();
        return true;
    }

    public synchronized List<ComputerMetrics> getSnapshot() {
        ArrayList<ComputerMetrics> timings = new ArrayList<ComputerMetrics>(this.timings.size());
        for (ComputerMetrics timing : this.timings) {
            timings.add(new ComputerMetrics(timing));
        }
        return timings;
    }

    public synchronized List<ComputerMetrics> getTimings() {
        return new ArrayList<ComputerMetrics>(this.timings);
    }

    private ComputerMetrics getMetrics(ServerComputer computer) {
        ComputerMetrics existing = this.timingLookup.get(computer);
        if (existing != null) {
            return existing;
        }
        ComputerMetrics metrics = new ComputerMetrics(computer);
        this.timingLookup.put(computer, metrics);
        this.timings.add(metrics);
        return metrics;
    }

    @Override
    public synchronized void observe(ServerComputer computer, Metric.Counter counter) {
        this.getMetrics(computer).observe(counter);
    }

    @Override
    public synchronized void observe(ServerComputer computer, Metric.Event event, long value) {
        this.getMetrics(computer).observe(event, value);
    }
}

