/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.handles;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.apis.handles.HandleGeneric;
import dan200.computercraft.core.filesystem.TrackingCloseable;
import dan200.computercraft.shared.util.StringUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

public class EncodedWritableHandle
extends HandleGeneric {
    private final BufferedWriter writer;

    public EncodedWritableHandle(@Nonnull BufferedWriter writer, @Nonnull TrackingCloseable closable) {
        super(closable);
        this.writer = writer;
    }

    @LuaFunction
    public final void write(IArguments args) throws LuaException {
        this.checkOpen();
        String text = StringUtil.toString(args.get(0));
        try {
            this.writer.write(text, 0, text.length());
        }
        catch (IOException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final void writeLine(IArguments args) throws LuaException {
        this.checkOpen();
        String text = StringUtil.toString(args.get(0));
        try {
            this.writer.write(text, 0, text.length());
            this.writer.newLine();
        }
        catch (IOException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final void flush() throws LuaException {
        this.checkOpen();
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static BufferedWriter openUtf8(WritableByteChannel channel) {
        return EncodedWritableHandle.open(channel, StandardCharsets.UTF_8);
    }

    public static BufferedWriter open(WritableByteChannel channel, Charset charset) {
        CharsetEncoder encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        return new BufferedWriter(Channels.newWriter(channel, encoder, -1));
    }
}

