/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.util.Palette;
import net.minecraft.client.renderer.MultiBufferSource;

public final class PrintoutRenderer {
    private static final float BG_SIZE = 256.0f;
    public static final int X_SIZE = 172;
    public static final int Y_SIZE = 209;
    public static final int X_TEXT_MARGIN = 13;
    public static final int Y_TEXT_MARGIN = 11;
    private static final int X_FOLD_SIZE = 12;
    public static final int COVER_SIZE = 12;
    private static final int COVER_Y = 209;
    private static final int COVER_X = 220;

    private PrintoutRenderer() {
    }

    public static void drawText(PoseStack transform, MultiBufferSource bufferSource, int x, int y, int start, int light, TextBuffer[] text, TextBuffer[] colours) {
        VertexConsumer buffer = bufferSource.m_6299_(RenderTypes.PRINTOUT_TEXT);
        FixedWidthFontRenderer.QuadEmitter emitter = FixedWidthFontRenderer.toVertexConsumer(transform, buffer);
        for (int line = 0; line < 21 && line < text.length; ++line) {
            FixedWidthFontRenderer.drawString(emitter, x, y + line * 9, text[start + line], colours[start + line], Palette.DEFAULT, light);
        }
    }

    public static void drawText(PoseStack transform, MultiBufferSource bufferSource, int x, int y, int start, int light, String[] text, String[] colours) {
        VertexConsumer buffer = bufferSource.m_6299_(RenderTypes.PRINTOUT_TEXT);
        FixedWidthFontRenderer.QuadEmitter emitter = FixedWidthFontRenderer.toVertexConsumer(transform, buffer);
        for (int line = 0; line < 21 && line < text.length; ++line) {
            FixedWidthFontRenderer.drawString(emitter, x, y + line * 9, new TextBuffer(text[start + line]), new TextBuffer(colours[start + line]), Palette.DEFAULT, light);
        }
    }

    public static void drawBorder(PoseStack transform, MultiBufferSource bufferSource, float x, float y, float z, int page, int pages, boolean isBook, int light) {
        int n;
        Matrix4f matrix = transform.m_85850_().m_85861_();
        int leftPages = page;
        int rightPages = pages - page - 1;
        VertexConsumer buffer = bufferSource.m_6299_(RenderTypes.PRINTOUT_BACKGROUND);
        if (isBook) {
            float offset = PrintoutRenderer.offsetAt(pages);
            float left = x - 4.0f - offset;
            float right = x + 172.0f + offset - 4.0f;
            PrintoutRenderer.drawTexture(matrix, buffer, left - 4.0f, y - 8.0f, z - 0.02f, 220.0f, 0.0f, 12.0f, 233.0f, light);
            PrintoutRenderer.drawTexture(matrix, buffer, right, y - 8.0f, z - 0.02f, 232.0f, 0.0f, 12.0f, 233.0f, light);
            PrintoutRenderer.drawTexture(matrix, buffer, x - offset, y, z - 0.02f, 172.0f + offset * 2.0f, 209.0f, 226.0f, 12.0f, 12.0f, 209.0f, light);
            float borderX = left;
            while (borderX < right) {
                double thisWidth = Math.min(right - borderX, 172.0f);
                PrintoutRenderer.drawTexture(matrix, buffer, borderX, y - 8.0f, z - 0.02f, 0.0f, 209.0f, (float)thisWidth, 12.0f, light);
                PrintoutRenderer.drawTexture(matrix, buffer, borderX, y + 209.0f - 4.0f, z - 0.02f, 0.0f, 221.0f, (float)thisWidth, 12.0f, light);
                borderX = (float)((double)borderX + thisWidth);
            }
        }
        PrintoutRenderer.drawTexture(matrix, buffer, x, y, z - 5.0E-4f, 24.0f, 0.0f, 172.0f, 209.0f, light);
        for (n = 0; n <= leftPages; ++n) {
            PrintoutRenderer.drawTexture(matrix, buffer, x - PrintoutRenderer.offsetAt(n), y, z - 0.001f * (float)n, n == leftPages ? 0.0f : 12.0f, 0.0f, 12.0f, 209.0f, light);
        }
        for (n = 0; n <= rightPages; ++n) {
            PrintoutRenderer.drawTexture(matrix, buffer, x + 160.0f + PrintoutRenderer.offsetAt(n), y, z - 0.001f * (float)n, 196 + (n == rightPages ? 12 : 0), 0.0f, 12.0f, 209.0f, light);
        }
    }

    private static void drawTexture(Matrix4f matrix, VertexConsumer buffer, float x, float y, float z, float u, float v, float width, float height, int light) {
        PrintoutRenderer.vertex(buffer, matrix, x, y + height, z, u / 256.0f, (v + height) / 256.0f, light);
        PrintoutRenderer.vertex(buffer, matrix, x + width, y + height, z, (u + width) / 256.0f, (v + height) / 256.0f, light);
        PrintoutRenderer.vertex(buffer, matrix, x + width, y, z, (u + width) / 256.0f, v / 256.0f, light);
        PrintoutRenderer.vertex(buffer, matrix, x, y, z, u / 256.0f, v / 256.0f, light);
    }

    private static void drawTexture(Matrix4f matrix, VertexConsumer buffer, float x, float y, float z, float width, float height, float u, float v, float tWidth, float tHeight, int light) {
        PrintoutRenderer.vertex(buffer, matrix, x, y + height, z, u / 256.0f, (v + tHeight) / 256.0f, light);
        PrintoutRenderer.vertex(buffer, matrix, x + width, y + height, z, (u + tWidth) / 256.0f, (v + tHeight) / 256.0f, light);
        PrintoutRenderer.vertex(buffer, matrix, x + width, y, z, (u + tWidth) / 256.0f, v / 256.0f, light);
        PrintoutRenderer.vertex(buffer, matrix, x, y, z, u / 256.0f, v / 256.0f, light);
    }

    private static void vertex(VertexConsumer buffer, Matrix4f matrix, float x, float y, float z, float u, float v, int light) {
        buffer.m_85982_(matrix, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_85969_(light).m_5752_();
    }

    public static float offsetAt(int page) {
        return (float)(32.0 * (1.0 - Math.pow(1.2, -page)));
    }
}

