/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;
import net.pavocado.exoticbirds.entity.BirdEggEntity;

public class BirdEggItem
extends Item {
    private EntityType<? extends AbstractBirdEntity> bird;

    public BirdEggItem(Item.Properties builder) {
        super(builder);
    }

    public void initType(final EntityType<? extends AbstractBirdEntity> birdType) {
        this.bird = birdType;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level level, Position pos, ItemStack stack) {
                return new BirdEggEntity(level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), (EntityType<? extends AbstractBirdEntity>)birdType, stack);
            }
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11877_, SoundSource.PLAYERS, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
        if (!level.f_46443_) {
            BirdEggEntity egg = new BirdEggEntity(level, (LivingEntity)player, this.bird, itemstack);
            egg.m_37446_(itemstack);
            egg.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
            level.m_7967_((Entity)egg);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!player.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        AbstractBirdEntity entity;
        int spawnChance = 30;
        CompoundTag tag = stack.m_41737_("EggValues");
        if (tag != null && tag.m_128441_("SpawnChance")) {
            spawnChance = tag.m_128451_("SpawnChance");
        }
        tooltip.add((Component)Component.m_237110_((String)"egg.exoticbirds.spawn_chance", (Object[])new Object[]{spawnChance}).m_130940_(ChatFormatting.GRAY));
        MutableComponent variantName = Component.m_237115_((String)"egg.exoticbirds.unknown_variant");
        if (tag != null && tag.m_128441_("Variant") && level != null && (entity = (AbstractBirdEntity)this.bird.m_20615_(level)) != null) {
            variantName = entity.getTranslatedVariantName(tag.m_128451_("Variant"), true);
        }
        tooltip.add((Component)Component.m_237110_((String)"egg.exoticbirds.variant", (Object[])new Object[]{variantName}).m_130940_(ChatFormatting.GRAY));
    }

    public void setEggVariant(ItemStack stack, Level level) {
        AbstractBirdEntity entity;
        CompoundTag tag = stack.m_41737_("EggValues");
        if (tag != null && level != null && (entity = (AbstractBirdEntity)this.bird.m_20615_(level)) != null) {
            tag.m_128405_("Variant", entity.getRandomVariant());
        }
    }

    public static boolean canIncubate(ItemStack stack, int max) {
        CompoundTag compoundnbt = stack.m_41737_("EggValues");
        if (compoundnbt != null && compoundnbt.m_128441_("SpawnChance")) {
            return compoundnbt.m_128451_("SpawnChance") < max;
        }
        return true;
    }
}

