/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;

public class ScavengeGoal
extends Goal {
    protected final AbstractBirdEntity scavengingEntity;
    protected final Boolean canScavenge;
    protected final Predicate<ItemEntity> itemEntityPredicate;
    protected final ResourceLocation lootItems;

    public ScavengeGoal(AbstractBirdEntity entityIn, Boolean configValue, Ingredient itemsIn, ResourceLocation lootIn) {
        this.scavengingEntity = entityIn;
        this.canScavenge = configValue;
        this.lootItems = lootIn;
        this.itemEntityPredicate = itemEntity -> !itemEntity.m_32063_() && itemEntity.m_6084_() && itemsIn.test(itemEntity.m_32055_());
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.canScavenge.booleanValue()) {
            return false;
        }
        if (!this.scavengingEntity.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
            return false;
        }
        if (this.scavengingEntity.m_5448_() == null && this.scavengingEntity.m_21188_() == null) {
            if (this.scavengingEntity.m_217043_().m_188503_(ScavengeGoal.m_186073_((int)10)) != 0) {
                return false;
            }
            if (this.scavengeNewItem()) {
                return false;
            }
            List list = this.scavengingEntity.f_19853_.m_6443_(ItemEntity.class, this.scavengingEntity.m_20191_().m_82377_(8.0, 8.0, 8.0), this.itemEntityPredicate);
            return !list.isEmpty() && this.scavengingEntity.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
        }
        return false;
    }

    protected boolean scavengeNewItem() {
        if (this.scavengingEntity.m_217043_().m_188503_(ScavengeGoal.m_186073_((int)250)) == 0) {
            Iterator<ItemStack> iterator = this.getScavengedItem(this.scavengingEntity).iterator();
            if (iterator.hasNext()) {
                ItemStack itemstack = iterator.next();
                this.scavengingEntity.m_8061_(EquipmentSlot.MAINHAND, itemstack);
            }
            return true;
        }
        return false;
    }

    public void m_8037_() {
        List list = this.scavengingEntity.f_19853_.m_6443_(ItemEntity.class, this.scavengingEntity.m_20191_().m_82377_(8.0, 8.0, 8.0), this.itemEntityPredicate);
        ItemStack itemstack = this.scavengingEntity.m_6844_(EquipmentSlot.MAINHAND);
        if (itemstack.m_41619_() && !list.isEmpty()) {
            this.scavengingEntity.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
        }
    }

    public void m_8056_() {
        List list = this.scavengingEntity.f_19853_.m_6443_(ItemEntity.class, this.scavengingEntity.m_20191_().m_82377_(8.0, 8.0, 8.0), this.itemEntityPredicate);
        if (!list.isEmpty()) {
            this.scavengingEntity.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
        }
    }

    protected List<ItemStack> getScavengedItem(AbstractBirdEntity entity) {
        if (entity.f_19853_.m_7654_() != null) {
            LootTable loottable = entity.f_19853_.m_7654_().m_129898_().m_79217_(this.lootItems);
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)entity.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_78972_(LootContextParams.f_81455_, (Object)entity).m_230911_(entity.m_217043_());
            return loottable.m_230922_(builder.m_78975_(LootContextParamSets.f_81416_));
        }
        return new ArrayList<ItemStack>();
    }
}

