/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.container.PigeonMenu;
import net.pavocado.exoticbirds.entity.PigeonEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsPacketHandler;
import net.pavocado.exoticbirds.network.PacketSendPigeonMail;

public class PigeonScreen
extends AbstractContainerScreen<PigeonMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("exoticbirds", "textures/gui/container/pigeon.png");
    private final PigeonEntity pigeon;
    private float xMouse;
    private float yMouse;
    private SendMailButton mailButton;

    public PigeonScreen(PigeonMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, menu.pigeon.m_5446_());
        this.pigeon = menu.pigeon;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.mailButton = (SendMailButton)this.m_142416_((GuiEventListener)new SendMailButton(this.f_97735_ + 138, this.f_97736_ + 53, button -> {
            ItemStack stack = ((PigeonMenu)this.f_97732_).m_38853_(0).m_7993_();
            if (!stack.m_41619_()) {
                ExoticBirdsPacketHandler.INSTANCE.sendToServer((Object)new PacketSendPigeonMail(this.pigeon.m_19879_(), stack));
            }
        }));
        RoostBoxStatus roostWidget = (RoostBoxStatus)this.m_142416_((GuiEventListener)new RoostBoxStatus(this.f_97735_ + 150, this.f_97736_ + 18));
        roostWidget.f_93624_ = this.pigeon.hasBackpack();
        this.mailButton.f_93624_ = this.pigeon.hasBackpack() && ((PigeonMenu)this.f_97732_).getRoostPos() != null;
    }

    protected void m_181908_() {
        super.m_181908_();
        this.mailButton.f_93623_ = ((PigeonMenu)this.f_97732_).m_38853_(0).m_6657_() && (Boolean)ExoticBirdsCommonConfig.allowPigeonMail.get() != false;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float ticks) {
        this.m_7333_(stack);
        this.xMouse = mouseX;
        this.yMouse = mouseY;
        super.m_6305_(stack, mouseX, mouseY, ticks);
        this.m_7025_(stack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack stack, float ticks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(stack, i, j, 0, 0, this.f_97726_, this.f_97727_);
        if (this.pigeon.hasBackpack()) {
            this.m_93228_(stack, i + 84, j + 47, 27, 166, 18, 18);
        }
        InventoryScreen.m_98850_((int)(i + 51), (int)(j + 60), (int)48, (float)((float)(i + 51) - this.xMouse), (float)((float)(j + 75 - 50) - this.yMouse), (LivingEntity)this.pigeon);
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        RenderSystem.m_69461_();
        super.m_7027_(stack, mouseX, mouseY);
    }

    public static class SendMailButton
    extends Button {
        public SendMailButton(int xPos, int yPos, Button.OnPress onPress) {
            super(xPos, yPos, 27, 15, CommonComponents.f_237098_, onPress);
        }

        public void m_6303_(PoseStack stack, int mouseX, int mouseY, float ticks) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
            int i = 0;
            int j = 166;
            if (this.m_198029_()) {
                j = 181;
            }
            if (!this.f_93623_) {
                j = 196;
            }
            this.m_93228_(stack, this.f_93620_, this.f_93621_, i, j, this.f_93618_, this.f_93619_);
        }
    }

    public class RoostBoxStatus
    extends AbstractWidget {
        private static final MutableComponent ROOST_MISSING = Component.m_237115_((String)"block.exoticbirds.roost_missing");
        private static final MutableComponent ROOST_NOT_SET = Component.m_237115_((String)"block.exoticbirds.roost_not_set");
        private static final MutableComponent ROOST_FULL_ITEMS = Component.m_237115_((String)"block.exoticbirds.roost_full");
        private static final MutableComponent ROOST_FULL_PIGEON = Component.m_237115_((String)"block.exoticbirds.roost_already_has_pigeon");
        private static final MutableComponent ROOST_READY = Component.m_237115_((String)"block.exoticbirds.roost_ready");
        private static final MutableComponent HOW_TO_SET = Component.m_237115_((String)"block.exoticbirds.roost_how_to_set");
        private static final MutableComponent ROOST_LOCATION = Component.m_237115_((String)"block.exoticbirds.roost_location");
        private static final MutableComponent POST_NOT_ALLOWED = Component.m_237115_((String)"block.exoticbirds.pigeon_mail_disabled");

        public RoostBoxStatus(int xPos, int yPos) {
            super(xPos, yPos, 18, 18, CommonComponents.f_237098_);
        }

        public void m_7428_(PoseStack stack, int mouseX, int mouseY) {
            PigeonScreen.this.m_96597_(stack, this.componentsFromStatus(), mouseX, mouseY);
        }

        public void m_142291_(NarrationElementOutput narration) {
            this.m_168802_(narration);
            List<Component> componentList = this.componentsFromStatus();
            for (Component component : componentList) {
                narration.m_169146_(NarratedElementType.HINT, component);
            }
        }

        public void m_6303_(PoseStack stack, int mouseX, int mouseY, float ticks) {
            int j;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
            int i = 176;
            switch (((PigeonMenu)PigeonScreen.this.f_97732_).getRoostStatus()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NOT_SET: 
                case MISSING: {
                    int n = 36;
                    break;
                }
                case FULL_ITEMS: 
                case FULL_PIGEON: {
                    int n = 0;
                    break;
                }
                case READY: {
                    int n = j = 18;
                }
            }
            if (!((Boolean)ExoticBirdsCommonConfig.allowPigeonMail.get()).booleanValue()) {
                j = 54;
            }
            this.m_93228_(stack, this.f_93620_, this.f_93621_, i, j, this.f_93618_, this.f_93619_);
            if (this.m_198029_()) {
                this.m_7428_(stack, mouseX, mouseY);
            }
        }

        public boolean m_6375_(double p_93641_, double p_93642_, int p_93643_) {
            return false;
        }

        private List<Component> componentsFromStatus() {
            if (!((Boolean)ExoticBirdsCommonConfig.allowPigeonMail.get()).booleanValue()) {
                return List.of(POST_NOT_ALLOWED);
            }
            PigeonEntity.RoostStatus currentStatus = ((PigeonMenu)PigeonScreen.this.f_97732_).getRoostStatus();
            if (currentStatus == PigeonEntity.RoostStatus.NOT_SET) {
                return List.of(ROOST_NOT_SET, HOW_TO_SET);
            }
            ArrayList<MutableComponent> componentList = currentStatus == PigeonEntity.RoostStatus.MISSING ? new ArrayList<MutableComponent>(List.of(ROOST_MISSING)) : (currentStatus == PigeonEntity.RoostStatus.FULL_PIGEON ? new ArrayList<MutableComponent>(List.of(ROOST_FULL_PIGEON)) : (currentStatus == PigeonEntity.RoostStatus.FULL_ITEMS ? new ArrayList<MutableComponent>(List.of(ROOST_FULL_ITEMS)) : new ArrayList<MutableComponent>(List.of(ROOST_READY))));
            GlobalPos roostPos = ((PigeonMenu)PigeonScreen.this.f_97732_).getRoostPos();
            if (roostPos != null) {
                MutableComponent dimensionComponent = Component.m_237113_((String)roostPos.m_122640_().m_135782_().toString()).m_130940_(ChatFormatting.GRAY);
                BlockPos pos = roostPos.m_122646_();
                MutableComponent blockComponent = Component.m_237113_((String)(pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_())).m_130940_(ChatFormatting.GRAY);
                componentList.add(ROOST_LOCATION.m_130940_(ChatFormatting.GRAY));
                componentList.add(dimensionComponent);
                componentList.add(blockComponent);
            }
            return componentList;
        }
    }
}

