/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.pavocado.exoticbirds.blockentity.RoostBoxBlockEntity;
import net.pavocado.exoticbirds.blockentity.misc.StoredBirdLogic;
import net.pavocado.exoticbirds.entity.PigeonEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsBlockEntities;

public class RoostBoxBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape SHAPE_WEST = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)RoostBoxBlock.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), (VoxelShape[])new VoxelShape[0]), (BooleanOp)BooleanOp.f_82685_);
    public static final VoxelShape SHAPE_EAST = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)RoostBoxBlock.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (VoxelShape[])new VoxelShape[0]), (BooleanOp)BooleanOp.f_82685_);
    public static final VoxelShape SHAPE_NORTH = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)RoostBoxBlock.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)14.0), (VoxelShape[])new VoxelShape[0]), (BooleanOp)BooleanOp.f_82685_);
    public static final VoxelShape SHAPE_SOUTH = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)RoostBoxBlock.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[0]), (BooleanOp)BooleanOp.f_82685_);

    public RoostBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42655_)) {
            boolean flag = false;
            int i = pos.m_123341_();
            int j = pos.m_123342_();
            int k = pos.m_123343_();
            for (PigeonEntity pigeon : level.m_45976_(PigeonEntity.class, new AABB((double)i - 7.0, (double)j - 7.0, (double)k - 7.0, (double)i + 7.0, (double)j + 7.0, (double)k + 7.0))) {
                if (pigeon.m_21524_() != player || !pigeon.m_21824_() || !pigeon.m_21830_((LivingEntity)player) || !pigeon.hasBackpack()) continue;
                pigeon.setRoostBlock(state, level, pos, player);
                flag = true;
            }
            return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof RoostBoxBlockEntity) {
            RoostBoxBlockEntity roostBoxBlockEntity = (RoostBoxBlockEntity)blockentity;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)roostBoxBlockEntity, (BlockPos)pos);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity blockentity;
        if (stack.m_41788_() && (blockentity = level.m_7702_(pos)) instanceof RoostBoxBlockEntity) {
            RoostBoxBlockEntity roostBoxBlockEntity = (RoostBoxBlockEntity)blockentity;
            roostBoxBlockEntity.m_58638_(stack.m_41786_());
        }
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!oldState.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof RoostBoxBlockEntity) {
                RoostBoxBlockEntity boxEntity = (RoostBoxBlockEntity)blockentity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)boxEntity);
                level.m_46717_(pos, (Block)this);
                if (!level.f_46443_) {
                    StoredBirdLogic birdcage = boxEntity.getBirdcageLogic();
                    birdcage.spawnEntity((ServerLevel)level, pos);
                }
            }
            super.m_6810_(oldState, level, pos, newState, isMoving);
        }
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeContext.m_8125_().m_122424_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing == Direction.EAST) {
            return SHAPE_EAST;
        }
        if (facing == Direction.WEST) {
            return SHAPE_WEST;
        }
        if (facing == Direction.NORTH) {
            return SHAPE_NORTH;
        }
        if (facing == Direction.SOUTH) {
            return SHAPE_SOUTH;
        }
        return Shapes.m_83144_();
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{FACING});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RoostBoxBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return level.f_46443_ ? RoostBoxBlock.m_152132_(entityType, (BlockEntityType)((BlockEntityType)ExoticBirdsBlockEntities.ROOST_BOX.get()), RoostBoxBlockEntity::clientTick) : null;
    }
}

