/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.pavocado.exoticbirds.blockentity.NestBlockEntity;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.init.ExoticBirdsBlockEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;

public class NestBlock
extends BaseEntityBlock {
    public static final IntegerProperty EGGS = IntegerProperty.m_61631_((String)"eggs", (int)0, (int)3);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape NEST_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);

    public NestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(0)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof NestBlockEntity) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((NestBlockEntity)blockentity), (BlockPos)pos);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!oldState.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)blockentity));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(oldState, level, pos, newState, isMoving);
        }
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeContext.m_8125_().m_122424_());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return level.f_46443_ ? null : NestBlock.m_152132_(entityType, (BlockEntityType)((BlockEntityType)ExoticBirdsBlockEntities.NEST.get()), NestBlockEntity::serverTick);
    }

    public boolean m_6724_(BlockState p_54449_) {
        return (Boolean)ExoticBirdsCommonConfig.allowNestEggRegen.get();
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        if (random.m_188503_(50) == 0 && (Integer)state.m_61143_((Property)EGGS) < 3 && (blockEntity = level.m_7702_(pos)) instanceof NestBlockEntity) {
            NestBlockEntity nest = (NestBlockEntity)blockEntity;
            for (int k = 0; k < 3; ++k) {
                if (nest.inventory.getStackInSlot(k) != ItemStack.f_41583_) continue;
                nest.inventory.setStackInSlot(k, new ItemStack((ItemLike)ExoticBirdsItems.MYSTERY_EGG.get(), 1));
                break;
            }
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity blockentity;
        if (stack.m_41788_() && (blockentity = level.m_7702_(pos)) instanceof NestBlockEntity) {
            ((NestBlockEntity)blockentity).m_58638_(stack.m_41786_());
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return NEST_SHAPE;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)EGGS, (Comparable)((Integer)state.m_61143_((Property)EGGS)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61124_((Property)EGGS, (Comparable)((Integer)state.m_61143_((Property)EGGS)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{FACING, EGGS});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new NestBlockEntity(pos, state);
    }

    public BlockState m_7417_(BlockState p_51032_, Direction p_51033_, BlockState p_51034_, LevelAccessor p_51035_, BlockPos p_51036_, BlockPos p_51037_) {
        return !p_51032_.m_60710_((LevelReader)p_51035_, p_51036_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_51032_, p_51033_, p_51034_, p_51035_, p_51036_, p_51037_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return Block.m_49918_((VoxelShape)level.m_8055_(pos.m_7495_()).m_60812_((BlockGetter)level, pos.m_7495_()), (Direction)Direction.UP) || NestBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_()) || NestBlock.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)EGGS) * 5;
    }
}

