/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GasRenderer
extends EntityRenderer<GasEntity> {
    public GasRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
    }

    public ResourceLocation getTextureLocation(GasEntity entity) {
        return TextureAtlas.f_118259_;
    }

    public void render(GasEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Level level = entity.m_9236_();
        BlockState carriedGas = entity.getCarriedBlockState().orElse(null);
        if (carriedGas == null) {
            return;
        }
        if (carriedGas.m_60799_() != RenderShape.MODEL) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)entity.getRenderOffset(Direction.Axis.X), (double)entity.getRenderOffset(Direction.Axis.Y), (double)entity.getRenderOffset(Direction.Axis.Z));
        poseStack.m_85841_(entity.getRenderScale(Direction.Axis.X), entity.getRenderScale(Direction.Axis.Y), entity.getRenderScale(Direction.Axis.Z));
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        RenderType renderType = RenderType.m_110469_();
        BlockPos blockPos = entity.m_20183_();
        dispatcher.m_110937_().m_234379_((BlockAndTintGetter)level, dispatcher.m_110910_(carriedGas), carriedGas, blockPos, poseStack, buffer.m_6299_(renderType), false, RandomSource.m_216327_(), carriedGas.m_60726_(blockPos), OverlayTexture.f_118083_);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

