/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.common.CachedValue;
import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.impacts.AbstractPollutionImpacts;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class AcidRain {
    static final ResourceLocation VANILLA_LOCATION = new ResourceLocation("adpother", "textures/environment/acid_rain.png");
    static final ResourceLocation WEATHER2_LOCATION = new ResourceLocation("adpother", "environment/acid_rain_weather2");
    static final CachedValue<Boolean> ACID_RAIN = CachedValue.of(() -> {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        EntityPollution pollution = WorldData.getEntityPollution((Entity)player);
        return pollution.getPollutants().anyMatch(pollutant -> pollutant.canAffectEntity((Entity)player, AbstractPollutionImpacts.ImpactType.RAIN, pollution.getInfluenceOf((Pollutant<?>)((Object)((Object)pollutant)))));
    }, (CommonTime.Interval)GameTime.second().getInterval());
    static TextureAtlasSprite weather2Sprite;

    static boolean isAcidRain() {
        return (Boolean)ACID_RAIN.get();
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Post event) {
        TextureAtlas atlas = event.getAtlas();
        if (atlas.m_118330_().equals((Object)TextureAtlas.f_118260_)) {
            weather2Sprite = atlas.m_118316_(WEATHER2_LOCATION);
        }
    }

    public static final void onVanillaTextureBinding() {
        if (AcidRain.isAcidRain()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)VANILLA_LOCATION);
        }
    }

    public static final TextureAtlasSprite getWeather2Sprite(TextureAtlasSprite defaultSprite) {
        return AcidRain.isAcidRain() ? weather2Sprite : defaultSprite;
    }
}

