/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.RegistryObjectsInit;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class FluidTypes
extends RegistryObjectsInit<FluidType> {
    public final RegistryObject<FluidType> pollutedWaterType = this.register("polluted_water", () -> new FluidType(FluidType.Properties.create().descriptionId("block.adpother.polluted_water").fallDistanceModifier(0.0f).canExtinguish(true).canConvertToSource(true).supportsBoating(true).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_).canHydrate(true)){

        @Nullable
        public BlockPathTypes getBlockPathType(FluidState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, boolean canFluidLog) {
            return canFluidLog ? super.getBlockPathType(state, level, pos, mob, true) : null;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation UNDERWATER_LOCATION = new ResourceLocation("textures/misc/underwater.png");
                private static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
                private static final ResourceLocation WATER_FLOW = new ResourceLocation("block/water_flow");
                private static final ResourceLocation WATER_OVERLAY = new ResourceLocation("block/water_overlay");

                public ResourceLocation getStillTexture() {
                    return WATER_STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return WATER_FLOW;
                }

                @Nullable
                public ResourceLocation getOverlayTexture() {
                    return WATER_OVERLAY;
                }

                public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                    return UNDERWATER_LOCATION;
                }

                public int getTintColor() {
                    return -1710797;
                }

                public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return -1710797;
                }
            });
        }
    });

    public FluidTypes(AbstractForgeMod mod) {
        super(mod, ForgeRegistries.Keys.FLUID_TYPES);
    }

    public void addFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)this.pollutedWaterType.get(), fluidState -> fluidState.m_76170_() ? Blocks.f_50080_.m_49966_() : Blocks.f_50652_.m_49966_()));
    }
}

