/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.emissions;

import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.emissions.AbstractEntityEmission;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PeriodicTileEmission
extends AbstractEntityEmission<BlockEntity, Emitter> {
    protected PeriodicTileEmission(BlockEntity tile, Emitter emitter, GameTime updateInterval) {
        super(tile, emitter, updateInterval);
    }

    public static PeriodicTileEmission of(BlockEntity tile, Emitter emitter) {
        return new PeriodicTileEmission(tile, emitter, GameTime.second());
    }

    @Nullable
    public Level getWorldLevel() {
        return ((BlockEntity)this.getEntity()).m_58904_();
    }

    @Override
    public BlockPos getEntityBlockPos() {
        return ((BlockEntity)this.getEntity()).m_58899_();
    }

    public void onUpdate() {
        BlockPos pos;
        if (!this.isInEntityTickingChunk()) {
            return;
        }
        Level world = this.getWorldLevel();
        if (world == null) {
            return;
        }
        BlockEntity tile = (BlockEntity)this.getEntity();
        if (!tile.equals(world.m_7702_(pos = tile.m_58899_()))) {
            this.kill();
            return;
        }
        Emitter emitter = (Emitter)((Object)this.getEmitter());
        if (emitter.isActive((LevelReader)world, pos)) {
            emitter.emitAt(world, pos);
        }
    }
}

