/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;

public class GregTechCEu {
    public static final String MOD_ID = "gtceu";

    public static Emitter.Properties<?> machine() {
        return Emitter.Properties.tile("#hardcoded").customFactory(Machine::new);
    }

    public static Emitter.Properties<?> combustor(float carbon) {
        return (Emitter.Properties)((Object)((Emitter.Properties)((Object)GregTechCEu.machine().carbon(carbon))).sulfur(0.1f * carbon));
    }

    public static Emitter.Properties<?> macerator(float dust) {
        return (Emitter.Properties)((Object)GregTechCEu.machine().dust(dust));
    }

    public static Emitter.Properties<?> gasTurbine(float cabon) {
        return (Emitter.Properties)((Object)GregTechCEu.machine().carbon(cabon));
    }

    public static Emitter.Properties<?> largeGasTurbine(float carbon, String machineCasing) {
        return GregTechCEu.gasTurbine(carbon).relatedBlocks(GregTechCEu.machineCasingBlocks(machineCasing));
    }

    public static Emitter.Properties<?> grinder(float dust, String machineCasing) {
        return GregTechCEu.macerator(dust).relatedBlocks(GregTechCEu.machineCasingBlocks(machineCasing));
    }

    public static Emitter.Properties<?> macerationTower(float dust, String macerationCasing) {
        return GregTechCEu.macerator(dust).relatedBlocks(GregTechCEu.allBlocks(macerationCasing + "_maceration_casing"));
    }

    public static Emitter.Properties<?> boiler(float carbon) {
        return GregTechCEu.combustor(carbon);
    }

    public static Emitter.Properties<?> largeBoiler(float carbon, String machineCasing, String fireboxCasing) {
        return GregTechCEu.boiler(carbon).relatedBlocks(GregTechCEu.machineCasingBlocks(machineCasing), GregTechCEu.fireboxCasingBlocks(fireboxCasing));
    }

    public static Emitter.Properties<?> engine(float carbon) {
        return GregTechCEu.combustor(carbon);
    }

    public static Emitter.Properties<?> largeEngine(float carbon, String machineCasing) {
        return GregTechCEu.engine(carbon).relatedBlocks(GregTechCEu.machineCasingBlocks(machineCasing));
    }

    public static Emitter.Properties<?> brickOven(float carbon, String bricks) {
        return GregTechCEu.combustor(carbon).relatedBlocks(GregTechCEu.allBlocks(bricks));
    }

    public static Emitter.Properties<?> cokeOven(float carbon) {
        return GregTechCEu.combustor(carbon).relatedBlocks(GregTechCEu.allBlocks("coke_oven_bricks"), GregTechCEu.allBlocks("coke_oven_hatch"));
    }

    public static Emitter.Properties<?> largeOven(float carbon, String machineCasing, String fireboxCasing) {
        return GregTechCEu.combustor(carbon).relatedBlocks(GregTechCEu.machineCasingBlocks(machineCasing), GregTechCEu.fireboxCasingBlocks(fireboxCasing));
    }

    private static String machineCasingBlocks(String type) {
        return GregTechCEu.allBlocks(type + "_machine_casing");
    }

    private static String fireboxCasingBlocks(String type) {
        return GregTechCEu.allBlocks(type + "_firebox_casing");
    }

    private static String allBlocks(String name) {
        return UnitId.from((String)MOD_ID, (String)name).withMetaAll().toString();
    }

    public static class Machine
    extends Emitter {
        public Machine(UnitConfig config, Emitter.Properties<?> props) {
            super(config, (Emitter.Properties<?>)((Object)props.activeStateHardcoded()));
        }

        @Override
        public boolean isActive(INBTSerializable<CompoundTag> nbtSource) {
            if (nbtSource == null) {
                return false;
            }
            try {
                CompoundTag recipeLogic = TagHelper.serialize(nbtSource).m_128469_("recipeLogic");
                return recipeLogic.m_128461_("status").equalsIgnoreCase("WORKING");
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

