/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.plants;

import dev.xkmc.fruitsdelight.compat.diet.DietTagGen;
import dev.xkmc.fruitsdelight.init.plants.FDBushes;
import dev.xkmc.fruitsdelight.init.plants.FDMelons;
import dev.xkmc.fruitsdelight.init.plants.FDPineapple;
import dev.xkmc.fruitsdelight.init.plants.FDTrees;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.repack.registrate.builders.ItemBuilder;
import dev.xkmc.l2library.repack.registrate.providers.RegistrateRecipeProvider;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public interface PlantDataEntry<E extends Enum<E>> {
    public static final List<Supplier<PlantDataEntry<?>[]>> LIST = List.of(FDTrees::values, FDBushes::values, FDMelons::values, FDPineapple::values);

    public static <T> void gen(T val, BiConsumer<PlantDataEntry<?>, T> mod) {
        for (Supplier<PlantDataEntry<?>[]> e : LIST) {
            for (PlantDataEntry<?> i : e.get()) {
                mod.accept(i, (PlantDataEntry<?>)val);
            }
        }
    }

    public static void run(Consumer<PlantDataEntry<?>> mod) {
        for (Supplier<PlantDataEntry<?>[]> e : LIST) {
            for (PlantDataEntry<?> i : e.get()) {
                mod.accept(i);
            }
        }
    }

    public static <T extends Item> ItemBuilder<T, L2Registrate> addFruitTags(String name, ItemBuilder<T, L2Registrate> b) {
        return b.tag(new TagKey[]{ItemTags.create((ResourceLocation)new ResourceLocation("forge", "fruits")), DietTagGen.FRUITS.tag, ItemTags.create((ResourceLocation)new ResourceLocation("forge", "fruits/" + name))});
    }

    public void registerComposter();

    public void registerConfigs();

    public void registerPlacements();

    public String getName();

    public Holder<PlacedFeature> getPlacementKey();

    default public void genRecipe(RegistrateRecipeProvider pvd) {
    }
}

