/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeHooks;

public abstract class DoubleBushBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_222999_;
    public static final int MAX_AGE = 4;

    public DoubleBushBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
        super.m_7926_(builder);
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean client) {
        return (Integer)state.m_61143_((Property)AGE) < 4;
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public abstract int getDoubleBlockStart();

    public boolean m_6724_(BlockState state) {
        return state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER && (Integer)state.m_61143_((Property)AGE) < 4;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 4 && level.m_45524_(pos.m_7494_(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (rand.m_188503_(5) == 0 ? 1 : 0) != 0)) {
            this.setGrowth((Level)level, pos, i + 1, 2);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            BlockState lower = level.m_8055_(pos.m_7495_());
            if (lower.m_60713_((Block)this) && lower.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
                pos = pos.m_7495_();
                state = lower;
            } else {
                return;
            }
        }
        int i = Math.min(4, (Integer)state.m_61143_((Property)AGE) + 1);
        this.setGrowth((Level)level, pos, i, 2);
    }

    public void setGrowth(Level level, BlockPos pos, int age, int flag) {
        BlockState above;
        if (age >= this.getDoubleBlockStart()) {
            boolean fail = level.m_151570_(pos.m_7494_());
            if (!fail) {
                above = level.m_8055_(pos.m_7494_());
                boolean bl = fail = !above.m_60713_((Block)this) && !above.m_60767_().m_76336_();
            }
            if (fail && (age = this.getDoubleBlockStart() - 1) < 0) {
                return;
            }
        }
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(age));
        level.m_7731_(pos, state, flag);
        if (age >= this.getDoubleBlockStart()) {
            level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER), flag);
        } else {
            above = level.m_8055_(pos.m_7494_());
            if (above.m_60713_((Block)this) && above.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
                level.m_7471_(pos.m_7494_(), false);
            }
        }
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState sourceState, LevelAccessor level, BlockPos pos, BlockPos sourcePos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)f_52858_);
        if (half == DoubleBlockHalf.LOWER && dir == Direction.DOWN && !state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (dir.m_122434_() == Direction.Axis.Y) {
            boolean illegal;
            boolean bl = illegal = !sourceState.m_60713_((Block)this) || sourceState.m_61143_((Property)f_52858_) == half;
            if (half == DoubleBlockHalf.UPPER && dir == Direction.DOWN && illegal) {
                return Blocks.f_50016_.m_49966_();
            }
            if (half == DoubleBlockHalf.LOWER && dir == Direction.UP && illegal && (Integer)state.m_61143_((Property)AGE) >= this.getDoubleBlockStart()) {
                return Blocks.f_50016_.m_49966_();
            }
        }
        return super.m_7417_(state, dir, sourceState, level, pos, sourcePos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos blockpos = ctx.m_8083_();
        Level level = ctx.m_43725_();
        return blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(ctx) ? super.m_5573_(ctx) : null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState state, LivingEntity pPlacer, ItemStack pStack) {
        if ((Integer)state.m_61143_((Property)AGE) >= this.getDoubleBlockStart()) {
            super.m_6402_(pLevel, pPos, state, pPlacer, pStack);
        }
    }
}

