/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mes.misc.pooladditions;

import com.finndog.mes.MESCommon;
import com.finndog.mes.events.lifecycle.ServerGoingToStartEvent;
import com.finndog.mes.mixins.structures.ListPoolElementAccessor;
import com.finndog.mes.mixins.structures.SinglePoolElementAccessor;
import com.finndog.mes.mixins.structures.StructurePoolAccessor;
import com.finndog.mes.mixins.structures.StructureTemplateManagerAccessor;
import com.finndog.mes.utils.GeneralUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.levelgen.structure.pools.ListPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public final class PoolAdditionMerger {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().create();
    private static final String DATA_TYPE = "pool_additions";
    private static final int FILE_SUFFIX_LENGTH = ".json".length();

    private PoolAdditionMerger() {
    }

    public static void mergeAdditionPools(ServerGoingToStartEvent event) {
        ResourceManager resourceManager = ((StructureTemplateManagerAccessor)event.getServer().m_236738_()).mes_getResourceManager();
        Map<ResourceLocation, List<JsonElement>> poolAdditionJSON = GeneralUtils.getAllDatapacksJSONElement(resourceManager, GSON, DATA_TYPE, FILE_SUFFIX_LENGTH);
        PoolAdditionMerger.parsePoolsAndBeginMerger(poolAdditionJSON, (RegistryAccess)event.getServer().m_206579_(), event.getServer().m_236738_());
    }

    private static void parsePoolsAndBeginMerger(Map<ResourceLocation, List<JsonElement>> poolAdditionJSON, RegistryAccess dynamicRegistryManager, StructureTemplateManager StructureTemplateManager2) {
        Registry poolRegistry = dynamicRegistryManager.m_175515_(Registry.f_122884_);
        RegistryOps customRegistryOps = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)dynamicRegistryManager);
        for (Map.Entry<ResourceLocation, List<JsonElement>> entry : poolAdditionJSON.entrySet()) {
            if (poolRegistry.m_7745_(entry.getKey()) == null) continue;
            for (JsonElement jsonElement : entry.getValue()) {
                try {
                    AdditionalStructureTemplatePool.DIRECT_CODEC.parse((DynamicOps)customRegistryOps, (Object)jsonElement).resultOrPartial(messageString -> PoolAdditionMerger.logBadData((ResourceLocation)entry.getKey(), messageString)).ifPresent(validPool -> PoolAdditionMerger.mergeIntoExistingPool(validPool, (StructureTemplatePool)poolRegistry.m_7745_((ResourceLocation)entry.getKey()), StructureTemplateManager2));
                }
                catch (Exception e) {
                    MESCommon.LOGGER.error("\nMoog's End Structures: Pool Addition json failed to be parsed.\nThis is usually due to using a mod compat datapack without the other mod being on.\nEntry failed to be resolved: %s\nRegistry being used: %s\nError message is: %s".formatted(entry.getKey(), poolRegistry, e.getMessage()).indent(1));
                }
            }
        }
    }

    private static void mergeIntoExistingPool(AdditionalStructureTemplatePool feedingPool, StructureTemplatePool gluttonyPool, StructureTemplateManager structureTemplateManager) {
        ObjectArrayList elements = new ObjectArrayList(((StructurePoolAccessor)gluttonyPool).mes_getTemplates());
        ArrayList<Pair<StructurePoolElement, Integer>> elementCounts = new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)gluttonyPool).mes_getRawTemplates());
        elements.addAll(((StructurePoolAccessor)((Object)feedingPool)).mes_getTemplates());
        elementCounts.addAll(((StructurePoolAccessor)((Object)feedingPool)).mes_getRawTemplates());
        for (StructurePoolElement element : elements) {
            if (element instanceof SinglePoolElement) {
                SinglePoolElement singlePoolElement = (SinglePoolElement)element;
                Optional pieceRL = ((SinglePoolElementAccessor)singlePoolElement).mes_getTemplate().left();
                if (pieceRL.isEmpty()) continue;
                PoolAdditionMerger.checkIfPieceExists(feedingPool, structureTemplateManager, (ResourceLocation)pieceRL.get());
                continue;
            }
            if (!(element instanceof ListPoolElement)) continue;
            ListPoolElement listPoolElement = (ListPoolElement)element;
            for (StructurePoolElement listElement : ((ListPoolElementAccessor)listPoolElement).mes_getElements()) {
                SinglePoolElement singlePoolElement;
                Optional pieceRL;
                if (!(listElement instanceof SinglePoolElement) || (pieceRL = ((SinglePoolElementAccessor)(singlePoolElement = (SinglePoolElement)listElement)).mes_getTemplate().left()).isEmpty()) continue;
                PoolAdditionMerger.checkIfPieceExists(feedingPool, structureTemplateManager, (ResourceLocation)pieceRL.get());
            }
        }
        ((StructurePoolAccessor)gluttonyPool).mes_setTemplates((ObjectArrayList<StructurePoolElement>)elements);
        ((StructurePoolAccessor)gluttonyPool).mes_setRawTemplates(elementCounts);
    }

    private static void checkIfPieceExists(AdditionalStructureTemplatePool feedingPool, StructureTemplateManager structureTemplateManager, ResourceLocation pieceRL) {
        ResourceLocation resourcelocation = new ResourceLocation(pieceRL.m_135827_(), "structures/" + pieceRL.m_135815_() + ".nbt");
        try {
            InputStream inputstream = ((StructureTemplateManagerAccessor)structureTemplateManager).mes_getResourceManager().m_215595_(resourcelocation);
            if (inputstream.available() == 0 || inputstream.read(new byte[1]) == -1) {
                MESCommon.LOGGER.error("(Moog's End Structures POOL MERGER) Found an entry in {} that points to the non-existent nbt file called {}", (Object)feedingPool.m_210587_(), (Object)pieceRL);
            }
            inputstream.close();
        }
        catch (Throwable filenotfoundexception) {
            MESCommon.LOGGER.error("(Moog's End Structures POOL MERGER) Found an entry in {} that points to the non-existent nbt file called {}", (Object)feedingPool.m_210587_(), (Object)pieceRL);
        }
    }

    private static void logBadData(ResourceLocation poolPath, String messageString) {
        MESCommon.LOGGER.error("(Moog's End Structures POOL MERGER) Failed to parse {} additions file. Error is: {}", (Object)poolPath, (Object)messageString);
    }

    private static class AdditionalStructureTemplatePool
    extends StructureTemplatePool {
        private static final Codec<ExpandedPoolEntry> EXPANDED_POOL_ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StructurePoolElement.f_210468_.fieldOf("element").forGetter(ExpandedPoolEntry::poolElement), (App)Codec.intRange((int)1, (int)5000).fieldOf("weight").forGetter(ExpandedPoolEntry::weight), (App)ResourceLocation.f_135803_.optionalFieldOf("condition").forGetter(ExpandedPoolEntry::condition)).apply((Applicative)instance, ExpandedPoolEntry::new));
        public static final Codec<AdditionalStructureTemplatePool> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("name").forGetter(structureTemplatePool -> structureTemplatePool.name), (App)ResourceLocation.f_135803_.fieldOf("fallback").forGetter(StructureTemplatePool::m_210573_), (App)EXPANDED_POOL_ENTRY_CODEC.listOf().fieldOf("elements").forGetter(structureTemplatePool -> structureTemplatePool.rawTemplatesWithConditions)).apply((Applicative)instance, AdditionalStructureTemplatePool::new));
        protected final List<ExpandedPoolEntry> rawTemplatesWithConditions;
        protected final ResourceLocation name;

        public AdditionalStructureTemplatePool(ResourceLocation name, ResourceLocation fallback, List<ExpandedPoolEntry> rawTemplatesWithConditions) {
            super(name, fallback, rawTemplatesWithConditions.stream().map(triple -> Pair.of((Object)triple.poolElement(), (Object)triple.weight())).collect(Collectors.toList()));
            this.rawTemplatesWithConditions = rawTemplatesWithConditions;
            this.name = name;
        }

        public record ExpandedPoolEntry(StructurePoolElement poolElement, Integer weight, Optional<ResourceLocation> condition) {
        }
    }
}

