/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.parsers;

import chanceCubes.CCubesCore;
import chanceCubes.mcwrapper.JsonWrapper;
import chanceCubes.parsers.ParserUtil;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.rewardparts.BlockAreaPart;
import chanceCubes.rewards.rewardparts.ChestChanceItem;
import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.rewards.rewardparts.EffectPart;
import chanceCubes.rewards.rewardparts.EntityPart;
import chanceCubes.rewards.rewardparts.ExpirencePart;
import chanceCubes.rewards.rewardparts.ItemPart;
import chanceCubes.rewards.rewardparts.MessagePart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.ParticlePart;
import chanceCubes.rewards.rewardparts.PotionPart;
import chanceCubes.rewards.rewardparts.SchematicPart;
import chanceCubes.rewards.rewardparts.SoundPart;
import chanceCubes.rewards.rewardparts.TitlePart;
import chanceCubes.rewards.rewardtype.BlockAreaRewardType;
import chanceCubes.rewards.rewardtype.BlockRewardType;
import chanceCubes.rewards.rewardtype.ChestRewardType;
import chanceCubes.rewards.rewardtype.CommandRewardType;
import chanceCubes.rewards.rewardtype.EffectRewardType;
import chanceCubes.rewards.rewardtype.EntityRewardType;
import chanceCubes.rewards.rewardtype.ExperienceRewardType;
import chanceCubes.rewards.rewardtype.IRewardType;
import chanceCubes.rewards.rewardtype.ItemRewardType;
import chanceCubes.rewards.rewardtype.MessageRewardType;
import chanceCubes.rewards.rewardtype.ParticleEffectRewardType;
import chanceCubes.rewards.rewardtype.PotionRewardType;
import chanceCubes.rewards.rewardtype.SchematicRewardType;
import chanceCubes.rewards.rewardtype.SoundRewardType;
import chanceCubes.rewards.rewardtype.TitleRewardType;
import chanceCubes.rewards.variableTypes.BoolVar;
import chanceCubes.rewards.variableTypes.FloatVar;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.rewards.variableTypes.NBTVar;
import chanceCubes.rewards.variableTypes.StringVar;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.SchematicUtil;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Level;

public class RewardParser {
    public static CustomEntry<BasicReward, Boolean> parseReward(Map.Entry<String, JsonElement> reward) {
        ArrayList<IRewardType> rewards = new ArrayList<IRewardType>();
        JsonObject rewardElements = reward.getValue().getAsJsonObject();
        int chance = 0;
        boolean isGiantCubeReward = false;
        for (Map.Entry rewardElement : rewardElements.entrySet()) {
            if (((String)rewardElement.getKey()).equalsIgnoreCase("chance")) {
                chance = ((JsonElement)rewardElement.getValue()).getAsInt();
                continue;
            }
            if (((String)rewardElement.getKey()).equalsIgnoreCase("dependencies")) {
                boolean gameversion = false;
                boolean mcversionused = false;
                for (Map.Entry dependencies : ((JsonElement)rewardElement.getValue()).getAsJsonObject().entrySet()) {
                    String[] versionsToCheck;
                    if (((String)dependencies.getKey()).equalsIgnoreCase("mod")) {
                        if (ModList.get().isLoaded(((JsonElement)dependencies.getValue()).getAsString())) continue;
                        return new CustomEntry<Object, Boolean>(null, false);
                    }
                    if (!((String)dependencies.getKey()).equalsIgnoreCase("mcVersion")) continue;
                    mcversionused = true;
                    for (String toCheckV : versionsToCheck = ((JsonElement)dependencies.getValue()).getAsString().split(",")) {
                        String currentMCV = EffectiveSide.get() == LogicalSide.CLIENT ? Minecraft.m_91087_().m_91388_() : ServerLifecycleHooks.getCurrentServer().m_7630_();
                        if (toCheckV.contains("*")) {
                            currentMCV = currentMCV.substring(0, currentMCV.lastIndexOf("."));
                            toCheckV = toCheckV.substring(0, toCheckV.lastIndexOf("."));
                        }
                        if (!currentMCV.equalsIgnoreCase(toCheckV)) continue;
                        gameversion = true;
                    }
                }
                if (gameversion || !mcversionused) continue;
                return new CustomEntry<Object, Boolean>(null, false);
            }
            if (((String)rewardElement.getKey()).equalsIgnoreCase("isGiantCubeReward")) {
                isGiantCubeReward = ((JsonElement)rewardElement.getValue()).getAsBoolean();
                continue;
            }
            String currentParsingPart = (String)rewardElement.getKey();
            try {
                if (!((JsonElement)rewardElement.getValue()).isJsonArray()) {
                    CCubesCore.logger.log(Level.ERROR, "Not a JSON Array! Failed to load reward: " + currentParsingPart);
                    continue;
                }
                JsonArray rewardTypes = ((JsonElement)rewardElement.getValue()).getAsJsonArray();
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Item")) {
                    RewardParser.loadItemReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Block")) {
                    RewardParser.loadBlockReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Message")) {
                    RewardParser.loadMessageReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Command")) {
                    RewardParser.loadCommandReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Entity")) {
                    RewardParser.loadEntityReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Experience")) {
                    RewardParser.loadExperienceReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Potion")) {
                    RewardParser.loadPotionReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Schematic")) {
                    RewardParser.loadSchematicReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Sound")) {
                    RewardParser.loadSoundReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Chest")) {
                    RewardParser.loadChestReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Particle")) {
                    RewardParser.loadParticleReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Effect")) {
                    RewardParser.loadEffectReward(rewardTypes, rewards);
                    continue;
                }
                if (((String)rewardElement.getKey()).equalsIgnoreCase("Title")) {
                    RewardParser.loadTitleReward(rewardTypes, rewards);
                    continue;
                }
                if (!((String)rewardElement.getKey()).equalsIgnoreCase("Area")) continue;
                RewardParser.loadAreaReward(rewardTypes, rewards);
            }
            catch (Exception ex) {
                CCubesCore.logger.log(Level.ERROR, "Failed to load the custom reward \"" + reward.getKey() + "\" for some reason. The " + currentParsingPart + " part of the reward may be the issue! I will try better next time.");
                ex.printStackTrace();
            }
        }
        return new CustomEntry<BasicReward, Boolean>(new BasicReward(reward.getKey(), chance, rewards.toArray(new IRewardType[0])), isGiantCubeReward);
    }

    public static List<IRewardType> loadItemReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<ItemPart> items = new ArrayList<ItemPart>();
        for (JsonElement fullelement : rawReward) {
            NBTVar nbt = ParserUtil.getNBT(fullelement.getAsJsonObject(), "item");
            ItemPart stack = new ItemPart(nbt);
            stack.setDelay(ParserUtil.getInt(fullelement.getAsJsonObject(), "delay", stack.getDelay()));
            items.add(stack);
        }
        rewards.add(new ItemRewardType(items.toArray(new ItemPart[0])));
        return rewards;
    }

    public static List<IRewardType> loadBlockReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        for (JsonElement elementElem : rawReward) {
            JsonObject element = elementElem.getAsJsonObject();
            IntVar x = ParserUtil.getInt(element, "xOffSet", 0);
            IntVar y = ParserUtil.getInt(element, "yOffSet", 0);
            IntVar z = ParserUtil.getInt(element, "zOffSet", 0);
            String[] blockDataParts = ParserUtil.getString(element, "block", "minecraft:dirt").getValue().split(":");
            String mod = blockDataParts[0];
            String blockName = blockDataParts[1];
            Block block = RewardsUtil.getBlock(mod, blockName);
            BoolVar falling = ParserUtil.getBoolean(element, "falling", false);
            OffsetBlock offBlock = new OffsetBlock(x, y, z, block, falling);
            offBlock.setDelay(ParserUtil.getInt(element, "delay", offBlock.getDelay()));
            offBlock.setRelativeToPlayer(ParserUtil.getBoolean(element, "relativeToPlayer", offBlock.isRelativeToPlayer()));
            offBlock.setRemoveUnbreakableBlocks(ParserUtil.getBoolean(element, "removeUnbreakableBlocks", offBlock.doesRemoveUnbreakableBlocks()));
            offBlock.setPlaysSound(ParserUtil.getBoolean(element, "playSound", offBlock.doesPlaySound()));
            if (blockDataParts.length > 2) {
                BlockState state = block.m_49966_();
                SchematicUtil.decodeBlockState(state, blockDataParts[2]);
                offBlock.setBlockState(state);
            }
            blocks.add(offBlock);
        }
        rewards.add(new BlockRewardType(blocks.toArray(new OffsetBlock[0])));
        return rewards;
    }

    public static List<IRewardType> loadMessageReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<MessagePart> msgs = new ArrayList<MessagePart>();
        for (JsonElement elementElem : rawReward) {
            JsonObject element = elementElem.getAsJsonObject();
            MessagePart message = new MessagePart(ParserUtil.getString(element, "message", "No message was specified to send lel"));
            message.setDelay(ParserUtil.getInt(element, "delay", message.getDelay()));
            message.setServerWide(ParserUtil.getBoolean(element, "serverWide", message.isServerWide()));
            message.setRange(ParserUtil.getInt(element, "range", message.getRange()));
            msgs.add(message);
        }
        rewards.add(new MessageRewardType(msgs.toArray(new MessagePart[0])));
        return rewards;
    }

    public static List<IRewardType> loadCommandReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<CommandPart> commands = new ArrayList<CommandPart>();
        for (JsonElement elementElem : rawReward) {
            JsonObject element = elementElem.getAsJsonObject();
            CommandPart command = new CommandPart(ParserUtil.getString(element, "command", "/help"));
            command.setDelay(ParserUtil.getInt(element, "delay", command.getDelay()));
            command.setCopies(ParserUtil.getInt(element, "copies", 0));
            command.setCopiesSoft(ParserUtil.getBoolean(element, "copiesSoft", false));
            command.setRelativeToPlayer(ParserUtil.getBoolean(element, "relativeToPlayer", false));
            commands.add(command);
        }
        rewards.add(new CommandRewardType(commands.toArray(new CommandPart[0])));
        return rewards;
    }

    public static List<IRewardType> loadEntityReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<EntityPart> entities = new ArrayList<EntityPart>();
        for (JsonElement elementElem : rawReward) {
            EntityPart ent;
            JsonObject element = elementElem.getAsJsonObject();
            try {
                String jsonEdited = ParserUtil.removedKeyQuotes(element.get("entity").getAsJsonObject().toString());
                ent = new EntityPart(JsonWrapper.getNBTFromJson(jsonEdited));
            }
            catch (Exception e1) {
                CCubesCore.logger.log(Level.ERROR, "The Entity loading failed for this custom reward!");
                CCubesCore.logger.log(Level.ERROR, "Invalid json is: " + element.getAsString());
                e1.printStackTrace();
                continue;
            }
            ent.setRemovedBlocks(ParserUtil.getBoolean(element, "removeBlocks", true));
            ent.setCopies(ParserUtil.getInt(element, "copies", 0));
            ent.setDelay(ParserUtil.getInt(element, "delay", ent.getDelay()));
            entities.add(ent);
        }
        rewards.add(new EntityRewardType(entities.toArray(new EntityPart[0])));
        return rewards;
    }

    public static List<IRewardType> loadExperienceReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<ExpirencePart> exp = new ArrayList<ExpirencePart>();
        for (JsonElement elementElem : rawReward) {
            JsonObject element = elementElem.getAsJsonObject();
            ExpirencePart exppart = new ExpirencePart(ParserUtil.getInt(element, "experienceAmount", 1));
            exppart.setDelay(ParserUtil.getInt(element, "delay", exppart.getDelay()));
            exppart.setNumberofOrbs(ParserUtil.getInt(element, "numberOfOrbs", 1));
            exp.add(exppart);
        }
        rewards.add(new ExperienceRewardType(exp.toArray(new ExpirencePart[0])));
        return rewards;
    }

    public static List<IRewardType> loadPotionReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<PotionPart> potionEffects = new ArrayList<PotionPart>();
        for (JsonElement elementElem : rawReward) {
            JsonObject element = elementElem.getAsJsonObject();
            PotionPart potPart = new PotionPart(ParserUtil.getString(element, "potionid", "speed"), ParserUtil.getInt(element, "duration", 1), ParserUtil.getInt(element, "amplifier", 0));
            potPart.setDelay(ParserUtil.getInt(element, "delay", potPart.getDelay()));
            potionEffects.add(potPart);
        }
        rewards.add(new PotionRewardType(potionEffects.toArray(new PotionPart[0])));
        return rewards;
    }

    public static List<IRewardType> loadSoundReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList sounds = new ArrayList();
        for (JsonElement elementElem : rawReward) {
            JsonObject jsonObject = elementElem.getAsJsonObject();
        }
        rewards.add(new SoundRewardType(sounds.toArray(new SoundPart[0])));
        return rewards;
    }

    public static List<IRewardType> loadChestReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList items = Lists.newArrayList();
        for (JsonElement element : rawReward) {
            JsonObject obj = element.getAsJsonObject();
            IntVar amount = ParserUtil.getInt(obj, "amount", 1);
            IntVar chance = ParserUtil.getInt(obj, "chance", 50);
            items.add(new ChestChanceItem(ParserUtil.getString(obj, "item", "minecraft:dirt").getValue(), chance, amount));
        }
        rewards.add(new ChestRewardType(items.toArray(new ChestChanceItem[0])));
        return rewards;
    }

    public static List<IRewardType> loadParticleReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<ParticlePart> particles = new ArrayList<ParticlePart>();
        for (JsonElement elementElem : rawReward) {
            JsonObject element = elementElem.getAsJsonObject();
            ParticlePart particle = new ParticlePart(ParserUtil.getString(element, "particle", "explode"));
            particle.setDelay(ParserUtil.getInt(element, "delay", particle.getDelay()));
            particles.add(particle);
        }
        rewards.add(new ParticleEffectRewardType(particles.toArray(new ParticlePart[0])));
        return rewards;
    }

    public static List<IRewardType> loadSchematicReward(JsonArray rawReward, List<IRewardType> rewards) {
        for (JsonElement elementElem : rawReward) {
            JsonObject element = elementElem.getAsJsonObject();
            String fileName = element.get("fileName").getAsString();
            IntVar xoff = ParserUtil.getInt(element, "xOffSet", 0);
            IntVar yoff = ParserUtil.getInt(element, "yOffSet", 0);
            IntVar zoff = ParserUtil.getInt(element, "zOffSet", 0);
            IntVar delay = ParserUtil.getInt(element, "delay", 0);
            BoolVar falling = ParserUtil.getBoolean(element, "falling", true);
            BoolVar relativeToPlayer = ParserUtil.getBoolean(element, "relativeToPlayer", false);
            BoolVar includeAirBlocks = ParserUtil.getBoolean(element, "includeAirBlocks", false);
            BoolVar playSound = ParserUtil.getBoolean(element, "playSound", true);
            BoolVar hardcoded = ParserUtil.getBoolean(element, "hardcoded", false);
            FloatVar spacingDelay = ParserUtil.getFloat(element, "spacingDelay", 0.1f);
            SchematicPart part = new SchematicPart(fileName, hardcoded.getBoolValue(), xoff, yoff, zoff, spacingDelay, falling, relativeToPlayer, includeAirBlocks, playSound, delay);
            rewards.add(new SchematicRewardType(part));
        }
        return rewards;
    }

    public static List<IRewardType> loadEffectReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<EffectPart> effects = new ArrayList<EffectPart>();
        for (JsonElement elementElem : rawReward) {
            JsonObject element = elementElem.getAsJsonObject();
            EffectPart effectPart = new EffectPart(ParserUtil.getString(element, "potionid", "speed"), ParserUtil.getInt(element, "duration", 1), ParserUtil.getInt(element, "amplifier", 0));
            effectPart.setRadius(ParserUtil.getInt(element, "radius", 1));
            effectPart.setDelay(ParserUtil.getInt(element, "delay", effectPart.getDelay()));
            effects.add(effectPart);
        }
        rewards.add(new EffectRewardType(effects.toArray(new EffectPart[0])));
        return rewards;
    }

    public static List<IRewardType> loadTitleReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<TitlePart> titles = new ArrayList<TitlePart>();
        for (JsonElement elementElem : rawReward) {
            JsonObject element = elementElem.getAsJsonObject();
            JsonElement message = element.get("message");
            TitlePart titlePart = new TitlePart(ParserUtil.getString(element, "type", "TITLE"), message == null ? new JsonObject() : message.getAsJsonObject());
            titlePart.setFadeInTime(ParserUtil.getInt(element, "fadeInTime", 0));
            titlePart.setDisplayTime(ParserUtil.getInt(element, "displayTime", 0));
            titlePart.setFadeOutTime(ParserUtil.getInt(element, "fadeOutTime", 0));
            titlePart.setServerWide(ParserUtil.getBoolean(element, "isServerWide", false));
            titlePart.setRange(ParserUtil.getInt(element, "range", 16));
            titlePart.setDelay(ParserUtil.getInt(element, "delay", titlePart.getDelay()));
            titles.add(titlePart);
        }
        rewards.add(new TitleRewardType(titles.toArray(new TitlePart[0])));
        return rewards;
    }

    public static List<IRewardType> loadAreaReward(JsonArray rawReward, List<IRewardType> rewards) {
        ArrayList<BlockAreaPart> titles = new ArrayList<BlockAreaPart>();
        for (JsonElement elementElem : rawReward) {
            JsonObject element = elementElem.getAsJsonObject();
            IntVar xSize = ParserUtil.getInt(element, "xSize", 1);
            IntVar ySize = ParserUtil.getInt(element, "ySize", 1);
            IntVar zSize = ParserUtil.getInt(element, "zSize", 1);
            StringVar block = ParserUtil.getString(element, "block", "minecraft:dirt");
            BlockAreaPart areaPart = new BlockAreaPart(xSize, ySize, zSize, block);
            areaPart.setxOff(ParserUtil.getInt(element, "xOff", 0));
            areaPart.setyOff(ParserUtil.getInt(element, "yOff", 0));
            areaPart.setzOff(ParserUtil.getInt(element, "zOff", 0));
            areaPart.setFalling(ParserUtil.getBoolean(element, "falling", false));
            areaPart.setCausesUpdate(ParserUtil.getBoolean(element, "causesUpdate", false));
            areaPart.setRelativeToPlayer(ParserUtil.getBoolean(element, "relativeToPlayer", false));
            areaPart.setDelay(ParserUtil.getInt(element, "delay", areaPart.getDelay()));
            titles.add(areaPart);
        }
        rewards.add(new BlockAreaRewardType(titles.toArray(new BlockAreaPart[0])));
        return rewards;
    }
}

