/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.core.block.machines.recipes.misc.EnrichRecipe;
import ic2.core.block.machines.tiles.hv.UraniumEnchricherTileEntity;
import ic2.core.utils.helpers.SanityHelper;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UraniumEnricherInfo
implements IInfoProvider {
    public static final UraniumEnricherInfo THIS = new UraniumEnricherInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof UraniumEnchricherTileEntity) {
            UraniumEnchricherTileEntity enricher = (UraniumEnchricherTileEntity)blockEntity;
            helper.maxIn(enricher.getMaxInput());
            EnrichRecipe recipe = enricher.getRecipeList().getRecipe(enricher.storedType);
            helper.usage(recipe != null ? recipe.getEnergyCost() + 100 : 100);
            if (enricher.mainProgress > 0) {
                helper.bar(enricher.mainProgress / 20, 50, (Component)this.translate("ic2.probe.progress.full.name", new Object[]{enricher.mainProgress / 20, 50}).m_130946_("s"), -16733185);
            }
            if (enricher.getSubProgress() > 0.0f) {
                helper.bar((int)enricher.getSubProgress(), 100, (Component)this.translate("ic2.probe.progress.secondary.full.name", new Object[]{enricher.secondaryProgress, 100}).m_130946_("t"), recipe != null ? recipe.getColor() : -16733185);
            }
            if (enricher.storedPoints > 0) {
                helper.bar(enricher.storedPoints, 1000, (Component)this.translate("ic2.probe.uranium.type.name", new Object[]{SanityHelper.toPascalCase((String)recipe.getId().m_135815_()), enricher.storedPoints, 1000}), recipe.getColor());
            }
        }
    }
}

