/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.core.block.misc.tiles.BarrelTileEntity;
import ic2.core.inventory.filter.IFilter;
import ic2.core.platform.registries.IC2Blocks;
import ic2.core.utils.math.ColorUtils;
import ic2.jadeplugin.JadeTags;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public class BarrelInfo
implements IInfoProvider {
    public static final BarrelInfo THIS = new BarrelInfo();

    @Override
    public IFilter getFilter() {
        return THERMOMETER;
    }

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof BarrelTileEntity) {
            BarrelTileEntity barrelTile = (BarrelTileEntity)blockEntity;
            int brewQuality = barrelTile.beerQuality;
            int alcoholLevel = barrelTile.getAlcoholLevel();
            int solidRatio = barrelTile.getSolidRatio();
            int wheatAmount = barrelTile.wheatAmount;
            int hopsAmount = barrelTile.hopsAmount;
            int fluidAmount = barrelTile.fluidAmount;
            int maxFluidCapacity = 32000;
            int maxPotionCapacity = 3000;
            DecimalFormat format = new DecimalFormat("#0.00", new DecimalFormatSymbols(Locale.ROOT));
            FluidStack waterStack = new FluidStack((Fluid)Fluids.f_76193_, fluidAmount);
            int brewType = barrelTile.brewType;
            switch (brewType) {
                case 1: {
                    int age = barrelTile.age;
                    double maxValue = 24000.0 * Math.pow(3.0, brewQuality == 4 ? 6.0 : (double)brewQuality);
                    double current = (double)age / maxValue * 100.0;
                    helper.defaultText(this.getBrewType(brewType), new Object[0]);
                    helper.centered((Component)this.translate("ic2.probe.barrel.status.storage.name").m_130940_(ChatFormatting.YELLOW));
                    helper.bar(wheatAmount, 64, (Component)this.translate("ic2.probe.barrel.beer.wheat.name", new Object[]{wheatAmount}), ColorUtils.YELLOW);
                    helper.bar(hopsAmount, 64, (Component)this.translate("ic2.probe.barrel.beer.hops.name", new Object[]{hopsAmount}), ColorUtils.GREEN);
                    helper.fluid(waterStack, maxFluidCapacity);
                    helper.centered((Component)this.translate("ic2.probe.barrel.status.brew.name").m_130940_(ChatFormatting.YELLOW));
                    helper.text((Component)this.translate("ic2.probe.barrel.beer.quality." + brewQuality + ".name"));
                    helper.text((Component)this.translate("ic2.probe.barrel.beer.alc." + alcoholLevel + ".name"));
                    helper.text((Component)this.translate("ic2.probe.barrel.beer.solid." + solidRatio + ".name"));
                    helper.bar(age, (int)maxValue, (Component)this.string(format.format(current) + "%"), -16733185);
                    break;
                }
                case 2: {
                    double maxValue = barrelTile.timeNeededForRum();
                    int age = (int)Math.min((double)barrelTile.age, maxValue);
                    helper.defaultText(this.getBrewType(brewType), new Object[0]);
                    helper.centered((Component)this.translate("ic2.probe.barrel.status.brew.name").m_130940_(ChatFormatting.YELLOW));
                    helper.bar(fluidAmount / 1000, 32, (Component)this.translate("ic2.probe.barrel.beer.sugar_cane.name", new Object[]{fluidAmount / 1000}), ColorUtils.GREEN);
                    helper.bar(age, (int)maxValue, (Component)this.string(format.format(Math.min((double)age, maxValue) * 100.0 / maxValue) + "%"), -16733185);
                    break;
                }
                case 5: {
                    double ageWhisky = barrelTile.age;
                    int whiskyBrewTime = barrelTile.getWhiskBrewTime();
                    helper.defaultText(this.getBrewType(brewType), new Object[0]);
                    helper.centered((Component)this.translate("ic2.probe.barrel.status.storage.name").m_130940_(ChatFormatting.YELLOW));
                    helper.bar(hopsAmount, 16, (Component)this.translate("ic2.probe.barrel.whisky.grist.name", new Object[]{hopsAmount}), ColorUtils.GREEN);
                    helper.fluid(waterStack, maxFluidCapacity);
                    helper.centered((Component)this.translate("ic2.probe.barrel.status.brew.name").m_130940_(ChatFormatting.YELLOW));
                    helper.bar(Math.min(brewQuality, 50), 50, (Component)this.translate("ic2.probe.barrel.whisky.years.name", new Object[]{Math.min(brewQuality, 50)}), -16733185);
                    helper.bar((int)ageWhisky, 1728000, (Component)this.string(format.format(ageWhisky / ((double)whiskyBrewTime / 100.0)) + "%"), -16733185);
                    break;
                }
                case 10: {
                    helper.defaultText(this.getBrewType(brewType), new Object[0]);
                    helper.centered((Component)this.translate("ic2.probe.barrel.status.storage.name").m_130940_(ChatFormatting.YELLOW));
                    helper.bar(wheatAmount, 20, (Component)this.translate("ic2.probe.barrel.beer.redstone.name", new Object[]{wheatAmount}), ColorUtils.RED);
                    helper.bar(hopsAmount, 20, (Component)this.translate("ic2.probe.barrel.beer.glowstone.name", new Object[]{hopsAmount}), ColorUtils.YELLOW);
                    helper.fluid(waterStack, maxPotionCapacity);
                    helper.centered((Component)this.translate("ic2.probe.barrel.status.brew.name").m_130940_(ChatFormatting.YELLOW));
                    int brewedPotion = MobEffect.m_19459_((MobEffect)barrelTile.potionType);
                    MutableComponent potionID = brewedPotion == -1 ? this.translate("tooltip.block.ic2.barrel.unknown") : barrelTile.potionType.m_19482_();
                    helper.defaultText("ic2.probe.barrel.status.output.name", potionID);
                    helper.defaultText("ic2.probe.barrel.potion.quality." + brewQuality + ".name", brewQuality);
                    int age = barrelTile.age;
                    double maxValue = 5000.0 * Math.pow(3.0, brewQuality);
                    double current = (double)age / maxValue;
                    helper.bar(age, (int)maxValue, (Component)this.string(format.format(current * 100.0) + "%"), -16733185);
                    break;
                }
            }
        }
    }

    public String getBrewType(int type) {
        return switch (type) {
            case 0 -> "ic2.probe.barrel.status.empty.name";
            case 1 -> "ic2.probe.barrel.status.beer.name";
            case 2 -> "ic2.probe.barrel.status.rum.name";
            case 5 -> "ic2.probe.barrel.status.whisky.name";
            case 10 -> "ic2.probe.barrel.status.potion.name";
            default -> "I AM ERROR";
        };
    }

    public static class BarrelIconProvider
    implements IBlockComponentProvider,
    IServerDataProvider<BlockEntity> {
        @Nullable
        public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
            ItemStack icon = new ItemStack((ItemLike)IC2Blocks.BARREL);
            if (accessor.getServerData().m_128441_("BarrelInfo")) {
                CompoundTag tag = accessor.getServerData().m_128469_("BarrelInfo");
                int brewType = tag.m_128451_("type");
                icon.m_41784_().m_128405_("type", brewType);
            }
            return IElementHelper.get().item(icon);
        }

        public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, BlockEntity blockEntity, boolean b) {
            if (blockEntity instanceof BarrelTileEntity) {
                BarrelTileEntity barrel = (BarrelTileEntity)blockEntity;
                CompoundTag tag = new CompoundTag();
                tag.m_128405_("type", barrel.brewType);
                compoundTag.m_128365_("BarrelInfo", (Tag)tag);
            }
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        }

        public ResourceLocation getUid() {
            return JadeTags.INFO_RENDERER;
        }
    }
}

