/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.network;

import com.google.gson.JsonObject;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class CompoundSerializableDataHandler {
    private static final HashMap<Class, Pair<Reader, Writer>> FIELD_SERIALIZER = new HashMap();

    public static <T> void map(Class<T> type, Reader<T> reader, Writer<T> writer) {
        FIELD_SERIALIZER.put(type, (Pair<Reader, Writer>)Pair.of(reader, writer));
    }

    private static long[] readLongArray(FriendlyByteBuf buf) {
        return buf.m_130105_(new long[0]);
    }

    private static String readString(FriendlyByteBuf buf) {
        return buf.m_130136_(Short.MAX_VALUE);
    }

    private static FluidStack readFluidStack(FriendlyByteBuf buf) throws IOException {
        return FluidStack.loadFluidStackFromNBT((CompoundTag)buf.m_130260_());
    }

    private static void writeFluidStack(FriendlyByteBuf buf, FluidStack stack) {
        buf.m_130079_(stack == null ? FluidStack.EMPTY.writeToNBT(new CompoundTag()) : stack.writeToNBT(new CompoundTag()));
    }

    public static ResourceKey<?> readRegistryKey(FriendlyByteBuf buffer) {
        return ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)buffer.m_130281_()), (ResourceLocation)buffer.m_130281_());
    }

    public static void writeRegistryKey(FriendlyByteBuf buffer, ResourceKey<?> biome) {
        buffer.m_130085_(biome.m_211136_());
        buffer.m_130085_(biome.m_135782_());
    }

    private static void writeUpdatePacket(FriendlyByteBuf buf, ClientboundBlockEntityDataPacket packet) {
        packet.m_5779_(buf);
    }

    private static Ingredient.Value[] readIItemListArray(FriendlyByteBuf buf) {
        Ingredient.Value[] list = new Ingredient.Value[buf.readInt()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = new CollectionItemList(buf);
        }
        return list;
    }

    private static void writeIItemListArray(FriendlyByteBuf buf, Ingredient.Value[] list) {
        buf.writeInt(list.length);
        for (Ingredient.Value iItemList : list) {
            CollectionItemList.serializeBuffer(buf, iItemList);
        }
    }

    public static ResourceKey<?>[] readRegistryArray(FriendlyByteBuf buffer) {
        ResourceKey[] registryKeys = new ResourceKey[buffer.readInt()];
        for (int i = 0; i < registryKeys.length; ++i) {
            registryKeys[i] = CompoundSerializableDataHandler.readRegistryKey(buffer);
        }
        return registryKeys;
    }

    public static void writeRegistryArray(FriendlyByteBuf buffer, ResourceKey<?>[] registryKeys) {
        buffer.writeInt(registryKeys.length);
        for (ResourceKey<?> registryKey : registryKeys) {
            CompoundSerializableDataHandler.writeRegistryKey(buffer, registryKey);
        }
    }

    public static Ingredient[] readIngredientArray(FriendlyByteBuf buffer) {
        Ingredient[] ingredients = new Ingredient[buffer.readInt()];
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        }
        return ingredients;
    }

    public static void writeIngredientArray(FriendlyByteBuf buffer, Ingredient[] ingredients) {
        buffer.writeInt(ingredients.length);
        for (Ingredient ingredient : ingredients) {
            ingredient.m_43923_(buffer);
        }
    }

    private static ClientboundBlockEntityDataPacket readUpdatePacket(FriendlyByteBuf buf) {
        return new ClientboundBlockEntityDataPacket(buf);
    }

    public static Pair<Reader, Writer> getHandler(Class<?> clazz) {
        Pair<Reader, Writer> pair = FIELD_SERIALIZER.get(clazz);
        if (pair == null) {
            throw new RuntimeException("No R/W handler for  " + clazz);
        }
        return pair;
    }

    public static void writeField(Field f, Class clazz, FriendlyByteBuf buf, Object instance) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = CompoundSerializableDataHandler.getHandler(clazz);
        ((Writer)handler.getRight()).write(buf, f.get(instance));
    }

    public static void readField(Field f, Class clazz, FriendlyByteBuf buf, Object instance) throws IllegalArgumentException, IllegalAccessException, IOException {
        Pair<Reader, Writer> handler = CompoundSerializableDataHandler.getHandler(clazz);
        f.set(instance, ((Reader)handler.getLeft()).read(buf));
    }

    public static boolean acceptField(Field f, Class<?> type) {
        int mods = f.getModifiers();
        return !Modifier.isFinal(mods) && !Modifier.isStatic(mods) && !Modifier.isTransient(mods) && CompoundSerializableDataHandler.getHandler(type) != null;
    }

    static {
        CompoundSerializableDataHandler.map(Byte.TYPE, FriendlyByteBuf::readByte, FriendlyByteBuf::writeByte);
        CompoundSerializableDataHandler.map(Short.TYPE, FriendlyByteBuf::readShort, FriendlyByteBuf::writeShort);
        CompoundSerializableDataHandler.map(Integer.TYPE, FriendlyByteBuf::m_130242_, FriendlyByteBuf::m_130130_);
        CompoundSerializableDataHandler.map(Long.TYPE, FriendlyByteBuf::m_130258_, FriendlyByteBuf::m_130103_);
        CompoundSerializableDataHandler.map(Float.TYPE, FriendlyByteBuf::readFloat, FriendlyByteBuf::writeFloat);
        CompoundSerializableDataHandler.map(Double.TYPE, FriendlyByteBuf::readDouble, FriendlyByteBuf::writeDouble);
        CompoundSerializableDataHandler.map(Boolean.TYPE, FriendlyByteBuf::readBoolean, FriendlyByteBuf::writeBoolean);
        CompoundSerializableDataHandler.map(Character.TYPE, FriendlyByteBuf::readChar, FriendlyByteBuf::writeChar);
        CompoundSerializableDataHandler.map(Byte.class, FriendlyByteBuf::readByte, FriendlyByteBuf::writeByte);
        CompoundSerializableDataHandler.map(Short.class, FriendlyByteBuf::readShort, FriendlyByteBuf::writeShort);
        CompoundSerializableDataHandler.map(Integer.class, FriendlyByteBuf::m_130242_, FriendlyByteBuf::m_130130_);
        CompoundSerializableDataHandler.map(Long.class, FriendlyByteBuf::m_130258_, FriendlyByteBuf::m_130103_);
        CompoundSerializableDataHandler.map(Float.class, FriendlyByteBuf::readFloat, FriendlyByteBuf::writeFloat);
        CompoundSerializableDataHandler.map(Double.class, FriendlyByteBuf::readDouble, FriendlyByteBuf::writeDouble);
        CompoundSerializableDataHandler.map(Boolean.class, FriendlyByteBuf::readBoolean, FriendlyByteBuf::writeBoolean);
        CompoundSerializableDataHandler.map(Character.class, FriendlyByteBuf::readChar, FriendlyByteBuf::writeChar);
        CompoundSerializableDataHandler.map(byte[].class, FriendlyByteBuf::m_130052_, FriendlyByteBuf::m_130087_);
        CompoundSerializableDataHandler.map(int[].class, FriendlyByteBuf::m_130100_, FriendlyByteBuf::m_130089_);
        CompoundSerializableDataHandler.map(long[].class, CompoundSerializableDataHandler::readLongArray, FriendlyByteBuf::m_130091_);
        CompoundSerializableDataHandler.map(String.class, CompoundSerializableDataHandler::readString, FriendlyByteBuf::m_130070_);
        CompoundSerializableDataHandler.map(CompoundTag.class, FriendlyByteBuf::m_130260_, FriendlyByteBuf::m_130079_);
        CompoundSerializableDataHandler.map(ItemStack.class, FriendlyByteBuf::m_130267_, FriendlyByteBuf::m_130055_);
        CompoundSerializableDataHandler.map(FluidStack.class, CompoundSerializableDataHandler::readFluidStack, CompoundSerializableDataHandler::writeFluidStack);
        CompoundSerializableDataHandler.map(BlockPos.class, FriendlyByteBuf::m_130135_, FriendlyByteBuf::m_130064_);
        CompoundSerializableDataHandler.map(Component.class, FriendlyByteBuf::m_130238_, FriendlyByteBuf::m_130083_);
        CompoundSerializableDataHandler.map(Date.class, FriendlyByteBuf::m_130282_, FriendlyByteBuf::m_130075_);
        CompoundSerializableDataHandler.map(UUID.class, FriendlyByteBuf::m_130259_, FriendlyByteBuf::m_130077_);
        CompoundSerializableDataHandler.map(ClientboundBlockEntityDataPacket.class, CompoundSerializableDataHandler::readUpdatePacket, CompoundSerializableDataHandler::writeUpdatePacket);
        CompoundSerializableDataHandler.map(LocatorInstance.class, LocatorFactory::readPacketBuffer, LocatorFactory::writePacketBuffer);
        CompoundSerializableDataHandler.map(Ingredient.Value.class, CollectionItemList::new, CollectionItemList::serializeBuffer);
        CompoundSerializableDataHandler.map(Ingredient.class, Ingredient::m_43940_, (buf, ingredient) -> ingredient.m_43923_(buf));
        CompoundSerializableDataHandler.map(Block.class, buf -> (Block)ForgeRegistries.BLOCKS.getValue(buf.m_130281_()), (buf, block) -> buf.m_130085_(ForgeRegistries.BLOCKS.getKey(block)));
        CompoundSerializableDataHandler.map(Ingredient.Value[].class, CompoundSerializableDataHandler::readIItemListArray, CompoundSerializableDataHandler::writeIItemListArray);
        CompoundSerializableDataHandler.map(Ingredient[].class, CompoundSerializableDataHandler::readIngredientArray, CompoundSerializableDataHandler::writeIngredientArray);
        CompoundSerializableDataHandler.map(ResourceKey.class, CompoundSerializableDataHandler::readRegistryKey, CompoundSerializableDataHandler::writeRegistryKey);
        CompoundSerializableDataHandler.map(ResourceKey[].class, CompoundSerializableDataHandler::readRegistryArray, CompoundSerializableDataHandler::writeRegistryArray);
        CompoundSerializableDataHandler.map(ResourceLocation.class, FriendlyByteBuf::m_130281_, FriendlyByteBuf::m_130085_);
    }

    public static class CollectionItemList
    implements Ingredient.Value {
        private List<ItemStack> stackList = new ArrayList<ItemStack>();

        public CollectionItemList(FriendlyByteBuf buffer) {
            int amount = buffer.readInt();
            for (int i = 0; i < amount; ++i) {
                this.stackList.add(buffer.m_130267_());
            }
        }

        public static void serializeBuffer(FriendlyByteBuf buffer, Ingredient.Value list) {
            buffer.writeInt(list.m_6223_().size());
            list.m_6223_().forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130055_(arg_0));
        }

        public Collection<ItemStack> m_6223_() {
            return this.stackList;
        }

        public JsonObject m_6544_() {
            return new JsonObject();
        }
    }

    public static interface Writer<T> {
        public void write(FriendlyByteBuf var1, T var2);
    }

    public static interface Reader<T> {
        public T read(FriendlyByteBuf var1) throws IOException;
    }
}

