/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.services.Services;
import com.yungnickyoung.minecraft.yungsapi.world.condition.StructureCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.StructureConditionType;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import java.util.List;
import java.util.stream.Collectors;

public class ModLoaderCondition
extends StructureCondition {
    public static final Codec<ModLoaderCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.listOf().fieldOf("loaders").forGetter(conditon -> conditon.validLoaders)).apply((Applicative)builder, ModLoaderCondition::new));
    private final List<String> validLoaders;

    public ModLoaderCondition(List<String> validLoaders) {
        this.validLoaders = validLoaders.stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    @Override
    public StructureConditionType<?> type() {
        return StructureConditionType.MOD_LOADER;
    }

    @Override
    public boolean passes(StructureContext ctx) {
        String loader = Services.PLATFORM.getPlatformName();
        return this.validLoaders.contains(loader.toLowerCase());
    }
}

