/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.render.ContraptionEntityRenderer;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import java.util.Objects;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class CarriageContraptionEntityRenderer
extends ContraptionEntityRenderer<CarriageContraptionEntity> {
    public CarriageContraptionEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public boolean shouldRender(CarriageContraptionEntity entity, Frustum clippingHelper, double cameraX, double cameraY, double cameraZ) {
        Carriage carriage = entity.getCarriage();
        if (carriage != null) {
            for (CarriageBogey bogey : carriage.bogeys) {
                if (bogey == null) continue;
                bogey.couplingAnchors.replace(v -> null);
            }
        }
        return super.shouldRender(entity, clippingHelper, cameraX, cameraY, cameraZ);
    }

    @Override
    public void render(CarriageContraptionEntity entity, float yaw, float partialTicks, PoseStack ms, MultiBufferSource buffers, int overlay) {
        if (!entity.validForRender || entity.firstPositionUpdate) {
            return;
        }
        super.render(entity, yaw, partialTicks, ms, buffers, overlay);
        Carriage carriage = entity.getCarriage();
        if (carriage == null) {
            return;
        }
        Vec3 position = entity.m_20318_(partialTicks);
        float viewYRot = entity.m_5675_(partialTicks);
        float viewXRot = entity.m_5686_(partialTicks);
        int bogeySpacing = carriage.bogeySpacing;
        carriage.bogeys.forEach(bogey -> {
            BlockPos bogeyPos;
            if (bogey == null) {
                return;
            }
            BlockPos blockPos = bogeyPos = bogey.isLeading ? BlockPos.f_121853_ : BlockPos.f_121853_.m_5484_(entity.getInitialOrientation().m_122428_(), bogeySpacing);
            if (!Backend.canUseInstancing((Level)entity.f_19853_) && !entity.getContraption().isHiddenInPortal(bogeyPos)) {
                ms.m_85836_();
                CarriageContraptionEntityRenderer.translateBogey(ms, bogey, bogeySpacing, viewYRot, viewXRot, partialTicks);
                int light = CarriageContraptionEntityRenderer.getBogeyLightCoords(entity, bogey, partialTicks);
                bogey.type.render(null, bogey.wheelAngle.getValue(partialTicks), ms, partialTicks, buffers, light, overlay, bogey.getStyle(), bogey.bogeyData);
                ms.m_85849_();
            }
            bogey.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, partialTicks, bogey.isLeading);
            if (!carriage.isOnTwoBogeys()) {
                bogey.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, partialTicks, !bogey.isLeading);
            }
        });
    }

    public static void translateBogey(PoseStack ms, CarriageBogey bogey, int bogeySpacing, float viewYRot, float viewXRot, float partialTicks) {
        boolean selfUpsideDown = bogey.isUpsideDown();
        boolean leadingUpsideDown = bogey.carriage.leadingBogey().isUpsideDown();
        ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)(viewYRot + 90.0f))).rotateX((double)(-viewXRot))).rotateY(180.0)).translate(0.0, 0.0, bogey.isLeading ? 0.0 : (double)(-bogeySpacing))).rotateY(-180.0)).rotateX((double)viewXRot)).rotateY((double)(-viewYRot - 90.0f))).rotateY((double)bogey.yaw.getValue(partialTicks))).rotateX((double)bogey.pitch.getValue(partialTicks))).translate(0.0, 0.5, 0.0)).rotateZ(selfUpsideDown ? 180.0 : 0.0)).translateY(selfUpsideDown != leadingUpsideDown ? 2.0 : 0.0);
    }

    public static int getBogeyLightCoords(CarriageContraptionEntity entity, CarriageBogey bogey, float partialTicks) {
        BlockPos lightPos = new BlockPos(Objects.requireNonNullElseGet(bogey.getAnchorPosition(), () -> entity.m_7371_(partialTicks)));
        return LightTexture.m_109885_((int)entity.f_19853_.m_45517_(LightLayer.BLOCK, lightPos), (int)entity.f_19853_.m_45517_(LightLayer.SKY, lightPos));
    }
}

