/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structurepiece.bronzedungeon;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.resources.AetherFeatureStates;
import com.aetherteam.aether.world.structurepiece.AetherStructurePieceTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class BronzeDungeonSurfaceRuins
extends StructurePiece {
    private static final BlockStateProvider BLOCKS = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)((Block)AetherBlocks.HOLYSTONE.get()).m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true))), 3).m_146271_((Object)((BlockState)((Block)AetherBlocks.MOSSY_HOLYSTONE.get()).m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true))), 1).m_146270_());
    private static final BlockStateProvider TOPS = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)((Block)AetherBlocks.HOLYSTONE.get()).m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true))), 6).m_146271_((Object)((SlabBlock)AetherBlocks.HOLYSTONE_SLAB.get()).m_49966_(), 6).m_146271_((Object)((BlockState)((Block)AetherBlocks.MOSSY_HOLYSTONE.get()).m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true))), 3).m_146271_((Object)((SlabBlock)AetherBlocks.MOSSY_HOLYSTONE_SLAB.get()).m_49966_(), 3).m_146270_());
    private static final BlockStateProvider BOTTOMS = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)((Block)AetherBlocks.HOLYSTONE.get()).m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true))), 6).m_146271_((Object)((BlockState)((SlabBlock)AetherBlocks.HOLYSTONE_SLAB.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.TOP)), 6).m_146271_((Object)((BlockState)((Block)AetherBlocks.MOSSY_HOLYSTONE.get()).m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true))), 3).m_146271_((Object)((BlockState)((SlabBlock)AetherBlocks.MOSSY_HOLYSTONE_SLAB.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.TOP)), 3).m_146270_());
    private static final ConfiguredFeature<?, ? extends Feature<?>> MIXED_FLOWER_PATCH = new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)FeatureUtils.m_206470_((int)24, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)AetherFeatureStates.PURPLE_FLOWER, 1).m_146271_((Object)AetherFeatureStates.WHITE_FLOWER, 1))))));

    public BronzeDungeonSurfaceRuins(BoundingBox horizontalBounds) {
        super((StructurePieceType)AetherStructurePieceTypes.BRONZE_SURFACE_RUINS.get(), 0, horizontalBounds);
        this.m_73519_(Direction.SOUTH);
    }

    public BronzeDungeonSurfaceRuins(StructurePieceSerializationContext context, CompoundTag nbt) {
        super((StructurePieceType)AetherStructurePieceTypes.BRONZE_SURFACE_RUINS.get(), nbt);
        this.m_73519_(Direction.SOUTH);
    }

    public void m_213694_(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGen, RandomSource random, BoundingBox chunkBounds, ChunkPos chunkPos, BlockPos structureBottomCenter) {
        for (int x = this.f_73383_.m_162395_(); x <= this.f_73383_.m_162399_(); ++x) {
            this.generateTunnelWallColumn(level, random, chunkBounds, x, this.f_73383_.m_162398_());
            this.generateTunnelWallColumn(level, random, chunkBounds, x, this.f_73383_.m_162401_());
        }
        for (int z = this.f_73383_.m_162398_() + 1; z < this.f_73383_.m_162401_(); ++z) {
            this.generateTunnelWallColumn(level, random, chunkBounds, this.f_73383_.m_162395_(), z);
            this.generateTunnelWallColumn(level, random, chunkBounds, this.f_73383_.m_162399_(), z);
        }
        BlockPos pieceCenter = this.f_73383_.m_162394_();
        if (chunkBounds.m_71051_((Vec3i)pieceCenter)) {
            BlockPos aboveTopBlock = level.m_5452_(Heightmap.Types.OCEAN_FLOOR_WG, chunkBounds.m_162394_());
            MIXED_FLOWER_PATCH.m_224953_(level, chunkGen, random, aboveTopBlock);
        }
    }

    private void generateTunnelWallColumn(WorldGenLevel level, RandomSource random, BoundingBox chunkBounds, int x, int z) {
        if (!chunkBounds.m_71051_((Vec3i)new BlockPos(x, this.f_73383_.m_162396_(), z))) {
            return;
        }
        int trimmer = (x + z & 1) == 1 || random.m_188499_() ? random.m_188503_(4) + random.m_188503_(4) + 1 : 0;
        int wallColumnHeight = Math.max(random.m_188503_(2) - random.m_188503_(2) - trimmer, -2);
        int ySurfaceAir = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
        BlockPos wallColumnStart = new BlockPos(x, ySurfaceAir, z);
        this.placeColumnBlocks(level, random, this.scanColumnForPlacement(level, random, wallColumnHeight, ySurfaceAir, wallColumnStart));
        BlockPos topPos = wallColumnStart.m_6630_(wallColumnHeight);
        BlockStateProvider topProvider = wallColumnHeight < 1 ? BLOCKS : TOPS;
        level.m_7731_(topPos, topProvider.m_213972_(random, topPos), 3);
    }

    private void placeColumnBlocks(WorldGenLevel level, RandomSource random, List<BlockPos> forPlacement) {
        if (forPlacement.isEmpty()) {
            return;
        }
        BlockPos lastPos = forPlacement.get(0).m_7495_();
        for (BlockPos posAt : forPlacement) {
            boolean hasSkippedGap;
            boolean bl = hasSkippedGap = posAt.m_123342_() - lastPos.m_123342_() != 1;
            if (hasSkippedGap) {
                BlockStateProvider tailProvider = level.m_8055_(posAt).m_60795_() ? BOTTOMS : BLOCKS;
                level.m_7731_(posAt, tailProvider.m_213972_(random, posAt), 3);
                BlockPos capPos = lastPos.m_7494_();
                BlockStateProvider capProvider = level.m_8055_(capPos).m_60795_() ? TOPS : BLOCKS;
                level.m_7731_(capPos, capProvider.m_213972_(random, capPos), 3);
            } else {
                level.m_7731_(posAt, BLOCKS.m_213972_(random, posAt), 3);
            }
            lastPos = posAt;
        }
    }

    private List<BlockPos> scanColumnForPlacement(WorldGenLevel level, RandomSource random, int wallColumnHeight, int ySurfaceAir, BlockPos wallColumnStart) {
        int depthOffset = Math.round(random.m_188501_() * (float)wallColumnHeight);
        ArrayList<BlockPos> toPlace = new ArrayList<BlockPos>();
        for (int dY = this.f_73383_.m_162396_() - ySurfaceAir; dY < wallColumnHeight; ++dY) {
            BlockPos posAt = wallColumnStart.m_6630_(dY);
            BlockState blockAt = level.m_8055_(posAt);
            if (dY < -4 && (!blockAt.m_204336_(AetherTags.Blocks.AETHER_ISLAND_BLOCKS) && !blockAt.m_60795_() || !level.m_8055_(posAt.m_6625_(depthOffset)).m_204336_(AetherTags.Blocks.AETHER_ISLAND_BLOCKS))) continue;
            toPlace.add(posAt);
        }
        return toPlace;
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
    }
}

