/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.hooks;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherGameEvents;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.FreezingBlock;
import com.aetherteam.aether.blockentity.IcestoneBlockEntity;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.recipes.ban.BlockBanRecipe;
import com.aetherteam.aether.recipe.recipes.ban.ItemBanRecipe;
import com.aetherteam.aether.recipe.recipes.block.PlacementConversionRecipe;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class RecipeHooks {
    public static boolean checkInteractionBanned(Player player, Level level, BlockPos pos, Direction face, ItemStack stack, BlockState state, boolean spawnParticles) {
        if (RecipeHooks.isItemPlacementBanned(level, pos, face, stack, spawnParticles)) {
            player.m_5661_((Component)Component.m_237110_((String)"aether.banned_item", (Object[])new Object[]{stack.m_41720_().m_7626_(stack)}), true);
            return true;
        }
        if (level.m_204166_(pos).m_203656_(AetherTags.Biomes.ULTRACOLD) && ((Boolean)AetherConfig.SERVER.enable_bed_explosions.get()).booleanValue() && state.m_204336_(BlockTags.f_13038_) && state.m_60734_() != AetherBlocks.SKYROOT_BED.get()) {
            if (!level.m_5776_()) {
                BlockPos blockpos;
                if (state.m_61143_((Property)BedBlock.f_49440_) != BedPart.HEAD) {
                    pos = pos.m_121945_((Direction)state.m_61143_((Property)BedBlock.f_54117_));
                    state = level.m_8055_(pos);
                }
                if (level.m_8055_(blockpos = pos.m_121945_(((Direction)state.m_61143_((Property)BedBlock.f_54117_)).m_122424_())).m_204336_(BlockTags.f_13038_) && level.m_8055_(blockpos).m_60734_() != AetherBlocks.SKYROOT_BED.get()) {
                    level.m_7471_(blockpos, false);
                }
                level.m_7703_(null, DamageSource.m_19334_(), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5.0f, true, Explosion.BlockInteraction.DESTROY);
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
            return true;
        }
        return false;
    }

    public static boolean isItemPlacementBanned(Level level, BlockPos pos, Direction face, ItemStack stack, boolean spawnParticles) {
        for (Recipe recipe : level.m_7465_().m_44013_((RecipeType)AetherRecipeTypes.ITEM_PLACEMENT_BAN.get())) {
            ItemBanRecipe banRecipe;
            if (!(recipe instanceof ItemBanRecipe) || !(banRecipe = (ItemBanRecipe)recipe).banItem(level, pos, face, stack, spawnParticles)) continue;
            return true;
        }
        return false;
    }

    public static void checkExistenceBanned(LevelAccessor levelAccessor, BlockPos pos) {
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            BlockState state = levelAccessor.m_8055_(pos);
            if (RecipeHooks.isBlockPlacementBanned(level, pos, state)) {
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                if (state.m_60734_().m_5456_() != Items.f_41852_) {
                    Block.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
                }
            } else {
                RecipeHooks.isBlockPlacementConvertable(level, pos, state);
            }
        }
    }

    private static boolean isBlockPlacementBanned(Level level, BlockPos pos, BlockState state) {
        if (!level.m_5776_()) {
            for (Recipe recipe : level.m_7465_().m_44013_((RecipeType)AetherRecipeTypes.BLOCK_PLACEMENT_BAN.get())) {
                BlockBanRecipe banRecipe;
                if (!(recipe instanceof BlockBanRecipe) || !(banRecipe = (BlockBanRecipe)recipe).banBlock(level, pos, state)) continue;
                return true;
            }
        }
        return false;
    }

    private static void isBlockPlacementConvertable(Level level, BlockPos pos, BlockState state) {
        if (!level.m_5776_()) {
            for (Recipe recipe : level.m_7465_().m_44013_((RecipeType)AetherRecipeTypes.PLACEMENT_CONVERSION.get())) {
                PlacementConversionRecipe conversionRecipe;
                if (!(recipe instanceof PlacementConversionRecipe) || !(conversionRecipe = (PlacementConversionRecipe)recipe).convert(level, pos, state)) continue;
                return;
            }
        }
    }

    public static void banOrConvert(LevelAccessor accessor, BlockPos pos) {
        if (accessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)accessor;
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 1.0;
            double z = (double)pos.m_123343_() + 0.5;
            for (int i = 0; i < 10; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            serverLevel.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void sendIcestoneFreezableUpdateEvent(LevelAccessor accessor, BlockPos pos) {
        Level level;
        if (accessor instanceof Level && !(level = (Level)accessor).m_5776_()) {
            BlockState oldBlockState = level.m_8055_(pos);
            FreezingBlock.cacheRecipes(level);
            if (FreezingBlock.matchesCache(oldBlockState.m_60734_(), oldBlockState) != null) {
                level.m_142346_(null, (GameEvent)AetherGameEvents.ICESTONE_FREEZABLE_UPDATE.get(), pos);
            }
        }
    }

    public static boolean preventBlockFreezing(LevelAccessor accessor, BlockPos sourcePos, BlockPos pos) {
        BlockEntity blockEntity = accessor.m_7702_(sourcePos);
        if (blockEntity instanceof IcestoneBlockEntity) {
            IcestoneBlockEntity blockEntity2 = (IcestoneBlockEntity)blockEntity;
            for (Map.Entry entry : blockEntity2.getLastBrokenPositions().entrySet()) {
                if (!((BlockPos)entry.getKey()).equals((Object)pos) || (Integer)entry.getValue() <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

