/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.hooks;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.portal.AetherPortalForcer;
import com.aetherteam.aether.block.portal.AetherPortalShape;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.capability.time.AetherTime;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerGamePacketListenerImplAccessor;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerLevelAccessor;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.clientbound.AetherTravelPacket;
import com.aetherteam.aether.network.packet.clientbound.LeavingAetherPacket;
import com.aetherteam.aether.world.AetherLevelData;
import com.aetherteam.aether.world.LevelUtil;
import com.aetherteam.nitrogen.network.PacketRelay;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.simple.SimpleChannel;

public class DimensionHooks {
    public static boolean playerLeavingAether;
    public static boolean displayAetherTravel;
    public static int teleportationTimer;

    public static void startInAether(Player player) {
        AetherPlayer.get(player).ifPresent(aetherPlayer -> {
            if (((Boolean)AetherConfig.SERVER.spawn_in_aether.get()).booleanValue()) {
                ServerPlayer serverPlayer;
                MinecraftServer server;
                ServerLevel aetherLevel;
                Player patt3081$temp;
                if (aetherPlayer.canSpawnInAether() && (patt3081$temp = aetherPlayer.getPlayer()) instanceof ServerPlayer && (aetherLevel = (server = (serverPlayer = (ServerPlayer)patt3081$temp).m_9236_().m_7654_()).m_129880_(AetherDimensions.AETHER_LEVEL)) != null && serverPlayer.m_9236_().m_46472_() != AetherDimensions.AETHER_LEVEL && aetherPlayer.getPlayer().changeDimension(aetherLevel, (ITeleporter)new AetherPortalForcer(aetherLevel, false, true)) != null) {
                    serverPlayer.m_9158_(AetherDimensions.AETHER_LEVEL, serverPlayer.m_20183_(), serverPlayer.m_146908_(), true, false);
                    aetherPlayer.setCanSpawnInAether(false);
                }
            } else {
                aetherPlayer.setCanSpawnInAether(false);
            }
        });
    }

    public static boolean createPortal(Player player, Level level, BlockPos pos, @Nullable Direction direction, ItemStack stack, InteractionHand hand) {
        if (direction != null) {
            Optional<AetherPortalShape> optional;
            BlockPos relativePos = pos.m_121945_(direction);
            if (stack.m_204117_(AetherTags.Items.AETHER_PORTAL_ACTIVATION_ITEMS) && (level.m_46472_() == LevelUtil.returnDimension() || level.m_46472_() == LevelUtil.destinationDimension()) && (optional = AetherPortalShape.findEmptyAetherPortalShape((LevelAccessor)level, relativePos, Direction.Axis.X)).isPresent()) {
                optional.get().createPortalBlocks();
                player.m_5496_(SoundEvents.f_11778_, 1.0f, 1.0f);
                player.m_6674_(hand);
                if (!player.m_7500_()) {
                    if (stack.m_41613_() > 1) {
                        stack.m_41774_(1);
                        player.m_36356_(stack.hasCraftingRemainingItem() ? stack.getCraftingRemainingItem() : ItemStack.f_41583_);
                    } else if (stack.m_41763_()) {
                        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    } else {
                        player.m_21008_(hand, stack.hasCraftingRemainingItem() ? stack.getCraftingRemainingItem() : ItemStack.f_41583_);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static boolean detectWaterInFrame(LevelAccessor levelAccessor, BlockPos pos, BlockState blockState, FluidState fluidState) {
        if (levelAccessor instanceof Level) {
            Optional<AetherPortalShape> optional;
            Level level = (Level)levelAccessor;
            if (fluidState.m_192917_((Fluid)Fluids.f_76193_) && fluidState.m_76188_().m_60734_() == blockState.m_60734_() && (level.m_46472_() == LevelUtil.returnDimension() || level.m_46472_() == LevelUtil.destinationDimension()) && !((Boolean)AetherConfig.SERVER.disable_aether_portal.get()).booleanValue() && (optional = AetherPortalShape.findEmptyAetherPortalShape((LevelAccessor)level, pos, Direction.Axis.X)).isPresent()) {
                optional.get().createPortalBlocks();
                return true;
            }
        }
        return false;
    }

    public static void tickTime(Level level) {
        if (level.m_6042_().f_63837_().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.m_135782_()) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)serverLevel;
            com.aetherteam.aether.mixin.mixins.common.accessor.LevelAccessor levelAccessor = (com.aetherteam.aether.mixin.mixins.common.accessor.LevelAccessor)level;
            long i = levelAccessor.aether$getLevelData().m_6793_() + 1L;
            serverLevelAccessor.aether$getServerLevelData().m_6253_(i);
            if (serverLevelAccessor.aether$getServerLevelData().m_5470_().m_46207_(GameRules.f_46140_)) {
                AetherTime.get(level).ifPresent(cap -> serverLevel.m_8615_(cap.tickTime(level)));
            }
        }
    }

    public static void checkEternalDayConfig(Level level) {
        if (!level.m_5776_()) {
            AetherTime.get(level).ifPresent(aetherTime -> {
                boolean eternalDay = aetherTime.getEternalDay();
                if (((Boolean)AetherConfig.SERVER.disable_eternal_day.get()).booleanValue() && eternalDay) {
                    aetherTime.setEternalDay(false);
                    aetherTime.updateEternalDay();
                }
            });
        }
    }

    public static void dimensionTravel(Entity entity, ResourceKey<Level> dimension) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).m_9236_().m_5776_()) {
            AetherPlayer.get(player).ifPresent(aetherPlayer -> {
                if (!(((Boolean)AetherConfig.SERVER.spawn_in_aether.get()).booleanValue() && aetherPlayer.canSpawnInAether() || !entity.m_9236_().m_204166_(entity.m_20183_()).m_203656_(AetherTags.Biomes.DISPLAY_TRAVEL_TEXT))) {
                    if (entity.f_19853_.m_46472_() == LevelUtil.destinationDimension() && dimension == LevelUtil.returnDimension()) {
                        displayAetherTravel = true;
                        playerLeavingAether = true;
                        PacketRelay.sendToAll((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new AetherTravelPacket(true));
                        PacketRelay.sendToAll((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new LeavingAetherPacket(true));
                    } else if (entity.f_19853_.m_46472_() == LevelUtil.returnDimension() && dimension == LevelUtil.destinationDimension()) {
                        displayAetherTravel = true;
                        playerLeavingAether = false;
                        PacketRelay.sendToAll((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new AetherTravelPacket(true));
                        PacketRelay.sendToAll((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new LeavingAetherPacket(false));
                    } else {
                        displayAetherTravel = false;
                        PacketRelay.sendToAll((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new AetherTravelPacket(false));
                    }
                }
            });
        }
    }

    public static void travelling(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (teleportationTimer > 0) {
                ServerGamePacketListenerImplAccessor serverGamePacketListenerImplAccessor = (ServerGamePacketListenerImplAccessor)serverPlayer.f_8906_;
                serverGamePacketListenerImplAccessor.aether$setAboveGroundTickCount(0);
                serverGamePacketListenerImplAccessor.aether$setAboveGroundVehicleTickCount(0);
                --teleportationTimer;
            }
            if (teleportationTimer < 0 || serverPlayer.f_201939_) {
                teleportationTimer = 0;
            }
        }
    }

    public static void initializeLevelData(LevelAccessor level) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_6042_().f_63837_().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.m_135782_())) {
            AetherTime.get((Level)serverLevel).ifPresent(cap -> {
                AetherLevelData levelData = new AetherLevelData(serverLevel.m_7654_().m_129910_(), serverLevel.m_7654_().m_129910_().m_5996_(), cap.getDayTime());
                ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)serverLevel;
                com.aetherteam.aether.mixin.mixins.common.accessor.LevelAccessor levelAccessor = (com.aetherteam.aether.mixin.mixins.common.accessor.LevelAccessor)level;
                serverLevelAccessor.aether$setServerLevelData((ServerLevelData)levelData);
                levelAccessor.aether$setLevelData((WritableLevelData)levelData);
            });
        }
    }

    @Nullable
    public static Long finishSleep(LevelAccessor level, long newTime) {
        if (level instanceof ServerLevel && level.m_6042_().f_63837_().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.m_135782_())) {
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)level;
            serverLevelAccessor.aether$getServerLevelData().m_6399_(0);
            serverLevelAccessor.aether$getServerLevelData().m_5565_(false);
            serverLevelAccessor.aether$getServerLevelData().m_6398_(0);
            serverLevelAccessor.aether$getServerLevelData().m_5557_(false);
            long time = newTime + 48000L;
            return time - time % 72000L;
        }
        return null;
    }

    public static boolean isEternalDay(Player player) {
        Optional aetherTimeOptional;
        LazyOptional<AetherTime> aetherTimeLazy;
        if (player.m_9236_().m_6042_().f_63837_().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.m_135782_()) && (aetherTimeLazy = AetherTime.get(player.m_9236_())).isPresent() && (aetherTimeOptional = aetherTimeLazy.resolve()).isPresent()) {
            AetherTime aetherTime = (AetherTime)aetherTimeOptional.get();
            return aetherTime.getEternalDay();
        }
        return false;
    }
}

