/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.passive;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.api.AetherMoaTypes;
import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.WingedBird;
import com.aetherteam.aether.entity.ai.goal.ContinuousMeleeAttackGoal;
import com.aetherteam.aether.entity.ai.goal.FallingRandomStrollGoal;
import com.aetherteam.aether.entity.ai.goal.MoaFollowGoal;
import com.aetherteam.aether.entity.ai.navigator.FallPathNavigation;
import com.aetherteam.aether.entity.monster.AechorPlant;
import com.aetherteam.aether.entity.monster.Swet;
import com.aetherteam.aether.entity.passive.MountableAnimal;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.event.EggLayEvent;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.miscellaneous.MoaEggItem;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.clientbound.MoaInteractPacket;
import com.aetherteam.aether.perk.data.ServerPerkData;
import com.aetherteam.aether.perk.types.MoaData;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import com.aetherteam.nitrogen.network.PacketRelay;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.simple.SimpleChannel;

public class Moa
extends MountableAnimal
implements WingedBird {
    private static final EntityDataAccessor<Optional<UUID>> DATA_MOA_UUID_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<String> DATA_MOA_TYPE_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_RIDER_UUID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_LAST_RIDER_UUID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_JUMPS_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_HUNGRY_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_AMOUNT_FED_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_PLAYER_GROWN_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SITTING_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_FOLLOWING_ID = SynchedEntityData.m_135353_(Moa.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private float wingRotation;
    private float prevWingRotation;
    private float destPos;
    private float prevDestPos;
    private int jumpCooldown;
    private int flapCooldown;
    private int eggTime = this.getEggTime();

    public Moa(EntityType<? extends Moa> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 0.65));
        this.f_21345_.m_25352_(2, (Goal)new MoaFollowGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new ContinuousMeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new FallingRandomStrollGoal((PathfinderMob)this, 0.35));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Swet.class, false, livingEntity -> {
            Swet swet;
            return this.getFollowing() == null && this.isPlayerGrown() && !this.m_6162_() && livingEntity instanceof Swet && !(swet = (Swet)livingEntity).isFriendly();
        }));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AechorPlant.class, false, livingEntity -> this.getFollowing() == null && this.isPlayerGrown() && !this.m_6162_()));
    }

    protected PathNavigation m_6037_(Level level) {
        return new FallPathNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22281_, 5.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_MOA_UUID_ID, Optional.empty());
        this.m_20088_().m_135372_(DATA_MOA_TYPE_ID, (Object)"");
        this.m_20088_().m_135372_(DATA_RIDER_UUID, Optional.empty());
        this.m_20088_().m_135372_(DATA_LAST_RIDER_UUID, Optional.empty());
        this.m_20088_().m_135372_(DATA_REMAINING_JUMPS_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_HUNGRY_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_AMOUNT_FED_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_PLAYER_GROWN_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_SITTING_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_FOLLOWING_ID, Optional.empty());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        this.generateMoaUUID();
        if (tag != null) {
            MoaType moaType;
            if (tag.m_128441_("IsBaby")) {
                this.m_6863_(tag.m_128471_("IsBaby"));
            }
            if (tag.m_128441_("MoaType") && (moaType = AetherMoaTypes.get(tag.m_128461_("MoaType"))) != null) {
                this.setMoaType(moaType);
            }
            if (tag.m_128441_("Hungry")) {
                this.setHungry(tag.m_128471_("Hungry"));
            }
            if (tag.m_128441_("PlayerGrown")) {
                this.setPlayerGrown(tag.m_128471_("PlayerGrown"));
            }
        }
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        if (this.getMoaType() == null) {
            this.setMoaType(AetherMoaTypes.getWeightedChance(this.m_217043_()));
        }
        return super.m_6518_(level, difficulty, reason, spawnData, tag);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (DATA_SITTING_ID.equals(dataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(dataAccessor);
    }

    public void m_8107_() {
        super.m_8107_();
        this.animateWings();
    }

    @Override
    public void m_8119_() {
        LivingEntity livingEntity;
        super.m_8119_();
        AttributeInstance gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        if (gravity != null) {
            double max = this.m_20160_() ? -0.5 : -0.1;
            double fallSpeed = Math.max(gravity.m_22135_() * -1.25, max);
            if (this.m_20184_().m_7098_() < fallSpeed && !this.playerTriedToCrouch()) {
                this.m_20334_(this.m_20184_().m_7096_(), fallSpeed, this.m_20184_().m_7094_());
                this.f_19812_ = true;
                this.setEntityOnGround(false);
            }
        }
        if (this.m_20096_()) {
            this.setRemainingJumps(this.getMaxJumps());
        }
        if (this.getJumpCooldown() > 0) {
            this.setJumpCooldown(this.getJumpCooldown() - 1);
            this.setPlayerJumped(false);
        } else if (this.getJumpCooldown() == 0) {
            this.setMountJumping(false);
        }
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            if (this.m_217043_().m_188503_(900) == 0 && this.f_20919_ == 0) {
                this.m_5634_(1.0f);
            }
            if (!this.m_6162_() && this.m_20197_().isEmpty() && --this.eggTime <= 0) {
                EggLayEvent eggLayEvent;
                MoaType moaType = this.getMoaType();
                if (moaType != null && !(eggLayEvent = AetherEventDispatch.onLayEgg((Entity)this, (SoundEvent)AetherSoundEvents.ENTITY_MOA_EGG.get(), 1.0f, (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 1.0f, this.getMoaType().getEgg())).isCanceled()) {
                    if (eggLayEvent.getSound() != null) {
                        this.m_5496_(eggLayEvent.getSound(), eggLayEvent.getVolume(), eggLayEvent.getPitch());
                    }
                    if (eggLayEvent.getItem() != null) {
                        this.m_19998_((ItemLike)eggLayEvent.getItem());
                    }
                }
                this.eggTime = this.getEggTime();
            }
        }
        if (this.m_6162_()) {
            if (!this.isHungry()) {
                if (!this.m_9236_().m_5776_() && this.m_217043_().m_188503_(2000) == 0) {
                    this.setHungry(true);
                }
            } else if (this.m_217043_().m_188503_(10) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 1.0, this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
            }
        } else {
            this.setHungry(false);
            this.setAmountFed(0);
        }
        if ((livingEntity = this.getControllingPassenger()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.getRider() == null) {
                this.setRider(player.m_20148_());
            }
        } else if (this.getRider() != null) {
            this.setRider(null);
        }
        if (this.getFlapCooldown() > 0) {
            this.setFlapCooldown(this.getFlapCooldown() - 1);
        } else if (this.getFlapCooldown() == 0 && !this.m_20096_()) {
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)AetherSoundEvents.ENTITY_MOA_FLAP.get(), SoundSource.NEUTRAL, 0.15f, Mth.m_14036_((float)this.m_217043_().m_188501_(), (float)0.7f, (float)1.0f) + Mth.m_14036_((float)this.m_217043_().m_188501_(), (float)0.0f, (float)0.3f));
            this.setFlapCooldown(15);
        }
        EntityUtil.checkSlowFallDistance((Entity)this);
    }

    protected void m_20348_(Entity passenger) {
        if (passenger instanceof Player) {
            Player player = (Player)passenger;
            this.generateMoaUUID();
            if (this.getLastRider() == null || this.getLastRider() != player.m_20148_()) {
                this.setLastRider(player.m_20148_());
            }
            if (!player.m_9236_().m_5776_()) {
                AetherPlayer.get(player).ifPresent(aetherPlayer -> aetherPlayer.setSynched(INBTSynchable.Direction.CLIENT, "setLastRiddenMoa", this.getMoaUUID()));
                Map<UUID, MoaData> userSkinsData = ServerPerkData.MOA_SKIN_INSTANCE.getServerPerkData(player.m_20194_());
                if (userSkinsData.containsKey(this.getLastRider())) {
                    ServerPerkData.MOA_SKIN_INSTANCE.applyPerkWithVerification(player.m_20194_(), this.getLastRider(), new MoaData(this.getMoaUUID(), userSkinsData.get(this.getLastRider()).moaSkin()));
                }
            }
        }
        super.m_20348_(passenger);
    }

    @Override
    public void m_7023_(Vec3 vector) {
        if (!this.isSitting()) {
            super.m_7023_(vector);
        } else if (this.m_6084_()) {
            LivingEntity entity = this.getControllingPassenger();
            if (this.m_20160_() && this.m_6254_() && entity != null) {
                EntityUtil.copyRotations((Entity)this, (Entity)entity);
                if (this.m_6109_()) {
                    this.travelWithInput(new Vec3(0.0, vector.m_7098_(), 0.0));
                    this.f_20903_ = 0;
                } else {
                    this.m_21043_((LivingEntity)this, false);
                    this.m_20256_(Vec3.f_82478_);
                }
            } else {
                this.travelWithInput(new Vec3(0.0, vector.m_7098_(), 0.0));
            }
        }
    }

    @Override
    public void onJump(Mob mob) {
        super.onJump(mob);
        this.setJumpCooldown(10);
        if (!this.m_20096_()) {
            this.setRemainingJumps(this.getRemainingJumps() - 1);
            this.spawnExplosionParticle();
        }
        this.setFlapCooldown(0);
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (this.isPlayerGrown() && itemStack.m_150930_((Item)AetherItems.NATURE_STAFF.get())) {
            if (player.m_6144_()) {
                if (this.getFollowing() == null) {
                    this.setFollowing(player.m_20148_());
                } else {
                    this.setFollowing(null);
                }
            } else {
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                this.setSitting(!this.isSitting());
                this.spawnExplosionParticle();
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (this.isPlayerGrown() && itemStack.m_41619_() && player.m_6144_()) {
            if (this.getFollowing() == null) {
                this.setFollowing(player.m_20148_());
            } else {
                this.setFollowing(null);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (!this.m_9236_().m_5776_() && this.isPlayerGrown() && this.m_6162_() && this.isHungry() && this.getAmountFed() < 3 && itemStack.m_204117_(AetherTags.Items.MOA_FOOD_ITEMS)) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            this.setAmountFed(this.getAmountFed() + 1);
            switch (this.getAmountFed()) {
                case 0: {
                    this.m_146762_(-24000);
                    break;
                }
                case 1: {
                    this.m_146762_(-16000);
                    break;
                }
                case 2: {
                    this.m_146762_(-8000);
                    break;
                }
                case 3: {
                    this.m_6863_(false);
                }
            }
            if (this.getAmountFed() > 3 && !this.m_6162_()) {
                this.m_6863_(false);
            }
            this.setHungry(false);
            PacketRelay.sendToAll((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new MoaInteractPacket(player.m_19879_(), hand == InteractionHand.MAIN_HAND));
            return InteractionResult.CONSUME;
        }
        if (this.isPlayerGrown() && !this.m_6162_() && this.m_21223_() < this.m_21233_() && itemStack.m_204117_(AetherTags.Items.MOA_FOOD_ITEMS)) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            this.m_5634_(5.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    public void spawnExplosionParticle() {
        for (int i = 0; i < 20; ++i) {
            EntityUtil.spawnMovementExplosionParticles((Entity)this);
        }
    }

    public void generateMoaUUID() {
        if (this.getMoaUUID() == null) {
            this.setMoaUUID(UUID.randomUUID());
        }
    }

    @Nullable
    public UUID getMoaUUID() {
        return ((Optional)this.m_20088_().m_135370_(DATA_MOA_UUID_ID)).orElse(null);
    }

    private void setMoaUUID(@Nullable UUID uuid) {
        this.m_20088_().m_135381_(DATA_MOA_UUID_ID, Optional.ofNullable(uuid));
    }

    @Nullable
    public MoaType getMoaType() {
        return AetherMoaTypes.get((String)this.m_20088_().m_135370_(DATA_MOA_TYPE_ID));
    }

    public void setMoaType(MoaType moaType) {
        this.m_20088_().m_135381_(DATA_MOA_TYPE_ID, (Object)moaType.toString());
    }

    @Nullable
    public UUID getRider() {
        return ((Optional)this.m_20088_().m_135370_(DATA_RIDER_UUID)).orElse(null);
    }

    public void setRider(@Nullable UUID uuid) {
        this.m_20088_().m_135381_(DATA_RIDER_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public UUID getLastRider() {
        return ((Optional)this.m_20088_().m_135370_(DATA_LAST_RIDER_UUID)).orElse(null);
    }

    public void setLastRider(@Nullable UUID uuid) {
        this.m_20088_().m_135381_(DATA_LAST_RIDER_UUID, Optional.ofNullable(uuid));
    }

    public int getRemainingJumps() {
        return (Integer)this.m_20088_().m_135370_(DATA_REMAINING_JUMPS_ID);
    }

    public void setRemainingJumps(int remainingJumps) {
        this.m_20088_().m_135381_(DATA_REMAINING_JUMPS_ID, (Object)remainingJumps);
    }

    public boolean isHungry() {
        return (Boolean)this.m_20088_().m_135370_(DATA_HUNGRY_ID);
    }

    public void setHungry(boolean hungry) {
        this.m_20088_().m_135381_(DATA_HUNGRY_ID, (Object)hungry);
    }

    public int getAmountFed() {
        return (Integer)this.m_20088_().m_135370_(DATA_AMOUNT_FED_ID);
    }

    public void setAmountFed(int amountFed) {
        this.m_20088_().m_135381_(DATA_AMOUNT_FED_ID, (Object)amountFed);
    }

    public boolean isPlayerGrown() {
        return (Boolean)this.m_20088_().m_135370_(DATA_PLAYER_GROWN_ID);
    }

    public void setPlayerGrown(boolean playerGrown) {
        this.m_20088_().m_135381_(DATA_PLAYER_GROWN_ID, (Object)playerGrown);
    }

    public boolean isSitting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_SITTING_ID);
    }

    public void setSitting(boolean isSitting) {
        this.m_20088_().m_135381_(DATA_SITTING_ID, (Object)isSitting);
    }

    @Nullable
    public UUID getFollowing() {
        return ((Optional)this.m_20088_().m_135370_(DATA_FOLLOWING_ID)).orElse(null);
    }

    public void setFollowing(@Nullable UUID uuid) {
        this.m_20088_().m_135381_(DATA_FOLLOWING_ID, Optional.ofNullable(uuid));
    }

    @Override
    public float getWingRotation() {
        return this.wingRotation;
    }

    @Override
    public void setWingRotation(float rotation) {
        this.wingRotation = rotation;
    }

    @Override
    public float getPrevWingRotation() {
        return this.prevWingRotation;
    }

    @Override
    public void setPrevWingRotation(float rotation) {
        this.prevWingRotation = rotation;
    }

    @Override
    public float getWingDestPos() {
        return this.destPos;
    }

    @Override
    public void setWingDestPos(float pos) {
        this.destPos = pos;
    }

    @Override
    public float getPrevWingDestPos() {
        return this.prevDestPos;
    }

    @Override
    public void setPrevWingDestPos(float pos) {
        this.prevDestPos = pos;
    }

    public int getJumpCooldown() {
        return this.jumpCooldown;
    }

    public void setJumpCooldown(int jumpCooldown) {
        this.jumpCooldown = jumpCooldown;
    }

    public int getFlapCooldown() {
        return this.flapCooldown;
    }

    public void setFlapCooldown(int flapCooldown) {
        this.flapCooldown = flapCooldown;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_MOA_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_MOA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_MOA_DEATH.get();
    }

    @Override
    protected SoundEvent getSaddledSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_MOA_SADDLE.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_MOA_STEP.get(), 0.15f, 1.0f);
    }

    public int getMaxJumps() {
        MoaType moaType = this.getMoaType();
        return moaType != null ? moaType.getMaxJumps() : ((MoaType)AetherMoaTypes.BLUE.get()).getMaxJumps();
    }

    public int getEggTime() {
        return this.f_19796_.m_188503_(6000) + 6000;
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return (effect.m_19544_() != AetherEffects.INEBRIATION.get() || !this.isPlayerGrown()) && super.m_7301_(effect);
    }

    public float m_6113_() {
        MoaType moaType = this.getMoaType();
        return moaType != null ? moaType.getSpeed() : ((MoaType)AetherMoaTypes.BLUE.get()).getSpeed();
    }

    @Override
    public boolean canJump() {
        return this.getRemainingJumps() > 0 && this.getJumpCooldown() == 0;
    }

    @Override
    public boolean m_6741_() {
        return super.m_6741_() && this.isPlayerGrown();
    }

    @Override
    public double getMountJumpStrength() {
        return this.m_20096_() ? 0.95 : 0.9;
    }

    @Override
    public float getSteeringSpeed() {
        MoaType moaType = this.getMoaType();
        return moaType != null ? moaType.getSpeed() : ((MoaType)AetherMoaTypes.BLUE.get()).getSpeed();
    }

    @Override
    public float getFlyingSpeed() {
        if (this.m_20160_() && this.m_6254_()) {
            return this.getSteeringSpeed() * 0.45f;
        }
        return this.getSteeringSpeed() * 0.025f;
    }

    public int m_6056_() {
        return this.m_20096_() ? super.m_6056_() : 14;
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        return 0;
    }

    public double m_6048_() {
        return this.isSitting() ? 0.25 : 1.25;
    }

    public float m_6134_() {
        return 1.0f;
    }

    public EntityDimensions m_6972_(Pose pose) {
        EntityDimensions dimensions = super.m_6972_(pose);
        if (this.isSitting()) {
            dimensions = dimensions.m_20390_(1.0f, 0.5f);
        }
        if (this.m_6162_()) {
            dimensions = dimensions.m_20390_(1.0f, 0.5f);
        }
        return dimensions;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob entity) {
        return null;
    }

    public boolean m_35506_() {
        return false;
    }

    public void m_146762_(int age) {
        if (age % -8000 == 0 || age == 0 && this.getAmountFed() >= 3) {
            super.m_146762_(age);
        }
    }

    @Nullable
    public ItemStack m_142340_() {
        if (this.getMoaType() != null) {
            MoaEggItem moaEggItem = MoaEggItem.byId(this.getMoaType());
            return moaEggItem == null ? null : new ItemStack((ItemLike)moaEggItem);
        }
        return null;
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("MoaUUID")) {
            this.setMoaUUID(tag.m_128342_("MoaUUID"));
        }
        if (tag.m_128441_("IsBaby")) {
            this.m_6863_(tag.m_128471_("IsBaby"));
        }
        MoaType moaType = AetherMoaTypes.get(tag.m_128461_("MoaType"));
        if (tag.m_128441_("MoaType") && moaType != null) {
            this.setMoaType(moaType);
        } else {
            this.setMoaType(AetherMoaTypes.getWeightedChance(this.m_217043_()));
        }
        if (tag.m_128403_("Rider")) {
            this.setRider(tag.m_128342_("Rider"));
        }
        if (tag.m_128403_("LastRider")) {
            this.setLastRider(tag.m_128342_("LastRider"));
        }
        if (tag.m_128441_("RemainingJumps")) {
            this.setRemainingJumps(tag.m_128451_("RemainingJumps"));
        }
        if (tag.m_128441_("Hungry")) {
            this.setHungry(tag.m_128471_("Hungry"));
        }
        if (tag.m_128441_("AmountFed")) {
            this.setAmountFed(tag.m_128451_("AmountFed"));
        }
        if (tag.m_128441_("PlayerGrown")) {
            this.setPlayerGrown(tag.m_128471_("PlayerGrown"));
        }
        if (tag.m_128441_("Sitting")) {
            this.setSitting(tag.m_128471_("Sitting"));
        }
        if (tag.m_128441_("Following")) {
            this.setFollowing(tag.m_128342_("Following"));
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.getMoaUUID() != null) {
            tag.m_128362_("MoaUUID", this.getMoaUUID());
        }
        tag.m_128379_("IsBaby", this.m_6162_());
        tag.m_128359_("MoaType", Objects.requireNonNullElse(this.getMoaType(), AetherMoaTypes.BLUE).toString());
        if (this.getRider() != null) {
            tag.m_128362_("Rider", this.getRider());
        }
        if (this.getLastRider() != null) {
            tag.m_128362_("LastRider", this.getLastRider());
        }
        tag.m_128405_("RemainingJumps", this.getRemainingJumps());
        tag.m_128379_("Hungry", this.isHungry());
        tag.m_128405_("AmountFed", this.getAmountFed());
        tag.m_128379_("PlayerGrown", this.isPlayerGrown());
        tag.m_128379_("Sitting", this.isSitting());
        if (this.getFollowing() != null) {
            tag.m_128362_("Following", this.getFollowing());
        }
    }
}

