/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.hooks;

import com.aetherteam.aether.Aether;
import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.client.AetherKeys;
import com.aetherteam.aether.client.gui.component.inventory.AccessoryButton;
import com.aetherteam.aether.client.gui.component.skins.RefreshButton;
import com.aetherteam.aether.client.gui.screen.inventory.AccessoriesScreen;
import com.aetherteam.aether.client.gui.screen.perks.AetherCustomizationsScreen;
import com.aetherteam.aether.client.gui.screen.perks.MoaSkinsScreen;
import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.event.hooks.DimensionHooks;
import com.aetherteam.aether.inventory.menu.AccessoriesMenu;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.serverbound.OpenAccessoriesPacket;
import com.aetherteam.aether.perk.PerkUtil;
import com.aetherteam.nitrogen.api.users.User;
import com.aetherteam.nitrogen.api.users.UserData;
import com.aetherteam.nitrogen.network.PacketRelay;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Tuple;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import top.theillusivec4.curios.client.gui.CuriosScreen;

public class GuiHooks {
    public static final Map<UUID, Integer> BOSS_EVENTS = new HashMap<UUID, Integer>();
    private static boolean shouldAddButton = true;
    private static boolean generateTrivia = true;
    @Nullable
    private static Screen lastScreen = null;

    public static boolean isAccessoryButtonEnabled() {
        return (Boolean)AetherConfig.CLIENT.disable_accessory_button.get() == false && GuiHooks.areAccessoryTagsFilled();
    }

    private static boolean areAccessoryTagsFilled() {
        boolean flag = true;
        for (String string : AccessoriesMenu.AETHER_IDENTIFIERS) {
            ITagManager itemTags = ForgeRegistries.ITEMS.tags();
            if (itemTags == null || !itemTags.getTag(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("curios", string))).isEmpty()) continue;
            flag = false;
        }
        return flag;
    }

    @Nullable
    public static AccessoryButton setupAccessoryButton(Screen screen, Tuple<Integer, Integer> offsets) {
        AbstractContainerScreen<?> containerScreen = GuiHooks.canCreateAccessoryButtonForScreen(screen);
        if (containerScreen != null) {
            return new AccessoryButton(containerScreen, containerScreen.getGuiLeft() + (Integer)offsets.m_14418_(), containerScreen.getGuiTop() + (Integer)offsets.m_14419_(), AccessoriesScreen.ACCESSORIES_BUTTON);
        }
        return null;
    }

    @Nullable
    private static AbstractContainerScreen<?> canCreateAccessoryButtonForScreen(Screen screen) {
        if (screen instanceof InventoryScreen || screen instanceof CuriosScreen || screen instanceof CreativeModeInventoryScreen || screen instanceof AccessoriesScreen && shouldAddButton) {
            return (AbstractContainerScreen)screen;
        }
        if (screen instanceof AccessoriesScreen) {
            shouldAddButton = true;
        }
        return null;
    }

    public static ImageButton createSkinsButton(Screen screen) {
        int x = (Integer)AetherConfig.CLIENT.layout_perks_x.get();
        int y = (Integer)AetherConfig.CLIENT.layout_perks_y.get();
        return new ImageButton(screen.f_96543_ / 2 + x, screen.f_96544_ / 4 + 48 - 16 + y, 20, 20, 0, 0, 20, AccessoriesScreen.SKINS_BUTTON, 20, 40, pressed -> Minecraft.m_91087_().m_91152_((Screen)new MoaSkinsScreen(screen)), (button, poseStack, mouseX, mouseY) -> screen.m_96602_(poseStack, (Component)Component.m_237115_((String)"gui.aether.accessories.skins_button"), mouseX + 4, mouseY + 12), (Component)Component.m_237115_((String)"gui.aether.accessories.skins_button"));
    }

    public static ImageButton createCustomizationsButton(Screen screen) {
        User user = UserData.Client.getClientUser();
        if (user != null && (PerkUtil.hasDeveloperGlow().test(user) || PerkUtil.hasHalo().test(user))) {
            int x = (Integer)AetherConfig.CLIENT.layout_perks_x.get();
            int y = (Integer)AetherConfig.CLIENT.layout_perks_y.get();
            return new ImageButton(screen.f_96543_ / 2 + x, screen.f_96544_ / 4 + 72 - 16 + y, 20, 20, 0, 0, 20, AccessoriesScreen.CUSTOMIZATION_BUTTON, 20, 40, pressed -> Minecraft.m_91087_().m_91152_((Screen)new AetherCustomizationsScreen(screen)), (button, poseStack, mouseX, mouseY) -> screen.m_96602_(poseStack, (Component)Component.m_237115_((String)"gui.aether.accessories.customization_button"), mouseX + 4, mouseY + 12), (Component)Component.m_237115_((String)"gui.aether.accessories.customization_button"));
        }
        return null;
    }

    public static void drawTrivia(Screen screen, PoseStack poseStack) {
        GuiHooks.generateTrivia(screen);
        if (screen instanceof GenericDirtMessageScreen || screen instanceof LevelLoadingScreen || screen instanceof ReceivingLevelScreen) {
            Component triviaLine = Aether.TRIVIA_READER.getTriviaLine();
            if (triviaLine != null && ((Boolean)AetherConfig.CLIENT.enable_trivia.get()).booleanValue()) {
                Font font = Minecraft.m_91087_().f_91062_;
                int y = screen.f_96544_ - 7 - font.m_239133_((FormattedText)triviaLine, screen.f_96543_);
                for (FormattedCharSequence sequence : font.m_92923_((FormattedText)triviaLine, screen.f_96543_)) {
                    Screen.m_168749_((PoseStack)poseStack, (Font)font, (FormattedCharSequence)sequence, (int)(screen.f_96543_ / 2), (int)y, (int)0xFFFF99);
                    y += 9;
                }
            }
            if (screen != lastScreen && !Aether.TRIVIA_READER.getTrivia().isEmpty()) {
                Aether.TRIVIA_READER.randomizeTriviaIndex();
            }
        }
        lastScreen = screen;
    }

    private static void generateTrivia(Screen screen) {
        if (screen instanceof TitleScreen) {
            if (generateTrivia && Aether.TRIVIA_READER.getTrivia().isEmpty()) {
                Aether.TRIVIA_READER.generateTriviaList();
                generateTrivia = false;
            }
        } else if (screen instanceof LevelLoadingScreen && generateTrivia && Aether.TRIVIA_READER.getTrivia().isEmpty()) {
            Aether.TRIVIA_READER.generateTriviaList();
            generateTrivia = false;
        }
    }

    public static void drawAetherTravelMessage(Screen screen, PoseStack poseStack) {
        if (screen instanceof ReceivingLevelScreen || screen instanceof ProgressScreen) {
            if (Minecraft.m_91087_().f_91074_ != null && DimensionHooks.displayAetherTravel) {
                if (DimensionHooks.playerLeavingAether) {
                    Screen.m_93215_((PoseStack)poseStack, (Font)screen.getMinecraft().f_91062_, (Component)Component.m_237115_((String)"gui.aether.descending"), (int)(screen.f_96543_ / 2), (int)((Integer)AetherConfig.CLIENT.portal_text_y.get()), (int)0xFFFFFF);
                } else {
                    Screen.m_93215_((PoseStack)poseStack, (Font)screen.getMinecraft().f_91062_, (Component)Component.m_237115_((String)"gui.aether.ascending"), (int)(screen.f_96543_ / 2), (int)((Integer)AetherConfig.CLIENT.portal_text_y.get()), (int)0xFFFFFF);
                }
            }
        } else {
            DimensionHooks.displayAetherTravel = false;
        }
    }

    public static void handlePatreonRefreshRebound() {
        if (RefreshButton.reboundTimer > 0) {
            --RefreshButton.reboundTimer;
        }
        if (RefreshButton.reboundTimer < 0) {
            RefreshButton.reboundTimer = 0;
        }
    }

    public static void openAccessoryMenu() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && minecraft.m_91265_() == null && (minecraft.f_91080_ == null || minecraft.f_91080_.f_96546_) && !((Boolean)AetherConfig.CLIENT.disable_accessory_button.get()).booleanValue() && AetherKeys.OPEN_ACCESSORY_INVENTORY.m_90859_()) {
            PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new OpenAccessoriesPacket(ItemStack.f_41583_));
            shouldAddButton = false;
        }
    }

    public static void closeContainerMenu(int key, int action) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen abstractContainerScreen = (AbstractContainerScreen)screen;
            if (!(abstractContainerScreen.f_96546_ || ((Boolean)AetherConfig.CLIENT.disable_accessory_button.get()).booleanValue() || AetherKeys.OPEN_ACCESSORY_INVENTORY.getKey().m_84873_() != key || action != 1 && action != 2)) {
                abstractContainerScreen.m_7379_();
            }
        }
    }

    public static void drawBossHealthBar(PoseStack poseStack, int x, int y, LerpingBossEvent bossEvent) {
        AetherBossMob aetherBossMob;
        Entity entity;
        int entityID = BOSS_EVENTS.get(bossEvent.m_18860_());
        if (Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(entityID)) instanceof AetherBossMob && (aetherBossMob = (AetherBossMob)entity).getBossBarTexture() != null) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)aetherBossMob.getBossBarTexture());
            GuiHooks.drawBar(poseStack, x + 2, y + 2, (BossEvent)bossEvent);
            Component component = aetherBossMob.getBossName();
            int nameLength = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
            int nameX = Minecraft.m_91087_().m_91268_().m_85445_() / 2 - nameLength / 2;
            int nameY = y - 9;
            Minecraft.m_91087_().f_91062_.m_92763_(poseStack, component, (float)nameX, (float)nameY, 0xFFFFFF);
        }
    }

    public static void drawBar(PoseStack poseStack, int x, int y, BossEvent bossEvent) {
        GuiComponent.m_93143_((PoseStack)poseStack, (int)(x -= 37), (int)y, (int)-90, (float)0.0f, (float)16.0f, (int)256, (int)16, (int)256, (int)256);
        int health = (int)(bossEvent.m_142717_() * 256.0f);
        if (health > 0) {
            GuiComponent.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)-90, (float)0.0f, (float)0.0f, (int)health, (int)16, (int)256, (int)256);
        }
    }

    public static boolean isAetherBossBar(UUID uuid) {
        return BOSS_EVENTS.containsKey(uuid);
    }
}

