/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.api.AetherMenus;
import com.aetherteam.aether.client.AetherMenuUtil;
import com.aetherteam.aether.client.WorldDisplayHelper;
import com.aetherteam.aether.client.event.hooks.GuiHooks;
import com.aetherteam.aether.client.sound.MusicSoundInstance;
import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.mixin.mixins.client.accessor.BossHealthOverlayAccessor;
import com.aetherteam.cumulus.api.Menu;
import com.aetherteam.cumulus.api.Menus;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class AetherMusicManager {
    private static final int FADE_LIMIT = 50;
    private static final RandomSource random = RandomSource.m_216327_();
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final MusicManager musicManager = Minecraft.m_91087_().m_91397_();
    @Nullable
    private static SoundInstance currentMusic;
    private static int nextSongDelay;
    private static Integer fade;

    public static void tick() {
        Music music = AetherMusicManager.getSituationalMusic();
        Object object = currentMusic;
        if (object instanceof MusicSoundInstance) {
            MusicSoundInstance musicSoundInstance = (MusicSoundInstance)((Object)object);
            if (musicSoundInstance.isBossMusic()) {
                if (music == null || !AetherMusicManager.isAetherBossMusic(music)) {
                    if (fade == null) {
                        fade = 0;
                    }
                    musicSoundInstance.setVolume((float)Math.exp(-((double)fade.intValue() / 16.666666666666668)));
                    object = fade;
                    fade = fade + 1;
                    if (fade >= 50) {
                        fade = null;
                        minecraft.m_91106_().m_120399_(currentMusic);
                        currentMusic = null;
                        nextSongDelay = Math.min(Integer.MAX_VALUE, Mth.m_216271_((RandomSource)random, (int)((Integer)AetherConfig.CLIENT.music_backup_min_delay.get()), (int)((Integer)AetherConfig.CLIENT.music_backup_max_delay.get() / 2)));
                    }
                }
            } else if (music != null && AetherMusicManager.isAetherBossMusic(music)) {
                if (fade == null) {
                    fade = 0;
                }
                musicSoundInstance.setVolume((float)Math.exp(-((double)fade.intValue() / 16.666666666666668)));
                object = fade;
                fade = fade + 1;
                if (fade >= 50) {
                    fade = null;
                    minecraft.m_91106_().m_120399_(currentMusic);
                    currentMusic = null;
                    nextSongDelay = 16;
                }
            }
        }
        if (music != null) {
            if (currentMusic != null && fade == null) {
                if (!music.m_11631_().m_11660_().equals((Object)currentMusic.m_7904_()) && music.m_11642_()) {
                    minecraft.m_91106_().m_120399_(currentMusic);
                    nextSongDelay = Mth.m_216271_((RandomSource)random, (int)0, (int)(music.m_11636_() / 2));
                }
                if (!minecraft.m_91106_().m_120403_(currentMusic)) {
                    currentMusic = null;
                    nextSongDelay = Math.min(nextSongDelay, Mth.m_216271_((RandomSource)random, (int)music.m_11636_(), (int)music.m_11639_()));
                }
            }
            nextSongDelay = Math.min(nextSongDelay, music.m_11639_());
            if (currentMusic == null && nextSongDelay-- <= 0) {
                AetherMusicManager.startPlaying(music);
            }
        } else if (currentMusic == null || !minecraft.m_91106_().m_120403_(currentMusic)) {
            currentMusic = null;
            if (nextSongDelay-- <= 0) {
                nextSongDelay = Math.min(Integer.MAX_VALUE, Mth.m_216271_((RandomSource)random, (int)((Integer)AetherConfig.CLIENT.music_backup_min_delay.get()), (int)((Integer)AetherConfig.CLIENT.music_backup_max_delay.get())));
            }
        }
    }

    public static void startPlaying(Music music) {
        musicManager.m_120186_();
        currentMusic = AetherMusicManager.isAetherBossMusic(music) ? MusicSoundInstance.forBossMusic(music.m_11631_()) : MusicSoundInstance.forMusic(music.m_11631_());
        if (currentMusic.m_5891_() != SoundManager.f_120344_) {
            minecraft.m_91106_().m_120367_(currentMusic);
        }
        nextSongDelay = Integer.MAX_VALUE;
    }

    public static void stopPlaying() {
        if (currentMusic != null) {
            minecraft.m_91106_().m_120399_(currentMusic);
            currentMusic = null;
        }
        nextSongDelay += 100;
    }

    @Nullable
    public static SoundInstance getCurrentMusic() {
        return currentMusic;
    }

    @Nullable
    public static <T extends LivingEntity> Music getSituationalMusic() {
        if (!(AetherMusicManager.minecraft.f_91080_ instanceof WinScreen)) {
            if (AetherMusicManager.isAetherWorldPreviewEnabled()) {
                return ((Menu)AetherMenus.THE_AETHER.get()).getMusic();
            }
            if (AetherMusicManager.isVanillaWorldPreviewEnabled()) {
                return ((Menu)Menus.MINECRAFT.get()).getMusic();
            }
            if (AetherMusicManager.minecraft.f_91074_ != null) {
                if (AetherMusicManager.isAetherBossMusicActive()) {
                    Music bossMusic;
                    T boss = AetherMusicManager.getBossFromFight();
                    if (boss != null && boss.m_21223_() > 0.0f && (bossMusic = ((AetherBossMob)boss).getBossMusic()) != null) {
                        return ((AetherBossMob)boss).getBossMusic();
                    }
                } else {
                    Holder holder = AetherMusicManager.minecraft.f_91074_.m_9236_().m_204166_(AetherMusicManager.minecraft.f_91074_.m_20183_());
                    if (AetherMusicManager.isCreative((Holder<Biome>)holder, (Player)AetherMusicManager.minecraft.f_91074_)) {
                        return ((Biome)holder.m_203334_()).m_47566_().orElse(Musics.f_11651_);
                    }
                }
            }
        }
        return null;
    }

    public static boolean isAetherBossMusic(Music music) {
        Optional optionalResourceKey = Registry.f_122821_.m_7854_((Object)music.m_11631_());
        return optionalResourceKey.filter(soundEventResourceKey -> Registry.f_122821_.m_206081_(soundEventResourceKey).m_203656_(AetherTags.SoundEvents.BOSS_MUSIC)).isPresent();
    }

    public static boolean isAetherBossMusicActive() {
        return (Boolean)AetherConfig.CLIENT.disable_aether_boss_music.get() == false && !AetherMusicManager.getAetherBossFights().isEmpty() && AetherMusicManager.minecraft.f_91065_.m_93090_().m_93713_();
    }

    public static Map<UUID, LerpingBossEvent> getAetherBossFights() {
        return ((BossHealthOverlayAccessor)AetherMusicManager.minecraft.f_91065_.m_93090_()).getEvents().entrySet().stream().filter(entry -> GuiHooks.isAetherBossBar((UUID)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <T extends LivingEntity> T getBossFromFight() {
        for (Map.Entry<UUID, LerpingBossEvent> event : AetherMusicManager.getAetherBossFights().entrySet()) {
            UUID eventUUID = event.getKey();
            int entityId = GuiHooks.BOSS_EVENTS.get(eventUUID);
            Entity entity = AetherMusicManager.minecraft.f_91074_.m_9236_().m_6815_(entityId);
            if (!(entity instanceof LivingEntity) || !(entity instanceof AetherBossMob)) continue;
            return (T)((LivingEntity)entity);
        }
        return null;
    }

    public static boolean isAetherWorldPreviewEnabled() {
        return AetherMenuUtil.isAetherMenu() && AetherMusicManager.isWorldPreviewEnabled() && (Boolean)AetherConfig.CLIENT.disable_aether_world_preview_menu_music.get() == false;
    }

    public static boolean isVanillaWorldPreviewEnabled() {
        return AetherMenuUtil.isMinecraftMenu() && AetherMusicManager.isWorldPreviewEnabled() && (Boolean)AetherConfig.CLIENT.disable_vanilla_world_preview_menu_music.get() == false;
    }

    public static boolean isWorldPreviewEnabled() {
        return AetherMusicManager.minecraft.f_91074_ != null && WorldDisplayHelper.isActive();
    }

    public static boolean isCreative(Holder<Biome> holder, Player player) {
        return player.m_9236_().m_46472_() != Level.f_46430_ && player.m_9236_().m_46472_() != Level.f_46429_ && holder.m_203656_(AetherTags.Biomes.AETHER_MUSIC) && !musicManager.m_120187_(Musics.f_11650_) && (!player.m_5842_() || !holder.m_203656_(BiomeTags.f_215801_)) && player.m_150110_().f_35937_ && player.m_150110_().f_35936_;
    }

    static {
        nextSongDelay = 100;
        fade = null;
    }
}

