/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.capability.player;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.sound.PortalTriggerSoundInstance;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.miscellaneous.CloudMinion;
import com.aetherteam.aether.entity.miscellaneous.Parachute;
import com.aetherteam.aether.entity.passive.Aerbunny;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.item.miscellaneous.ParachuteItem;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.AetherPlayerSyncPacket;
import com.aetherteam.aether.network.packet.clientbound.CloudMinionPacket;
import com.aetherteam.aether.network.packet.clientbound.RemountAerbunnyPacket;
import com.aetherteam.aether.perk.CustomizationsOptions;
import com.aetherteam.aether.perk.data.ClientDeveloperGlowPerkData;
import com.aetherteam.aether.perk.data.ClientHaloPerkData;
import com.aetherteam.aether.perk.data.ClientMoaSkinPerkData;
import com.aetherteam.aether.perk.data.ServerPerkData;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import com.aetherteam.nitrogen.network.BasePacket;
import com.aetherteam.nitrogen.network.PacketRelay;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Triple;

public class AetherPlayerCapability
implements AetherPlayer {
    private final Player player;
    private static final UUID LIFE_SHARD_HEALTH_ID = UUID.fromString("E11710C8-4247-4CB6-B3B5-729CB34CFC1A");
    private boolean canGetPortal = true;
    private boolean canSpawnInAether = true;
    public boolean isInAetherPortal = false;
    public int aetherPortalTimer = 0;
    public float prevPortalAnimTime;
    public float portalAnimTime = 0.0f;
    private boolean isHitting;
    private boolean isMoving;
    private boolean isJumping;
    private boolean isGravititeJumpActive;
    private boolean seenSunSpiritDialogue;
    private int goldenDartCount;
    private int poisonDartCount;
    private int enchantedDartCount;
    private int removeGoldenDartTime;
    private int removePoisonDartTime;
    private int removeEnchantedDartTime;
    private int remedyStartDuration;
    private int impactedMaximum;
    private int impactedTimer;
    private boolean performVampireHealing;
    @Nullable
    private Aerbunny mountedAerbunny;
    @Nullable
    private CompoundTag mountedAerbunnyTag;
    @Nullable
    private UUID lastRiddenMoa;
    private final List<CloudMinion> cloudMinions = new ArrayList<CloudMinion>(2);
    private int wingRotationO;
    private int wingRotation;
    private int invisibilityAttackCooldown;
    private boolean attackedWithInvisibility;
    private boolean invisibilityEnabled = true;
    private boolean wearingInvisibilityCloak;
    private static final int FLIGHT_TIMER_MAX = 52;
    private static final float FLIGHT_MODIFIER_MAX = 15.0f;
    private int flightTimer;
    private float flightModifier = 1.0f;
    private double neptuneSubmergeLength;
    private double phoenixSubmergeLength;
    private static final int OBSIDIAN_TIMER_MAX = 20;
    private int obsidianConversionTime;
    private float savedHealth = 0.0f;
    private int lifeShards;
    private static final ResourceLocation LOGOMARKS = new ResourceLocation("aether", "logomarks");
    private static final Style DISCORD = Style.f_131099_.m_178520_(5793266).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/aethermod")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"https://discord.gg/aethermod")));
    private static final Style PATREON = Style.f_131099_.m_178520_(16728653).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.patreon.com/TheAetherTeam")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"https://www.patreon.com/TheAetherTeam")));
    private boolean canShowPatreonMessage = true;
    private int loginsUntilPatreonMessage = -1;
    private final Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> synchableFunctions = Map.ofEntries(Map.entry("setHitting", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setHitting((Boolean)object), this::isHitting)), Map.entry("setMoving", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setMoving((Boolean)object), this::isMoving)), Map.entry("setJumping", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setJumping((Boolean)object), this::isJumping)), Map.entry("setGravititeJumpActive", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setGravititeJumpActive((Boolean)object), this::isGravititeJumpActive)), Map.entry("setGoldenDartCount", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setGoldenDartCount((Integer)object), this::getGoldenDartCount)), Map.entry("setPoisonDartCount", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setPoisonDartCount((Integer)object), this::getPoisonDartCount)), Map.entry("setEnchantedDartCount", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setEnchantedDartCount((Integer)object), this::getEnchantedDartCount)), Map.entry("setRemedyStartDuration", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setRemedyStartDuration((Integer)object), this::getRemedyStartDuration)), Map.entry("setAttackedWithInvisibility", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setAttackedWithInvisibility((Boolean)object), this::attackedWithInvisibility)), Map.entry("setInvisibilityEnabled", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setInvisibilityEnabled((Boolean)object), this::isInvisibilityEnabled)), Map.entry("setWearingInvisibilityCloak", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setWearingInvisibilityCloak((Boolean)object), this::isWearingInvisibilityCloak)), Map.entry("setLifeShardCount", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setLifeShardCount((Integer)object), this::getLifeShardCount)), Map.entry("setLastRiddenMoa", Triple.of((Object)INBTSynchable.Type.UUID, object -> this.setLastRiddenMoa((UUID)object), this::getLastRiddenMoa)), Map.entry("setShouldSyncBetweenClients", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setShouldSyncBetweenClients((Boolean)object), this::shouldSyncBetweenClients)));
    private boolean shouldSyncAfterJoin;
    private boolean shouldSyncBetweenClients;

    public AetherPlayerCapability(Player player) {
        this.player = player;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("CanGetPortal", this.canGetPortal());
        tag.m_128379_("CanSpawnInAether", this.canSpawnInAether());
        tag.m_128350_("SavedHealth", this.getSavedHealth());
        tag.m_128405_("LifeShardCount", this.getLifeShardCount());
        tag.m_128379_("HasSeenSunSpirit", this.hasSeenSunSpiritDialogue());
        tag.m_128405_("RemedyStartDuration", this.getRemedyStartDuration());
        if (this.getMountedAerbunnyTag() != null) {
            tag.m_128365_("MountedAerbunnyTag", (Tag)this.getMountedAerbunnyTag());
        }
        if (this.getLastRiddenMoa() != null) {
            tag.m_128362_("LastRiddenMoa", this.getLastRiddenMoa());
        }
        tag.m_128379_("CanShowPatreonMessage", this.canShowPatreonMessage);
        tag.m_128405_("LoginsUntilPatreonMessage", this.loginsUntilPatreonMessage);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("CanGetPortal")) {
            this.setCanGetPortal(tag.m_128471_("CanGetPortal"));
        }
        if (tag.m_128441_("CanSpawnInAether")) {
            this.setCanSpawnInAether(tag.m_128471_("CanSpawnInAether"));
        }
        if (tag.m_128441_("SavedHealth")) {
            this.setSavedHealth(tag.m_128457_("SavedHealth"));
        }
        if (tag.m_128441_("LifeShardCount")) {
            this.setLifeShardCount(tag.m_128451_("LifeShardCount"));
        }
        if (tag.m_128441_("HasSeenSunSpirit")) {
            this.setSeenSunSpiritDialogue(tag.m_128471_("HasSeenSunSpirit"));
        }
        if (tag.m_128441_("RemedyStartDuration")) {
            this.setRemedyStartDuration(tag.m_128451_("RemedyStartDuration"));
        }
        if (tag.m_128441_("MountedAerbunnyTag")) {
            this.setMountedAerbunnyTag(tag.m_128469_("MountedAerbunnyTag"));
        }
        if (tag.m_128441_("LastRiddenMoa")) {
            this.setLastRiddenMoa(tag.m_128342_("LastRiddenMoa"));
        }
        if (tag.m_128441_("CanShowPatreonMessage")) {
            this.canShowPatreonMessage = tag.m_128471_("CanShowPatreonMessage");
        }
        if (tag.m_128441_("LoginsUntilPatreonMessage")) {
            this.loginsUntilPatreonMessage = tag.m_128451_("LoginsUntilPatreonMessage");
        }
    }

    public Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> getSynchableFunctions() {
        return this.synchableFunctions;
    }

    @Override
    public void onLogout() {
        this.removeAerbunny();
        this.handleLogoutSavedHealth();
    }

    @Override
    public void onLogin() {
        this.handleGivePortal();
        this.remountAerbunny();
        this.handlePatreonMessage();
        this.shouldSyncAfterJoin = true;
        ServerPerkData.MOA_SKIN_INSTANCE.syncFromServer(this.getPlayer());
        ServerPerkData.HALO_INSTANCE.syncFromServer(this.getPlayer());
        ServerPerkData.DEVELOPER_GLOW_INSTANCE.syncFromServer(this.getPlayer());
    }

    @Override
    public void onJoinLevel() {
        if (this.getPlayer().m_9236_().m_5776_()) {
            CustomizationsOptions.INSTANCE.load();
            this.setSynched(INBTSynchable.Direction.SERVER, "setShouldSyncBetweenClients", true);
        }
    }

    @Override
    public void copyFrom(AetherPlayer other, boolean isWasDeath) {
        if (!isWasDeath) {
            this.setRemedyStartDuration(other.getRemedyStartDuration());
            this.setProjectileImpactedMaximum(other.getProjectileImpactedMaximum());
            this.setProjectileImpactedTimer(other.getProjectileImpactedTimer());
        }
        this.setCanGetPortal(other.canGetPortal());
        this.setLifeShardCount(other.getLifeShardCount());
        this.handleCopyingSavedHealth(other, isWasDeath);
        this.shouldSyncAfterJoin = true;
    }

    @Override
    public void onUpdate() {
        this.syncAfterJoin();
        this.syncClients();
        this.handleAetherPortal();
        this.activateParachute();
        this.handleRemoveDarts();
        this.removeRemedyDuration();
        this.tickDownProjectileImpact();
        this.handleWingRotation();
        this.handleAttackCooldown();
        this.handleVampireHealing();
        this.checkToRemoveAerbunny();
        this.checkToRemoveCloudMinions();
        this.handleSavedHealth();
        this.handleLifeShardModifier();
        ClientMoaSkinPerkData.INSTANCE.syncFromClient(this.getPlayer());
        ClientHaloPerkData.INSTANCE.syncFromClient(this.getPlayer());
        ClientDeveloperGlowPerkData.INSTANCE.syncFromClient(this.getPlayer());
    }

    private void syncAfterJoin() {
        if (this.shouldSyncAfterJoin) {
            this.forceSync(INBTSynchable.Direction.CLIENT);
            this.shouldSyncAfterJoin = false;
        }
    }

    private void syncClients() {
        if (this.shouldSyncBetweenClients()) {
            MinecraftServer server;
            if (!this.getPlayer().m_9236_().m_5776_() && (server = this.getPlayer().m_9236_().m_7654_()) != null) {
                PlayerList playerList = server.m_6846_();
                for (ServerPlayer serverPlayer : playerList.m_11314_()) {
                    if (serverPlayer.m_20148_().equals(this.getPlayer().m_20148_())) continue;
                    AetherPlayer.get((Player)serverPlayer).ifPresent(aetherPlayer -> {
                        if (aetherPlayer instanceof AetherPlayerCapability) {
                            AetherPlayerCapability capability = (AetherPlayerCapability)aetherPlayer;
                            capability.forceSync(INBTSynchable.Direction.CLIENT);
                        }
                    });
                }
            }
            this.setShouldSyncBetweenClients(false);
        }
    }

    @Override
    public void setCanSpawnInAether(boolean canSpawnInAether) {
        this.canSpawnInAether = canSpawnInAether;
    }

    @Override
    public boolean canSpawnInAether() {
        return this.canSpawnInAether;
    }

    private void handleGivePortal() {
        if (((Boolean)AetherConfig.COMMON.start_with_portal.get()).booleanValue()) {
            this.givePortalItem();
        } else {
            this.setCanGetPortal(false);
        }
    }

    private void handleAetherPortal() {
        if (this.getPlayer().m_9236_().m_5776_()) {
            this.prevPortalAnimTime = this.portalAnimTime;
            Minecraft minecraft = Minecraft.m_91087_();
            if (this.isInAetherPortal) {
                if (minecraft.f_91080_ != null && !minecraft.f_91080_.m_7043_()) {
                    if (minecraft.f_91080_ instanceof AbstractContainerScreen) {
                        this.getPlayer().m_6915_();
                    }
                    minecraft.m_91152_(null);
                }
                if (this.getPortalAnimTime() == 0.0f) {
                    this.playPortalSound(minecraft);
                }
            }
        }
        if (this.isInPortal()) {
            ++this.aetherPortalTimer;
            if (this.getPlayer().m_9236_().m_5776_()) {
                this.portalAnimTime += 0.0125f;
                if (this.getPortalAnimTime() > 1.0f) {
                    this.portalAnimTime = 1.0f;
                }
            }
            this.isInAetherPortal = false;
        } else {
            if (this.getPlayer().m_9236_().m_5776_()) {
                if (this.getPortalAnimTime() > 0.0f) {
                    this.portalAnimTime -= 0.05f;
                }
                if (this.getPortalAnimTime() < 0.0f) {
                    this.portalAnimTime = 0.0f;
                }
            }
            if (this.getPortalTimer() > 0) {
                this.aetherPortalTimer -= 4;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playPortalSound(Minecraft minecraft) {
        minecraft.m_91106_().m_120367_((SoundInstance)PortalTriggerSoundInstance.forLocalAmbience(this.player, (SoundEvent)AetherSoundEvents.BLOCK_AETHER_PORTAL_TRIGGER.get(), this.player.m_217043_().m_188501_() * 0.4f + 0.8f, 0.25f));
    }

    private void activateParachute() {
        Player player = this.getPlayer();
        Inventory inventory = this.getPlayer().m_150109_();
        Level level = player.m_9236_();
        if (!player.m_7500_() && !player.m_6144_() && !player.m_21255_() && !player.m_20159_() && player.m_20184_().m_7098_() < -1.5 && inventory.m_204075_(AetherTags.Items.DEPLOYABLE_PARACHUTES)) {
            for (ItemStack stack : inventory.f_35974_) {
                ParachuteItem parachuteItem;
                Parachute parachute;
                Item item = stack.m_41720_();
                if (!(item instanceof ParachuteItem) || (parachute = (Parachute)(parachuteItem = (ParachuteItem)item).getParachuteEntity().get().m_20615_(level)) == null) continue;
                parachute.m_6034_(player.m_20185_(), player.m_20186_() - 1.0, player.m_20189_());
                parachute.m_20256_(player.m_20184_());
                if (!level.m_5776_()) {
                    level.m_7967_((Entity)parachute);
                    player.m_20329_((Entity)parachute);
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                }
                parachute.spawnExplosionParticle();
                break;
            }
        }
    }

    private void handleRemoveDarts() {
        if (!this.getPlayer().m_9236_().m_5776_()) {
            if (this.getGoldenDartCount() > 0) {
                if (this.removeGoldenDartTime <= 0) {
                    this.removeGoldenDartTime = 20 * (30 - this.getGoldenDartCount());
                }
                --this.removeGoldenDartTime;
                if (this.removeGoldenDartTime <= 0) {
                    this.setSynched(INBTSynchable.Direction.CLIENT, "setGoldenDartCount", this.getGoldenDartCount() - 1);
                }
            }
            if (this.getPoisonDartCount() > 0) {
                if (this.removePoisonDartTime <= 0) {
                    this.removePoisonDartTime = 20 * (30 - this.getPoisonDartCount());
                }
                --this.removePoisonDartTime;
                if (this.removePoisonDartTime <= 0) {
                    this.setSynched(INBTSynchable.Direction.CLIENT, "setPoisonDartCount", this.getPoisonDartCount() - 1);
                }
            }
            if (this.getEnchantedDartCount() > 0) {
                if (this.removeEnchantedDartTime <= 0) {
                    this.removeEnchantedDartTime = 20 * (30 - this.getEnchantedDartCount());
                }
                --this.removeEnchantedDartTime;
                if (this.removeEnchantedDartTime <= 0) {
                    this.setSynched(INBTSynchable.Direction.CLIENT, "setEnchantedDartCount", this.getEnchantedDartCount() - 1);
                }
            }
        }
    }

    private void removeRemedyDuration() {
        if (this.remedyStartDuration > 0 && !this.getPlayer().m_21023_((MobEffect)AetherEffects.REMEDY.get())) {
            this.remedyStartDuration = 0;
        }
    }

    private void tickDownProjectileImpact() {
        if (this.getPlayer().m_9236_().m_5776_()) {
            if (this.getProjectileImpactedTimer() > 0) {
                this.setProjectileImpactedTimer(this.getProjectileImpactedTimer() - 1);
            } else {
                this.setProjectileImpactedMaximum(0);
                this.setProjectileImpactedTimer(0);
            }
        }
    }

    private void handleWingRotation() {
        if (this.getPlayer().m_9236_().m_5776_()) {
            this.wingRotationO = this.getWingRotation();
            this.wingRotation = EquipmentUtil.hasFullValkyrieSet((LivingEntity)this.getPlayer()) ? this.getPlayer().f_19797_ : 0;
        }
    }

    private void handleAttackCooldown() {
        if (!this.getPlayer().m_9236_().m_5776_()) {
            if (this.attackedWithInvisibility()) {
                --this.invisibilityAttackCooldown;
                if (this.invisibilityAttackCooldown <= 0) {
                    this.setSynched(INBTSynchable.Direction.CLIENT, "setAttackedWithInvisibility", false);
                }
            } else {
                this.invisibilityAttackCooldown = (Integer)AetherConfig.SERVER.invisibility_visibility_time.get();
            }
        }
    }

    private void handleVampireHealing() {
        if (!this.getPlayer().m_9236_().m_5776_() && this.performVampireHealing()) {
            this.getPlayer().m_5634_(1.0f);
            this.setVampireHealing(false);
        }
    }

    private void checkToRemoveAerbunny() {
        if (!(this.getMountedAerbunny() == null || this.getMountedAerbunny().m_6084_() && this.getPlayer().m_6084_())) {
            this.setMountedAerbunny(null);
        }
    }

    private void removeAerbunny() {
        if (this.getMountedAerbunny() != null) {
            Aerbunny aerbunny = this.getMountedAerbunny();
            CompoundTag nbt = new CompoundTag();
            aerbunny.m_20223_(nbt);
            this.setMountedAerbunnyTag(nbt);
            aerbunny.m_8127_();
            aerbunny.m_142467_(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        }
    }

    private void remountAerbunny() {
        if (this.getMountedAerbunnyTag() != null) {
            if (!this.getPlayer().m_9236_().m_5776_()) {
                Aerbunny aerbunny = new Aerbunny((EntityType<? extends Aerbunny>)((EntityType)AetherEntityTypes.AERBUNNY.get()), this.getPlayer().m_9236_());
                aerbunny.m_20258_(this.getMountedAerbunnyTag());
                this.getPlayer().m_9236_().m_7967_((Entity)aerbunny);
                aerbunny.m_20329_((Entity)this.getPlayer());
                this.setMountedAerbunny(aerbunny);
                Player player = this.getPlayer();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new RemountAerbunnyPacket(this.getPlayer().m_19879_(), aerbunny.m_19879_()), (ServerPlayer)serverPlayer);
                }
            }
            this.setMountedAerbunnyTag(null);
        }
    }

    private void checkToRemoveCloudMinions() {
        this.getCloudMinions().removeIf(cloudMinion -> !cloudMinion.m_6084_());
    }

    private void handleSavedHealth() {
        AttributeInstance health;
        if (this.getSavedHealth() > 0.0f && (health = this.getPlayer().m_21051_(Attributes.f_22276_)) != null && health.m_22109_(this.getLifeShardHealthAttributeModifier())) {
            if (this.getSavedHealth() >= this.getPlayer().m_21233_()) {
                this.getPlayer().m_21153_(this.getPlayer().m_21233_());
            } else {
                this.getPlayer().m_21153_(this.getSavedHealth());
            }
            this.setSavedHealth(0.0f);
        }
    }

    private void handleLifeShardModifier() {
        if (!this.getPlayer().m_9236_().m_5776_()) {
            AttributeInstance health = this.getPlayer().m_21051_(Attributes.f_22276_);
            AttributeModifier lifeShardHealth = this.getLifeShardHealthAttributeModifier();
            if (health != null) {
                if (health.m_22109_(lifeShardHealth)) {
                    health.m_22130_(lifeShardHealth);
                }
                health.m_22118_(lifeShardHealth);
            }
        }
    }

    private void handleLogoutSavedHealth() {
        AttributeInstance health = this.getPlayer().m_21051_(Attributes.f_22276_);
        if (health != null && health.m_22109_(this.getLifeShardHealthAttributeModifier())) {
            this.setSavedHealth(this.getPlayer().m_21223_());
        }
    }

    private void handleCopyingSavedHealth(AetherPlayer other, boolean isWasDeath) {
        if (!isWasDeath) {
            this.setSavedHealth(other.getPlayer().m_21223_());
        } else if (this.getPlayer().m_21223_() == this.getPlayer().m_21233_()) {
            this.setSavedHealth(1024.0f);
        }
    }

    private void handlePatreonMessage() {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (((Boolean)AetherConfig.COMMON.show_patreon_message.get()).booleanValue() && this.canShowPatreonMessage) {
                if (this.loginsUntilPatreonMessage < 0 && serverPlayer.m_9236_().m_46472_() == AetherDimensions.AETHER_LEVEL && (serverPlayer.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)((EntityType)AetherEntityTypes.SLIDER.get()))) > 0 || serverPlayer.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)((EntityType)AetherEntityTypes.VALKYRIE_QUEEN.get()))) > 0 || serverPlayer.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)((EntityType)AetherEntityTypes.SUN_SPIRIT.get()))) > 0)) {
                    this.loginsUntilPatreonMessage = serverPlayer.m_217043_().m_188503_(2);
                }
                if (this.loginsUntilPatreonMessage == 0) {
                    this.sendPatreonMessage(serverPlayer);
                    this.canShowPatreonMessage = false;
                    AetherConfig.COMMON.show_patreon_message.set((Object)false);
                    AetherConfig.COMMON.show_patreon_message.save();
                } else if (this.loginsUntilPatreonMessage > 0) {
                    --this.loginsUntilPatreonMessage;
                }
            } else if (!((Boolean)AetherConfig.COMMON.show_patreon_message.get()).booleanValue()) {
                this.canShowPatreonMessage = false;
            }
        }
    }

    private void sendPatreonMessage(ServerPlayer serverPlayer) {
        MutableComponent component = Component.m_237115_((String)"gui.aether.patreon.message");
        List<String> unlinkedBodyArray = Arrays.stream(component.getString().split("(?=(%s1))|(?<=(%s1))|(?=(%s2))|(?<=(%s2))|(?=(%s3))|(?<=(%s3))")).toList();
        List<MutableComponent> bodyArray = unlinkedBodyArray.stream().map(string -> switch (string) {
            case "%s1" -> Component.m_237113_((String)"The Aether").m_6270_(Style.f_131099_.m_178520_(8445183).m_131155_(Boolean.valueOf(true)));
            case "%s2" -> Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)"! ").m_6270_(DISCORD.m_131150_(LOGOMARKS))).m_7220_((Component)Component.m_237113_((String)"Discord").m_6270_(DISCORD));
            case "%s3" -> Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)", ").m_6270_(PATREON.m_131150_(LOGOMARKS))).m_7220_((Component)Component.m_237113_((String)"Patreon").m_6270_(PATREON));
            default -> Component.m_237113_((String)string);
        }).toList();
        MutableComponent message = Component.m_237113_((String)"");
        bodyArray.forEach(arg_0 -> ((MutableComponent)message).m_7220_(arg_0));
        serverPlayer.m_213846_((Component)message);
        MutableComponent note = Component.m_237115_((String)"gui.aether.patreon.note").m_6270_(Style.f_131099_.m_178520_(0x747474).m_131155_(Boolean.valueOf(true)));
        serverPlayer.m_213846_((Component)note);
    }

    @Override
    public void givePortalItem() {
        if (this.canGetPortal()) {
            this.getPlayer().m_36356_(new ItemStack((ItemLike)AetherItems.AETHER_PORTAL_FRAME.get()));
            this.setCanGetPortal(false);
        }
    }

    @Override
    public void setCanGetPortal(boolean canGetPortal) {
        this.canGetPortal = canGetPortal;
    }

    @Override
    public boolean canGetPortal() {
        return this.canGetPortal;
    }

    @Override
    public void setInPortal(boolean inPortal) {
        this.isInAetherPortal = inPortal;
    }

    @Override
    public boolean isInPortal() {
        return this.isInAetherPortal;
    }

    @Override
    public void setPortalTimer(int timer) {
        this.aetherPortalTimer = timer;
    }

    @Override
    public int getPortalTimer() {
        return this.aetherPortalTimer;
    }

    @Override
    public float getPortalAnimTime() {
        return this.portalAnimTime;
    }

    @Override
    public float getPrevPortalAnimTime() {
        return this.prevPortalAnimTime;
    }

    @Override
    public void setHitting(boolean isHitting) {
        this.isHitting = isHitting;
    }

    @Override
    public boolean isHitting() {
        return this.isHitting;
    }

    @Override
    public void setMoving(boolean isMoving) {
        this.isMoving = isMoving;
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }

    @Override
    public void setJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    @Override
    public boolean isJumping() {
        return this.isJumping;
    }

    @Override
    public void setGravititeJumpActive(boolean isGravititeJumpActive) {
        this.isGravititeJumpActive = isGravititeJumpActive;
    }

    @Override
    public boolean isGravititeJumpActive() {
        return this.isGravititeJumpActive;
    }

    @Override
    public void setSeenSunSpiritDialogue(boolean seenDialogue) {
        this.seenSunSpiritDialogue = seenDialogue;
    }

    @Override
    public boolean hasSeenSunSpiritDialogue() {
        return this.seenSunSpiritDialogue;
    }

    @Override
    public void setGoldenDartCount(int count) {
        this.goldenDartCount = count;
    }

    @Override
    public int getGoldenDartCount() {
        return this.goldenDartCount;
    }

    @Override
    public void setPoisonDartCount(int count) {
        this.poisonDartCount = count;
    }

    @Override
    public int getPoisonDartCount() {
        return this.poisonDartCount;
    }

    @Override
    public void setEnchantedDartCount(int count) {
        this.enchantedDartCount = count;
    }

    @Override
    public int getEnchantedDartCount() {
        return this.enchantedDartCount;
    }

    @Override
    public void setRemedyStartDuration(int duration) {
        this.remedyStartDuration = duration;
    }

    @Override
    public int getRemedyStartDuration() {
        return this.remedyStartDuration;
    }

    @Override
    public void setProjectileImpactedMaximum(int projectileImpactedMaximum) {
        this.impactedMaximum = projectileImpactedMaximum;
    }

    @Override
    public int getProjectileImpactedMaximum() {
        return this.impactedMaximum;
    }

    @Override
    public void setProjectileImpactedTimer(int projectileImpactedTimer) {
        this.impactedTimer = projectileImpactedTimer;
    }

    @Override
    public int getProjectileImpactedTimer() {
        return this.impactedTimer;
    }

    @Override
    public void setVampireHealing(boolean performVampireHealing) {
        this.performVampireHealing = performVampireHealing;
    }

    @Override
    public boolean performVampireHealing() {
        return this.performVampireHealing;
    }

    @Override
    @Nullable
    public void setMountedAerbunny(Aerbunny mountedAerbunny) {
        this.mountedAerbunny = mountedAerbunny;
    }

    @Override
    @Nullable
    public Aerbunny getMountedAerbunny() {
        return this.mountedAerbunny;
    }

    @Override
    @Nullable
    public void setMountedAerbunnyTag(CompoundTag mountedAerbunnyTag) {
        this.mountedAerbunnyTag = mountedAerbunnyTag;
    }

    @Override
    @Nullable
    public CompoundTag getMountedAerbunnyTag() {
        return this.mountedAerbunnyTag;
    }

    @Override
    public void setLastRiddenMoa(@Nullable UUID lastRiddenMoa) {
        this.lastRiddenMoa = lastRiddenMoa;
    }

    @Override
    @Nullable
    public UUID getLastRiddenMoa() {
        return this.lastRiddenMoa;
    }

    @Override
    public void setCloudMinions(CloudMinion cloudMinionRight, CloudMinion cloudMinionLeft) {
        this.sendCloudMinionPacket(cloudMinionRight, cloudMinionLeft);
        this.cloudMinions.add(0, cloudMinionRight);
        this.cloudMinions.add(1, cloudMinionLeft);
    }

    @Override
    public List<CloudMinion> getCloudMinions() {
        return this.cloudMinions;
    }

    @Override
    public int getWingRotationO() {
        return this.wingRotationO;
    }

    @Override
    public int getWingRotation() {
        return this.wingRotation;
    }

    @Override
    public void setAttackedWithInvisibility(boolean attacked) {
        this.attackedWithInvisibility = attacked;
    }

    @Override
    public boolean attackedWithInvisibility() {
        return this.attackedWithInvisibility;
    }

    @Override
    public void setInvisibilityEnabled(boolean enabled) {
        this.invisibilityEnabled = enabled;
    }

    @Override
    public boolean isInvisibilityEnabled() {
        return this.invisibilityEnabled;
    }

    @Override
    public void setWearingInvisibilityCloak(boolean wearing) {
        this.wearingInvisibilityCloak = wearing;
    }

    @Override
    public boolean isWearingInvisibilityCloak() {
        return this.wearingInvisibilityCloak;
    }

    @Override
    public int getFlightTimerMax() {
        return 52;
    }

    @Override
    public float getFlightModifierMax() {
        return 15.0f;
    }

    @Override
    public void setFlightTimer(int timer) {
        this.flightTimer = timer;
    }

    @Override
    public int getFlightTimer() {
        return this.flightTimer;
    }

    @Override
    public void setFlightModifier(float modifier) {
        this.flightModifier = modifier;
    }

    @Override
    public float getFlightModifier() {
        return this.flightModifier;
    }

    @Override
    public void setSavedHealth(float health) {
        this.savedHealth = health;
    }

    @Override
    public float getSavedHealth() {
        return this.savedHealth;
    }

    @Override
    public void setNeptuneSubmergeLength(double length) {
        this.neptuneSubmergeLength = length;
    }

    @Override
    public double getNeptuneSubmergeLength() {
        return this.neptuneSubmergeLength;
    }

    @Override
    public void setPhoenixSubmergeLength(double length) {
        this.phoenixSubmergeLength = length;
    }

    @Override
    public double getPhoenixSubmergeLength() {
        return this.phoenixSubmergeLength;
    }

    @Override
    public int getObsidianConversionTimerMax() {
        return 20;
    }

    @Override
    public void setObsidianConversionTime(int time) {
        this.obsidianConversionTime = time;
    }

    @Override
    public int getObsidianConversionTime() {
        return this.obsidianConversionTime;
    }

    @Override
    public void setLifeShardCount(int amount) {
        this.lifeShards = amount;
    }

    @Override
    public int getLifeShardCount() {
        return this.lifeShards;
    }

    @Override
    public int getLifeShardLimit() {
        return (Integer)AetherConfig.SERVER.maximum_life_shards.get();
    }

    @Override
    public AttributeModifier getLifeShardHealthAttributeModifier() {
        return new AttributeModifier(LIFE_SHARD_HEALTH_ID, "Life Shard health increase", (double)((float)this.getLifeShardCount() * 2.0f), AttributeModifier.Operation.ADDITION);
    }

    private void sendCloudMinionPacket(CloudMinion cloudMinionRight, CloudMinion cloudMinionLeft) {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!this.getPlayer().f_19853_.f_46443_) {
                PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new CloudMinionPacket(this.getPlayer().m_19879_(), cloudMinionRight.m_19879_(), cloudMinionLeft.m_19879_()), (ServerPlayer)serverPlayer);
            }
        }
    }

    private boolean shouldSyncBetweenClients() {
        return this.shouldSyncBetweenClients;
    }

    private void setShouldSyncBetweenClients(boolean shouldSyncBetweenClients) {
        this.shouldSyncBetweenClients = shouldSyncBetweenClients;
    }

    public BasePacket getSyncPacket(String key, INBTSynchable.Type type, Object value) {
        return new AetherPlayerSyncPacket(this.getPlayer().m_19879_(), key, type, value);
    }

    public SimpleChannel getPacketChannel() {
        return AetherPacketHandler.INSTANCE;
    }
}

