/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.api;

import com.aetherteam.aether.api.registers.AdvancementSoundOverride;
import com.aetherteam.aether.client.AetherSoundEvents;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class AetherAdvancementSoundOverrides {
    public static final ResourceKey<Registry<AdvancementSoundOverride>> ADVANCEMENT_SOUND_OVERRIDE_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("aether", "advancement_sound_override"));
    public static final DeferredRegister<AdvancementSoundOverride> ADVANCEMENT_SOUND_OVERRIDES = DeferredRegister.create(ADVANCEMENT_SOUND_OVERRIDE_REGISTRY_KEY, (String)"aether");
    public static final Supplier<IForgeRegistry<AdvancementSoundOverride>> ADVANCEMENT_SOUND_OVERRIDE_REGISTRY = ADVANCEMENT_SOUND_OVERRIDES.makeRegistry(() -> new RegistryBuilder().hasTags());
    public static final RegistryObject<AdvancementSoundOverride> GENERAL = ADVANCEMENT_SOUND_OVERRIDES.register("general", () -> new AdvancementSoundOverride(0, advancement -> AetherAdvancementSoundOverrides.checkRoot(advancement, new ResourceLocation("aether", "enter_aether")), (Supplier<SoundEvent>)AetherSoundEvents.UI_TOAST_AETHER_GENERAL));
    public static final RegistryObject<AdvancementSoundOverride> BRONZE_DUNGEON = ADVANCEMENT_SOUND_OVERRIDES.register("bronze_dungeon", () -> new AdvancementSoundOverride(10, advancement -> advancement.m_138327_().m_135815_().equals("bronze_dungeon"), (Supplier<SoundEvent>)AetherSoundEvents.UI_TOAST_AETHER_BRONZE));
    public static final RegistryObject<AdvancementSoundOverride> SILVER_DUNGEON = ADVANCEMENT_SOUND_OVERRIDES.register("silver_dungeon", () -> new AdvancementSoundOverride(10, advancement -> advancement.m_138327_().m_135815_().equals("silver_dungeon"), (Supplier<SoundEvent>)AetherSoundEvents.UI_TOAST_AETHER_SILVER));
    public static final RegistryObject<AdvancementSoundOverride> GOLD_DUNGEON = ADVANCEMENT_SOUND_OVERRIDES.register("gold_dungeon", () -> new AdvancementSoundOverride(10, advancement -> advancement.m_138327_().m_135815_().equals("gold_dungeon"), (Supplier<SoundEvent>)AetherSoundEvents.UI_TOAST_AETHER_GOLD));
    public static final RegistryObject<AdvancementSoundOverride> EMPTY = ADVANCEMENT_SOUND_OVERRIDES.register("empty", () -> new AdvancementSoundOverride(10, advancement -> advancement.m_138327_().m_135815_().equals("enter_aether"), () -> null));

    @Nullable
    public static AdvancementSoundOverride get(String id) {
        return (AdvancementSoundOverride)ADVANCEMENT_SOUND_OVERRIDE_REGISTRY.get().getValue(new ResourceLocation(id));
    }

    @Nullable
    public static SoundEvent retrieveOverride(Advancement advancement) {
        @Nullable AdvancementSoundOverride usedOverride = null;
        for (AdvancementSoundOverride override : ADVANCEMENT_SOUND_OVERRIDE_REGISTRY.get().getEntries().stream().map(Map.Entry::getValue).toList()) {
            if (!override.matches(advancement) || usedOverride != null && override.priority() <= usedOverride.priority()) continue;
            usedOverride = override;
        }
        return usedOverride == null ? null : usedOverride.sound().get();
    }

    public static boolean checkRoot(Advancement holder, ResourceLocation root) {
        for (Advancement advancement = holder; advancement != null; advancement = advancement.m_138319_()) {
            if (!advancement.m_138327_().equals((Object)root)) continue;
            return true;
        }
        return false;
    }
}

