/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncCapabilityPacket {
    private final int entityID;
    private final boolean isPlayer;
    private final CompoundTag compound;

    public ClientboundSyncCapabilityPacket(int entityID, boolean isPlayer, CompoundTag compound) {
        this.entityID = entityID;
        this.isPlayer = isPlayer;
        this.compound = compound;
    }

    public static ClientboundSyncCapabilityPacket decode(FriendlyByteBuf buffer) {
        int entityID = buffer.readInt();
        boolean isPlayer = buffer.readBoolean();
        CompoundTag compound = buffer.m_130261_();
        return new ClientboundSyncCapabilityPacket(entityID, isPlayer, compound);
    }

    public static void encode(ClientboundSyncCapabilityPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityID);
        buffer.writeBoolean(message.isPlayer);
        buffer.m_130079_(message.compound);
    }

    public static void handle(ClientboundSyncCapabilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (message.isPlayer) {
                Player player = (Player)minecraft.f_91073_.m_6815_(message.entityID);
                CapabilityUtils.getCapability(player).ifPresent(cap -> {
                    cap.setWearable(ItemStack.m_41712_((CompoundTag)message.compound));
                    cap.setContents(ItemStack.m_41712_((CompoundTag)message.compound));
                });
            } else {
                LivingEntity livingEntity = (LivingEntity)minecraft.f_91073_.m_6815_(message.entityID);
                CapabilityUtils.getEntityCapability(livingEntity).ifPresent(cap -> cap.setWearable(ItemStack.m_41712_((CompoundTag)message.compound)));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

