/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.SettingsManager;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.network.NetworkHooks;

public class TravelersBackpackContainer
implements ITravelersBackpackContainer,
MenuProvider,
Nameable {
    private final ItemStackHandler inventory = this.createHandler(Tiers.LEATHER.getStorageSlots(), true);
    private final ItemStackHandler craftingInventory = this.createHandler(9, false);
    private final ItemStackHandler toolSlots = this.createToolsHandler(Tiers.LEATHER.getToolSlots());
    private final ItemStackHandler fluidSlots = this.createTemporaryHandler();
    private final FluidTank leftTank = this.createFluidHandler(Tiers.LEATHER.getTankCapacity());
    private final FluidTank rightTank = this.createFluidHandler(Tiers.LEATHER.getTankCapacity());
    private final SlotManager slotManager = new SlotManager(this);
    private final SettingsManager settingsManager = new SettingsManager(this);
    private final Player player;
    private ItemStack stack;
    private Tiers.Tier tier;
    private boolean ability;
    private int lastTime;
    private final byte screenID;

    public TravelersBackpackContainer(ItemStack stack, Player player, byte screenID) {
        this.player = player;
        this.stack = stack;
        this.screenID = screenID;
        this.loadAllData(stack.m_41784_());
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public void loadTier(CompoundTag compound) {
        if (!compound.m_128441_("Tier")) {
            compound.m_128405_("Tier", TravelersBackpackConfig.enableTierUpgrades ? Tiers.LEATHER.getOrdinal() : Tiers.DIAMOND.getOrdinal());
        }
        if (compound.m_128425_("Tier", 8)) {
            Tiers.Tier tier = Tiers.of(compound.m_128461_("Tier"));
            compound.m_128473_("Tier");
            compound.m_128405_("Tier", tier.getOrdinal());
        }
        this.tier = Tiers.of(compound.m_128451_("Tier"));
    }

    @Override
    public ItemStackHandler getHandler() {
        return this.inventory;
    }

    @Override
    public ItemStackHandler getCraftingGridHandler() {
        return this.craftingInventory;
    }

    @Override
    public ItemStackHandler getToolSlotsHandler() {
        return this.toolSlots;
    }

    @Override
    public ItemStackHandler getFluidSlotsHandler() {
        return this.fluidSlots;
    }

    @Override
    public IItemHandlerModifiable getCombinedHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.getHandler(), this.getToolSlotsHandler(), this.getFluidSlotsHandler(), this.getCraftingGridHandler()});
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    @Override
    public void saveAllData(CompoundTag compound) {
        this.saveTanks(compound);
        this.saveItems(compound);
        this.saveTime(compound);
        this.saveAbility(compound);
        this.slotManager.saveUnsortableSlots(compound);
        this.slotManager.saveMemorySlots(compound);
        this.settingsManager.saveSettings(compound);
    }

    @Override
    public void loadAllData(CompoundTag compound) {
        this.loadTier(compound);
        this.loadTanks(compound);
        this.loadItems(compound);
        this.loadTime(compound);
        this.loadAbility(compound);
        this.slotManager.loadUnsortableSlots(compound);
        this.slotManager.loadMemorySlots(compound);
        this.settingsManager.loadSettings(compound);
    }

    @Override
    public void saveItems(CompoundTag compound) {
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128365_("ToolsInventory", (Tag)this.toolSlots.serializeNBT());
        compound.m_128365_("CraftingInventory", (Tag)this.craftingInventory.serializeNBT());
    }

    @Override
    public void loadItems(CompoundTag compound) {
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.toolSlots.deserializeNBT(compound.m_128469_("ToolsInventory"));
        this.craftingInventory.deserializeNBT(compound.m_128469_("CraftingInventory"));
    }

    @Override
    public void saveTanks(CompoundTag compound) {
        compound.m_128365_("LeftTank", (Tag)this.leftTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("RightTank", (Tag)this.rightTank.writeToNBT(new CompoundTag()));
    }

    @Override
    public void loadTanks(CompoundTag compound) {
        this.leftTank.readFromNBT(compound.m_128469_("LeftTank"));
        this.rightTank.readFromNBT(compound.m_128469_("RightTank"));
    }

    @Override
    public void saveColor(CompoundTag compound) {
    }

    @Override
    public void loadColor(CompoundTag compound) {
    }

    @Override
    public void saveSleepingBagColor(CompoundTag compound) {
    }

    @Override
    public void loadSleepingBagColor(CompoundTag compound) {
    }

    @Override
    public void saveAbility(CompoundTag compound) {
        compound.m_128379_("Ability", this.ability);
    }

    @Override
    public void loadAbility(CompoundTag compound) {
        this.ability = !compound.m_128441_("Ability") && TravelersBackpackConfig.forceAbilityEnabled || compound.m_128471_("Ability");
    }

    @Override
    public void saveTime(CompoundTag compound) {
        compound.m_128405_("LastTime", this.lastTime);
    }

    @Override
    public void loadTime(CompoundTag compound) {
        this.lastTime = compound.m_128451_("LastTime");
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), 0, this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), 2, this.player);
    }

    private void sendPackets() {
        if (this.screenID == 2) {
            if (this.slotManager.isSelectorActive((byte)1) || this.slotManager.isSelectorActive((byte)0)) {
                return;
            }
            CapabilityUtils.synchronise(this.player);
            CapabilityUtils.synchroniseToOthers(this.player);
        }
    }

    @Override
    public boolean hasColor() {
        return this.stack.m_41784_().m_128441_("Color");
    }

    @Override
    public int getColor() {
        if (this.hasColor()) {
            return this.stack.m_41784_().m_128451_("Color");
        }
        return 0;
    }

    @Override
    public boolean hasSleepingBagColor() {
        return this.stack.m_41784_().m_128441_("SleepingBagColor");
    }

    @Override
    public int getSleepingBagColor() {
        if (this.hasSleepingBagColor()) {
            return this.stack.m_41784_().m_128451_("SleepingBagColor");
        }
        return DyeColor.RED.m_41060_();
    }

    @Override
    public boolean getAbilityValue() {
        return TravelersBackpackConfig.enableBackpackAbilities ? (BackpackAbilities.ALLOWED_ABILITIES.contains(this.getItemStack().m_41720_()) ? this.ability : false) : false;
    }

    @Override
    public void setAbility(boolean value) {
        this.ability = value;
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public int getRows() {
        return (int)Math.ceil((double)this.getHandler().getSlots() / 9.0);
    }

    @Override
    public int getYOffset() {
        return 18 * Math.max(0, this.getRows() - 3);
    }

    @Override
    public boolean hasBlockEntity() {
        return false;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return false;
    }

    @Override
    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    @Override
    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @Override
    public Tiers.Tier getTier() {
        return this.tier;
    }

    @Override
    public Level getLevel() {
        return this.player.f_19853_;
    }

    @Override
    public BlockPos getPosition() {
        return this.player.m_20183_();
    }

    @Override
    public byte getScreenID() {
        return this.screenID;
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public void setUsingPlayer(@Nullable Player player) {
    }

    @Override
    public void setDataChanged(byte ... dataIds) {
        if (this.getLevel().f_46443_) {
            return;
        }
        for (byte data : dataIds) {
            switch (data) {
                case 0: {
                    this.stack.m_41784_().m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
                }
                case 1: {
                    this.stack.m_41784_().m_128365_("ToolsInventory", (Tag)this.toolSlots.serializeNBT());
                }
                case 2: {
                    this.stack.m_41784_().m_128365_("CraftingInventory", (Tag)this.craftingInventory.serializeNBT());
                }
                case 3: {
                    this.saveItems(this.stack.m_41784_());
                }
                case 4: {
                    this.saveTanks(this.stack.m_41784_());
                }
                case 5: {
                    this.saveColor(this.stack.m_41784_());
                }
                case 6: {
                    this.saveSleepingBagColor(this.stack.m_41784_());
                }
                case 7: {
                    this.saveAbility(this.stack.m_41784_());
                }
                case 8: {
                    this.saveTime(this.stack.m_41784_());
                }
                case 9: {
                    this.slotManager.saveUnsortableSlots(this.stack.m_41784_());
                    this.slotManager.saveMemorySlots(this.stack.m_41784_());
                }
                case 10: {
                    this.settingsManager.saveSettings(this.stack.m_41784_());
                }
                case 11: {
                    this.saveAllData(this.stack.m_41784_());
                }
            }
        }
        this.sendPackets();
    }

    @Override
    public void setDataChanged() {
    }

    public Component m_7755_() {
        return Component.m_237115_((String)"screen.travelersbackpack.item");
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"screen.travelersbackpack.item");
    }

    public static void abilityTick(Player player) {
        if (player.m_6084_() && CapabilityUtils.isWearingBackpack(player) && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, CapabilityUtils.getWearingBackpack(player))) {
            TravelersBackpackContainer container = CapabilityUtils.getBackpackInv(player);
            if (!player.f_19853_.f_46443_ && container.getLastTime() > 0) {
                container.setLastTime(container.getLastTime() - 1);
                container.setDataChanged(8);
            }
            if (container.getAbilityValue()) {
                BackpackAbilities.ABILITIES.abilityTick(CapabilityUtils.getWearingBackpack(player), player, null);
            }
        }
    }

    public static void openGUI(ServerPlayer serverPlayerEntity, ItemStack stack, byte screenID) {
        if (!serverPlayerEntity.f_19853_.f_46443_) {
            if (screenID == 1) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)new TravelersBackpackContainer(stack, (Player)serverPlayerEntity, screenID), packetBuffer -> packetBuffer.writeByte((int)screenID));
            }
            if (screenID == 2) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)CapabilityUtils.getBackpackInv((Player)serverPlayerEntity), packetBuffer -> packetBuffer.writeByte((int)screenID));
            }
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory inventory, Player player) {
        return new TravelersBackpackItemMenu(windowID, inventory, this);
    }

    private ItemStackHandler createHandler(int size, final boolean isInventory) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                TravelersBackpackContainer.this.setDataChanged(3);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return BackpackSlotItemHandler.isItemValid(stack);
            }

            public void deserializeNBT(CompoundTag nbt) {
                if (isInventory) {
                    this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : TravelersBackpackContainer.this.tier.getStorageSlots());
                    ListTag tagList = nbt.m_128437_("Items", 10);
                    for (int i = 0; i < tagList.size(); ++i) {
                        CompoundTag itemTags = tagList.m_128728_(i);
                        int slot = itemTags.m_128451_("Slot");
                        if (slot < 0 || slot >= this.stacks.size()) continue;
                        this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
                    }
                    this.onLoad();
                } else {
                    super.deserializeNBT(nbt);
                }
            }
        };
    }

    private ItemStackHandler createToolsHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                TravelersBackpackContainer.this.setDataChanged(1);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return ToolSlotItemHandler.isValid(stack);
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : TravelersBackpackContainer.this.tier.getToolSlots());
                ListTag tagList = nbt.m_128437_("Items", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundTag itemTags = tagList.m_128728_(i);
                    int slot = itemTags.m_128451_("Slot");
                    if (slot < 0 || slot >= this.stacks.size()) continue;
                    this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
                }
                this.onLoad();
            }
        };
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                TravelersBackpackContainer.this.setDataChanged(4);
            }

            public FluidTank readFromNBT(CompoundTag nbt) {
                this.setCapacity(nbt.m_128425_("Capacity", 3) ? nbt.m_128451_("Capacity") : TravelersBackpackContainer.this.tier.getTankCapacity());
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
                this.setFluid(fluid);
                return this;
            }

            public CompoundTag writeToNBT(CompoundTag nbt) {
                if (!nbt.m_128425_("Capacity", 3)) {
                    nbt.m_128405_("Capacity", TravelersBackpackContainer.this.tier.getTankCapacity());
                }
                this.fluid.writeToNBT(nbt);
                return nbt;
            }
        };
    }
}

