/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.tiviacz.travelersbackpack.inventory.Tiers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class RenderData {
    private final ItemStack stack;
    private final FluidTank leftTank = this.createFluidHandler();
    private final FluidTank rightTank = this.createFluidHandler();

    public RenderData(ItemStack stack, boolean loadData) {
        this.stack = stack;
        if (loadData) {
            this.loadDataFromStack(stack);
        }
    }

    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getSleepingBagColor() {
        if (this.stack.m_41784_().m_128441_("SleepingBagColor")) {
            return this.stack.m_41784_().m_128451_("SleepingBagColor");
        }
        return DyeColor.RED.m_41060_();
    }

    public void loadDataFromStack(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41782_()) {
            this.loadTanks(stack.m_41784_());
        }
    }

    public void loadTanks(CompoundTag compound) {
        this.leftTank.readFromNBT(compound.m_128469_("LeftTank"));
        this.rightTank.readFromNBT(compound.m_128469_("RightTank"));
    }

    private FluidTank createFluidHandler() {
        return new FluidTank(Tiers.LEATHER.getTankCapacity()){

            public FluidTank readFromNBT(CompoundTag nbt) {
                this.setCapacity(nbt.m_128425_("Capacity", 3) ? nbt.m_128451_("Capacity") : Tiers.of(RenderData.this.stack.m_41784_().m_128451_("Tier")).getTankCapacity());
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
                this.setFluid(fluid);
                return this;
            }

            public CompoundTag writeToNBT(CompoundTag nbt) {
                if (!nbt.m_128425_("Capacity", 3)) {
                    nbt.m_128405_("Capacity", Tiers.of(RenderData.this.stack.m_41784_().m_128451_("Tier")).getTankCapacity());
                }
                this.fluid.writeToNBT(nbt);
                return nbt;
            }
        };
    }
}

