/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.blockentities.InventoryManagerEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.InventoryUtil;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;
import org.jetbrains.annotations.NotNull;

public class InventoryManagerPeripheral
extends BasePeripheral<BlockEntityPeripheralOwner<InventoryManagerEntity>> {
    public static final String PERIPHERAL_TYPE = "inventoryManager";

    public InventoryManagerPeripheral(InventoryManagerEntity tileEntity) {
        super(PERIPHERAL_TYPE, new BlockEntityPeripheralOwner<InventoryManagerEntity>(tileEntity));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableInventoryManager.get();
    }

    @LuaFunction
    public final String getOwner() throws LuaException {
        if (((BlockEntityPeripheralOwner)this.owner).getOwner() == null) {
            return null;
        }
        return this.getOwnerPlayer().m_7755_().getString();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult addItemToPlayer(String invDirection, Map<?, ?> item) throws LuaException {
        Pair<ItemFilter, String> filter = ItemFilter.parse(item);
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return MethodResult.of((Object[])new Object[]{this.addItemCommon(invDirection, filter.getLeft()), null});
    }

    private int addItemCommon(String invDirection, ItemFilter filter) throws LuaException {
        Direction direction = this.validateSide(invDirection);
        BlockEntity targetEntity = ((BlockEntityPeripheralOwner)this.owner).getLevel().m_7702_(((BlockEntityPeripheralOwner)this.owner).getPos().m_121945_(direction));
        IItemHandler inventoryFrom = targetEntity != null ? (IItemHandler)targetEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction).resolve().orElse(null) : null;
        Pair<IItemHandler, Integer> inventoryTo = this.getHandlerFromSlot(filter.getToSlot());
        inventoryTo.ifRightPresent(slot -> {
            filter.toSlot = slot;
        });
        return InventoryUtil.moveItem(inventoryFrom, inventoryTo.getLeft(), filter);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult removeItemFromPlayer(String invDirection, Map<?, ?> item) throws LuaException {
        Pair<ItemFilter, String> filter = ItemFilter.parse(item);
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return this.removeItemCommon(invDirection, filter.getLeft());
    }

    private MethodResult removeItemCommon(String invDirection, ItemFilter filter) throws LuaException {
        IItemHandler inventoryTo;
        Direction direction = this.validateSide(invDirection);
        BlockEntity targetEntity = ((BlockEntityPeripheralOwner)this.owner).getLevel().m_7702_(((BlockEntityPeripheralOwner)this.owner).getPos().m_121945_(direction));
        Pair<IItemHandler, Integer> inventoryFrom = this.getHandlerFromSlot(filter.getFromSlot());
        IItemHandler iItemHandler = inventoryTo = targetEntity != null ? (IItemHandler)targetEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction).resolve().orElse(null) : null;
        if (inventoryTo == null) {
            return MethodResult.of((Object[])new Object[]{0, "INVENTORY_TO_INVALID"});
        }
        inventoryFrom.ifRightPresent(slot -> {
            filter.fromSlot = slot;
        });
        return MethodResult.of((Object)InventoryUtil.moveItem(inventoryFrom.getLeft(), inventoryTo, filter));
    }

    @LuaFunction(value={"list", "getItems"}, mainThread=true)
    public final List<Object> getItems() throws LuaException {
        ArrayList<Object> items = new ArrayList<Object>();
        int i = 0;
        for (ItemStack stack : this.getOwnerPlayer().m_150109_().f_35974_) {
            ItemStack copiedStack = stack.m_41777_();
            if (!copiedStack.m_41619_()) {
                items.add(LuaConverter.stackToObjectWithSlot(copiedStack, i));
            }
            ++i;
        }
        return items;
    }

    @LuaFunction(value={"listChest", "getItemsChest"}, mainThread=true)
    public final MethodResult getItemsChest(String target) throws LuaException {
        IItemHandler inventoryTo;
        Direction direction = this.validateSide(target);
        BlockEntity targetEntity = ((BlockEntityPeripheralOwner)this.owner).getLevel().m_7702_(((BlockEntityPeripheralOwner)this.owner).getPos().m_121945_(direction));
        IItemHandler iItemHandler = inventoryTo = targetEntity != null ? (IItemHandler)targetEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction).resolve().orElse(null) : null;
        if (inventoryTo == null) {
            return MethodResult.of((Object[])new Object[]{null, "INVENTORY_TO_INVALID"});
        }
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        for (int slot = 0; slot < inventoryTo.getSlots(); ++slot) {
            if (inventoryTo.getStackInSlot(slot).m_41619_()) continue;
            items.add(LuaConverter.stackToObjectWithSlot(inventoryTo.getStackInSlot(slot).m_41777_(), slot));
        }
        return MethodResult.of(items);
    }

    @LuaFunction(mainThread=true)
    public final List<Object> getArmor() throws LuaException {
        ArrayList<Object> items = new ArrayList<Object>();
        for (ItemStack stack : this.getOwnerPlayer().m_150109_().f_35975_) {
            ItemStack copiedStack = stack.m_41777_();
            if (copiedStack.m_41619_()) continue;
            items.add(LuaConverter.stackToObjectWithSlot(copiedStack, ArmorSlot.getSlotForItem(copiedStack)));
        }
        return items;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayerEquipped() throws LuaException {
        for (ItemStack stack : this.getOwnerPlayer().m_150109_().f_35975_) {
            if (stack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isWearing(int index) throws LuaException {
        int i = 0;
        for (ItemStack stack : this.getOwnerPlayer().m_150109_().f_35975_) {
            if (stack.m_41619_()) continue;
            if (index == i - 100) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final int getEmptySpace() throws LuaException {
        int i = 0;
        for (ItemStack stack : this.getOwnerPlayer().m_150109_().f_35974_) {
            if (!stack.m_41619_()) continue;
            ++i;
        }
        return i;
    }

    @LuaFunction(mainThread=true)
    public final boolean isSpaceAvailable() throws LuaException {
        return this.getEmptySpace() > 0;
    }

    @LuaFunction(mainThread=true)
    public final int getFreeSlot() throws LuaException {
        return this.getOwnerPlayer().m_150109_().m_36062_();
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getItemInHand() throws LuaException {
        return LuaConverter.stackToObject(this.getOwnerPlayer().m_21205_().m_41777_());
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getItemInOffHand() throws LuaException {
        return LuaConverter.stackToObject(this.getOwnerPlayer().m_21206_().m_41777_());
    }

    private Player getOwnerPlayer() throws LuaException {
        if (((BlockEntityPeripheralOwner)this.owner).getOwner() == null) {
            throw new LuaException("The Inventory Manager doesn't have a memory card or it isn't bound to a player.");
        }
        return ((BlockEntityPeripheralOwner)this.owner).getOwner();
    }

    @NotNull
    private Pair<IItemHandler, Integer> getHandlerFromSlot(int slot) throws LuaException {
        PlayerArmorInvWrapper handler;
        if (slot >= 100 && slot <= 103) {
            handler = new PlayerArmorInvWrapper(this.getOwnerPlayer().m_150109_());
            slot -= 100;
        } else if (slot == 36) {
            handler = new PlayerOffhandInvWrapper(this.getOwnerPlayer().m_150109_());
            slot = 0;
        } else {
            handler = new PlayerInvWrapper(this.getOwnerPlayer().m_150109_());
        }
        return Pair.of(handler, slot);
    }

    private static enum ArmorSlot {
        HELMET_SLOT(103, EquipmentSlot.HEAD),
        CHEST_SLOT(102, EquipmentSlot.CHEST),
        LEGGINGS_SLOT(101, EquipmentSlot.LEGS),
        BOOTS_SLOT(100, EquipmentSlot.FEET);

        private final int slot;
        private final EquipmentSlot slotType;

        private ArmorSlot(int slot, EquipmentSlot slotType) {
            this.slot = slot;
            this.slotType = slotType;
        }

        public static int getSlotForItem(ItemStack stack) {
            ArmorSlot[] armorSlotArray = stack.m_41720_();
            if (armorSlotArray instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)armorSlotArray;
                for (ArmorSlot slot : ArmorSlot.values()) {
                    if (armorItem.m_40402_() != slot.slotType) continue;
                    return slot.slot;
                }
            }
            AdvancedPeripherals.LOGGER.warn("Tried to get armor item slot for non armor item " + stack + ". Returning 0");
            return 0;
        }

        public int getSlot() {
            return this.slot;
        }
    }
}

