/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.util.controller;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntSupplier;
import me.drex.antixray.AntiXray;
import me.drex.antixray.interfaces.IChunkPacket;
import me.drex.antixray.util.BitStorageReader;
import me.drex.antixray.util.BitStorageWriter;
import me.drex.antixray.util.ChunkPacketInfo;
import me.drex.antixray.util.ChunkPacketInfoAntiXray;
import me.drex.antixray.util.controller.ChunkPacketBlockController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.GlobalPalette;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import net.minecraft.world.level.chunk.Palette;

public abstract class ChunkPacketBlockControllerAntiXray
implements ChunkPacketBlockController {
    protected static final Palette<BlockState> GLOBAL_BLOCKSTATE_PALETTE = new GlobalPalette((IdMap)Block.f_49791_);
    private static final LevelChunkSection EMPTY_SECTION = null;
    protected final int maxBlockHeight;
    private final int maxBlockHeightUpdatePosition;
    private final int updateRadius;
    private final Object2BooleanOpenHashMap<BlockState> solidGlobal = new Object2BooleanOpenHashMap(Block.f_49791_.m_13562_());
    private final Object2BooleanOpenHashMap<BlockState> obfuscateGlobal = new Object2BooleanOpenHashMap(Block.f_49791_.m_13562_());
    private final Executor executor;
    private final LevelChunkSection[] emptyNearbyChunkSections = new LevelChunkSection[]{EMPTY_SECTION, EMPTY_SECTION, EMPTY_SECTION, EMPTY_SECTION};
    private final ThreadLocal<int[]> presetBlockStateBits = ThreadLocal.withInitial(() -> new int[this.getPresetBlockStatesLength()]);
    private static final ThreadLocal<boolean[]> SOLID = ThreadLocal.withInitial(() -> new boolean[Block.f_49791_.m_13562_()]);
    private static final ThreadLocal<boolean[]> OBFUSCATE = ThreadLocal.withInitial(() -> new boolean[Block.f_49791_.m_13562_()]);
    private static final ThreadLocal<boolean[][]> CURRENT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    private static final ThreadLocal<boolean[][]> NEXT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    private static final ThreadLocal<boolean[][]> NEXT_NEXT = ThreadLocal.withInitial(() -> new boolean[16][16]);

    protected ChunkPacketBlockControllerAntiXray(Level level, Executor executor, Set<Block> toObfuscate, int maxBlockHeight, int updateRadius, boolean lavaObscures) {
        this.executor = executor;
        this.maxBlockHeight = maxBlockHeight;
        this.updateRadius = updateRadius;
        for (Block block : toObfuscate) {
            if (block.m_49966_().m_60795_()) continue;
            for (BlockState blockState2 : block.m_49965_().m_61056_()) {
                this.obfuscateGlobal.put((Object)blockState2, true);
            }
        }
        EmptyLevelChunk emptyChunk = new EmptyLevelChunk(level, new ChunkPos(0, 0), level.m_5962_().m_175515_(Registry.f_122885_).m_206081_(Biomes.f_48202_));
        Block.f_49791_.iterator().forEachRemaining(blockState -> this.solidGlobal.put(blockState, blockState.m_60796_((BlockGetter)emptyChunk, BlockPos.f_121853_) && blockState.m_60734_() != Blocks.f_50085_ && blockState.m_60734_() != Blocks.f_50375_ && blockState.m_60734_() != Blocks.f_50456_ && blockState.m_60734_() != Blocks.f_50374_ && blockState.m_60734_() != Blocks.f_220833_ || lavaObscures && blockState == Blocks.f_49991_.m_49966_()));
        this.maxBlockHeightUpdatePosition = maxBlockHeight + updateRadius - 1;
    }

    public ChunkPacketInfoAntiXray getChunkPacketInfo(ClientboundLevelChunkWithLightPacket chunkPacket, LevelChunk chunk) {
        return new ChunkPacketInfoAntiXray(chunkPacket, chunk, this);
    }

    @Override
    public void onBlockChange(Level level, BlockPos blockPos, BlockState newBlockState, BlockState oldBlockState, int flags, int maxUpdateDepth) {
        if (oldBlockState != null && this.solidGlobal.getOrDefault((Object)oldBlockState, false) && !this.solidGlobal.getOrDefault((Object)newBlockState, false) && blockPos.m_123342_() <= this.maxBlockHeightUpdatePosition) {
            this.updateNearbyBlocks(level, blockPos);
        }
    }

    @Override
    public void modifyBlocks(ClientboundLevelChunkWithLightPacket chunkPacket, ChunkPacketInfo<BlockState> chunkPacketInfo) {
        ServerLevel serverLevel;
        if (!(chunkPacketInfo instanceof ChunkPacketInfoAntiXray)) {
            ((IChunkPacket)chunkPacket).setReady(true);
            return;
        }
        ChunkPacketInfoAntiXray antiXrayInfo = (ChunkPacketInfoAntiXray)chunkPacketInfo;
        Level level = chunkPacketInfo.getChunk().m_62953_();
        if (level instanceof ServerLevel && !(serverLevel = (ServerLevel)level).m_7654_().m_18695_()) {
            serverLevel.m_7654_().execute(() -> this.modifyBlocks(chunkPacket, chunkPacketInfo));
            return;
        }
        LevelChunk chunk = chunkPacketInfo.getChunk();
        int x = chunk.m_7697_().f_45578_;
        int z = chunk.m_7697_().f_45579_;
        ServerChunkCache chunkCache = ((ServerLevel)chunk.m_62953_()).m_7726_();
        antiXrayInfo.setNearbyChunks(this.getChunkAccess(chunkCache, x - 1, z), this.getChunkAccess(chunkCache, x + 1, z), this.getChunkAccess(chunkCache, x, z - 1), this.getChunkAccess(chunkCache, x, z + 1));
        this.executor.execute((Runnable)((Object)chunkPacketInfo));
    }

    private ChunkAccess getChunkAccess(ServerChunkCache chunkCache, int chunkX, int chunkZ) {
        ChunkHolder chunkHolder = chunkCache.m_8364_(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
        if (chunkHolder != null) {
            ChunkAccess chunkAccess = chunkHolder.m_140089_();
            if (chunkAccess != null) {
                return chunkAccess;
            }
            AntiXray.LOGGER.warn("Chunk at [{}, {}] not available, falling back to getChunk", (Object)chunkX, (Object)chunkZ);
        } else {
            AntiXray.LOGGER.warn("Chunk at [{}, {}] not visible, falling back to getChunk", (Object)chunkX, (Object)chunkZ);
        }
        return chunkCache.m_7587_(chunkX, chunkZ, ChunkStatus.f_62323_, true);
    }

    @Override
    public void onPlayerLeftClickBlock(ServerPlayerGameMode serverPlayerGameMode, BlockPos blockPos, ServerboundPlayerActionPacket.Action action, Direction direction, int worldHeight) {
        if (blockPos.m_123342_() <= this.maxBlockHeightUpdatePosition) {
            this.updateNearbyBlocks((Level)serverPlayerGameMode.f_9244_, blockPos);
        }
    }

    private void updateNearbyBlocks(Level level, BlockPos blockPos) {
        if (this.updateRadius >= 2) {
            BlockPos temp = blockPos.m_122024_();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.m_122024_());
            this.updateBlock(level, temp.m_7495_());
            this.updateBlock(level, temp.m_7494_());
            this.updateBlock(level, temp.m_122012_());
            this.updateBlock(level, temp.m_122019_());
            temp = blockPos.m_122029_();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.m_122029_());
            this.updateBlock(level, temp.m_7495_());
            this.updateBlock(level, temp.m_7494_());
            this.updateBlock(level, temp.m_122012_());
            this.updateBlock(level, temp.m_122019_());
            temp = blockPos.m_7495_();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.m_7495_());
            this.updateBlock(level, temp.m_122012_());
            this.updateBlock(level, temp.m_122019_());
            temp = blockPos.m_7494_();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.m_7494_());
            this.updateBlock(level, temp.m_122012_());
            this.updateBlock(level, temp.m_122019_());
            temp = blockPos.m_122012_();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.m_122012_());
            temp = blockPos.m_122019_();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.m_122019_());
        } else if (this.updateRadius == 1) {
            this.updateBlock(level, blockPos.m_122024_());
            this.updateBlock(level, blockPos.m_122029_());
            this.updateBlock(level, blockPos.m_7495_());
            this.updateBlock(level, blockPos.m_7494_());
            this.updateBlock(level, blockPos.m_122012_());
            this.updateBlock(level, blockPos.m_122019_());
        }
    }

    protected abstract int getPresetBlockStatesLength();

    protected abstract int[] getPresetBlockStateBits(Level var1, int var2);

    private void updateBlock(Level level, BlockPos pos) {
        LevelChunk chunk = level.m_7726_().m_62227_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, false);
        if (chunk != null && this.obfuscateGlobal.getOrDefault((Object)chunk.m_8055_(pos), false)) {
            ((ServerLevel)level).m_7726_().m_8450_(pos);
        }
    }

    public void obfuscate(ChunkPacketInfoAntiXray chunkPacketInfoAntiXray) {
        int[] presetBlockStateBits = this.presetBlockStateBits.get();
        boolean[] solid = SOLID.get();
        boolean[] obfuscate = OBFUSCATE.get();
        boolean[][] current = CURRENT.get();
        boolean[][] next = NEXT.get();
        boolean[][] nextNext = NEXT_NEXT.get();
        BitStorageReader bitStorageReader = new BitStorageReader();
        BitStorageWriter bitStorageWriter = new BitStorageWriter();
        LevelChunkSection[] nearbyChunkSections = new LevelChunkSection[4];
        LevelChunk chunk = chunkPacketInfoAntiXray.getChunk();
        Level level = chunk.m_62953_();
        int maxChunkSectionIndex = Math.min((this.maxBlockHeight >> 4) - chunk.m_151560_(), chunk.m_151559_() - 1);
        bitStorageReader.setBuffer(chunkPacketInfoAntiXray.getBuffer());
        bitStorageWriter.setBuffer(chunkPacketInfoAntiXray.getBuffer());
        int numberOfBlocks = presetBlockStateBits.length;
        for (int chunkSectionIndex = 0; chunkSectionIndex <= maxChunkSectionIndex; ++chunkSectionIndex) {
            int x;
            int z;
            if (!chunkPacketInfoAntiXray.isWritten(chunkSectionIndex) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex) == null) continue;
            if (chunkPacketInfoAntiXray.getPalette(chunkSectionIndex) instanceof GlobalPalette) {
                presetBlockStateBits = this.getPresetBlockStateBits(level, chunkSectionIndex + chunk.m_151560_());
            } else {
                BlockState[] presetBlockStates = (BlockState[])chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex);
                for (int i = 0; i < presetBlockStateBits.length; ++i) {
                    presetBlockStateBits[i] = chunkPacketInfoAntiXray.getPalette(chunkSectionIndex).m_6796_((Object)presetBlockStates[i]);
                }
            }
            bitStorageWriter.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex));
            if (chunkSectionIndex == 0 || !chunkPacketInfoAntiXray.isWritten(chunkSectionIndex - 1) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex - 1) == null) {
                bitStorageReader.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex));
                bitStorageReader.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex));
                this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex), solid, this.solidGlobal);
                this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex), obfuscate, this.obfuscateGlobal);
                LevelChunkSection belowChunkSection = null;
                boolean skipFirstLayer = chunkSectionIndex == 0 || (belowChunkSection = chunk.m_7103_()[chunkSectionIndex - 1]) == EMPTY_SECTION;
                for (z = 0; z < 16; ++z) {
                    for (x = 0; x < 16; ++x) {
                        current[z][x] = true;
                        next[z][x] = skipFirstLayer || this.isTransparent(belowChunkSection, x, 15, z);
                    }
                }
                bitStorageWriter.setBits(0);
                this.obfuscateLayer(-1, bitStorageReader, bitStorageWriter, solid, obfuscate, presetBlockStateBits, current, next, nextNext, this.emptyNearbyChunkSections, this.layerIntSupplier(numberOfBlocks));
            }
            bitStorageWriter.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex));
            nearbyChunkSections[0] = chunkPacketInfoAntiXray.getNearbyChunks()[0] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[0].m_7103_()[chunkSectionIndex];
            nearbyChunkSections[1] = chunkPacketInfoAntiXray.getNearbyChunks()[1] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[1].m_7103_()[chunkSectionIndex];
            nearbyChunkSections[2] = chunkPacketInfoAntiXray.getNearbyChunks()[2] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[2].m_7103_()[chunkSectionIndex];
            nearbyChunkSections[3] = chunkPacketInfoAntiXray.getNearbyChunks()[3] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[3].m_7103_()[chunkSectionIndex];
            for (int y = 0; y < 15; ++y) {
                boolean[][] temp = current;
                current = next;
                next = nextNext;
                nextNext = temp;
                this.obfuscateLayer(y, bitStorageReader, bitStorageWriter, solid, obfuscate, presetBlockStateBits, current, next, nextNext, nearbyChunkSections, this.layerIntSupplier(numberOfBlocks));
            }
            if (chunkSectionIndex == maxChunkSectionIndex || !chunkPacketInfoAntiXray.isWritten(chunkSectionIndex + 1) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex + 1) == null) {
                LevelChunkSection aboveChunkSection;
                if (chunkSectionIndex != chunk.m_151559_() - 1 && (aboveChunkSection = chunk.m_7103_()[chunkSectionIndex + 1]) != EMPTY_SECTION) {
                    boolean[][] temp = current;
                    current = next;
                    next = nextNext;
                    nextNext = temp;
                    for (z = 0; z < 16; ++z) {
                        for (x = 0; x < 16; ++x) {
                            if (!this.isTransparent(aboveChunkSection, x, 0, z)) continue;
                            current[z][x] = true;
                        }
                    }
                    bitStorageReader.setBits(0);
                    solid[0] = true;
                    this.obfuscateLayer(15, bitStorageReader, bitStorageWriter, solid, obfuscate, presetBlockStateBits, current, next, nextNext, nearbyChunkSections, this.layerIntSupplier(numberOfBlocks));
                }
            } else {
                bitStorageReader.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex + 1));
                bitStorageReader.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex + 1));
                this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex + 1), solid, this.solidGlobal);
                this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex + 1), obfuscate, this.obfuscateGlobal);
                boolean[][] temp = current;
                current = next;
                next = nextNext;
                nextNext = temp;
                this.obfuscateLayer(15, bitStorageReader, bitStorageWriter, solid, obfuscate, presetBlockStateBits, current, next, nextNext, nearbyChunkSections, this.layerIntSupplier(numberOfBlocks));
            }
            bitStorageWriter.flush();
        }
        ((IChunkPacket)chunkPacketInfoAntiXray.getChunkPacket()).setReady(true);
    }

    private void obfuscateLayer(int y, BitStorageReader bitStorageReader, BitStorageWriter bitStorageWriter, boolean[] solid, boolean[] obfuscate, int[] presetBlockStateBits, boolean[][] current, boolean[][] next, boolean[][] nextNext, LevelChunkSection[] nearbyChunkSections, IntSupplier random) {
        for (int z = 0; z <= 15; ++z) {
            for (int x = 0; x <= 15; ++x) {
                int bits = bitStorageReader.read();
                nextNext[z][x] = !solid[bits];
                if (nextNext[z][x]) {
                    bitStorageWriter.skip();
                    if (x > 0) {
                        next[z][x - 1] = true;
                    }
                    if (x < 15) {
                        next[z][x + 1] = true;
                    }
                    if (z > 0) {
                        next[z - 1][x] = true;
                    }
                    if (z < 15) {
                        next[z + 1][x] = true;
                    }
                } else {
                    boolean posZ;
                    boolean negX = x == 0 && this.isTransparent(nearbyChunkSections[0], 15, y, z);
                    boolean posX = x == 15 && this.isTransparent(nearbyChunkSections[1], 0, y, z);
                    boolean negZ = z == 0 && this.isTransparent(nearbyChunkSections[2], x, y, 15);
                    boolean bl = posZ = z == 15 && this.isTransparent(nearbyChunkSections[3], x, y, 0);
                    if (current[z][x] || negX || posX || negZ || posZ) {
                        bitStorageWriter.skip();
                    } else {
                        bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                    }
                }
                if (obfuscate[bits]) continue;
                next[z][x] = true;
            }
        }
    }

    private boolean isTransparent(LevelChunkSection chunkSection, int x, int y, int z) {
        if (chunkSection == EMPTY_SECTION) {
            return true;
        }
        try {
            return !this.solidGlobal.getOrDefault((Object)chunkSection.m_62982_(x, y, z), false);
        }
        catch (MissingPaletteEntryException e) {
            return true;
        }
    }

    private void readPalette(Palette<BlockState> palette, boolean[] temp, Object2BooleanOpenHashMap<BlockState> global) {
        try {
            for (int i = 0; i < palette.m_62680_(); ++i) {
                temp[i] = global.getOrDefault(palette.m_5795_(i), false);
            }
        }
        catch (MissingPaletteEntryException missingPaletteEntryException) {
            // empty catch block
        }
    }

    public IntSupplier layerIntSupplier(final int numberOfBlocks) {
        return numberOfBlocks == 1 ? () -> 0 : new IntSupplier(){
            private int state;
            {
                while ((this.state = ThreadLocalRandom.current().nextInt()) == 0) {
                }
            }

            @Override
            public int getAsInt() {
                this.state ^= this.state << 13;
                this.state ^= this.state >>> 17;
                this.state ^= this.state << 5;
                return (int)(Integer.toUnsignedLong(this.state) * (long)numberOfBlocks >>> 32);
            }
        };
    }
}

