/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.util;

public final class BitStorageWriter {
    private byte[] buffer;
    private int bits;
    private long mask;
    private int longInBufferIndex;
    private int bitInLongIndex;
    private long current;
    private boolean dirty;

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public void setBits(int bits) {
        this.bits = bits;
        this.mask = (1L << bits) - 1L;
    }

    public void setIndex(int index) {
        this.longInBufferIndex = index;
        this.bitInLongIndex = 0;
        this.init();
    }

    private void init() {
        if (this.buffer.length > this.longInBufferIndex + 7) {
            this.current = (long)this.buffer[this.longInBufferIndex] << 56 | ((long)this.buffer[this.longInBufferIndex + 1] & 0xFFL) << 48 | ((long)this.buffer[this.longInBufferIndex + 2] & 0xFFL) << 40 | ((long)this.buffer[this.longInBufferIndex + 3] & 0xFFL) << 32 | ((long)this.buffer[this.longInBufferIndex + 4] & 0xFFL) << 24 | ((long)this.buffer[this.longInBufferIndex + 5] & 0xFFL) << 16 | ((long)this.buffer[this.longInBufferIndex + 6] & 0xFFL) << 8 | (long)this.buffer[this.longInBufferIndex + 7] & 0xFFL;
        }
        this.dirty = false;
    }

    public void flush() {
        if (this.dirty && this.buffer.length > this.longInBufferIndex + 7) {
            this.buffer[this.longInBufferIndex] = (byte)(this.current >> 56 & 0xFFL);
            this.buffer[this.longInBufferIndex + 1] = (byte)(this.current >> 48 & 0xFFL);
            this.buffer[this.longInBufferIndex + 2] = (byte)(this.current >> 40 & 0xFFL);
            this.buffer[this.longInBufferIndex + 3] = (byte)(this.current >> 32 & 0xFFL);
            this.buffer[this.longInBufferIndex + 4] = (byte)(this.current >> 24 & 0xFFL);
            this.buffer[this.longInBufferIndex + 5] = (byte)(this.current >> 16 & 0xFFL);
            this.buffer[this.longInBufferIndex + 6] = (byte)(this.current >> 8 & 0xFFL);
            this.buffer[this.longInBufferIndex + 7] = (byte)(this.current & 0xFFL);
        }
    }

    public void write(int value) {
        if (this.bitInLongIndex + this.bits > 64) {
            this.flush();
            this.bitInLongIndex = 0;
            this.longInBufferIndex += 8;
            this.init();
        }
        this.current = this.current & (this.mask << this.bitInLongIndex ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.mask) << this.bitInLongIndex;
        this.dirty = true;
        this.bitInLongIndex += this.bits;
    }

    public void skip() {
        this.bitInLongIndex += this.bits;
        if (this.bitInLongIndex > 64) {
            this.flush();
            this.bitInLongIndex = this.bits;
            this.longInBufferIndex += 8;
            this.init();
        }
    }
}

