/*
 * Decompiled with CFR 0.152.
 */
package shaded.de.jangassen.jfa;

import com.sun.jna.Pointer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import shaded.de.jangassen.jfa.FoundationMethod;
import shaded.de.jangassen.jfa.Selector;
import shaded.de.jangassen.jfa.appkit.NSInvocation;
import shaded.de.jangassen.jfa.foundation.ID;

public class FoundationProxyHandler {
    private final Map<Pointer, Function<NSInvocation, Boolean>> beforeMethodHooks = new HashMap<Pointer, Function<NSInvocation, Boolean>>();
    private final Map<Pointer, Consumer<NSInvocation>> afterMethodHooks = new HashMap<Pointer, Consumer<NSInvocation>>();
    private final Map<Pointer, FoundationMethod> additionalMethods = new HashMap<Pointer, FoundationMethod>();

    public void addMethod(FoundationMethod handler) {
        this.additionalMethods.put(handler.getSelector(), handler);
    }

    FoundationMethod getAdditionalMethod(Pointer selector) {
        return this.additionalMethods.get(selector);
    }

    boolean hasAdditionalMethods() {
        return !this.additionalMethods.isEmpty();
    }

    boolean hasAdditionalMethod(Pointer selector) {
        return this.additionalMethods.containsKey(selector);
    }

    public void addBeforeMethodHook(Method method, Function<NSInvocation, Boolean> handler) {
        this.addBeforeMethodHook(handler, Selector.forMethod(method));
    }

    public void addBeforeMethodHook(String selector, Function<NSInvocation, Boolean> handler) {
        this.addBeforeMethodHook(handler, Selector.forString(selector));
    }

    private void addBeforeMethodHook(Function<NSInvocation, Boolean> handler, Pointer key) {
        this.beforeMethodHooks.put(key, handler);
    }

    public void addAfterMethodHook(Method method, Consumer<NSInvocation> handler) {
        this.addAfterMethodHook(handler, Selector.forMethod(method));
    }

    public void addAfterMethodHook(String selector, Consumer<NSInvocation> handler) {
        this.addAfterMethodHook(handler, Selector.forString(selector));
    }

    private void addAfterMethodHook(Consumer<NSInvocation> handler, Pointer key) {
        this.afterMethodHooks.put(key, handler);
    }

    public boolean beforeTarget(NSInvocation invocation) {
        Function<NSInvocation, Boolean> nsInvocationBooleanFunction = this.beforeMethodHooks.get(this.getPointer(invocation));
        if (nsInvocationBooleanFunction != null) {
            return nsInvocationBooleanFunction.apply(invocation);
        }
        return true;
    }

    public void afterTarget(NSInvocation invocation) {
        Consumer<NSInvocation> nsInvocationBooleanFunction = this.afterMethodHooks.get(this.getPointer(invocation));
        if (nsInvocationBooleanFunction != null) {
            nsInvocationBooleanFunction.accept(invocation);
        }
    }

    private Pointer getPointer(NSInvocation invocation) {
        ID selector = invocation.selector();
        return new Pointer(selector.longValue());
    }
}

