/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.jthemedetecor;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.jthemedetecor.OsThemeDetector;
import shaded.org.jetbrains.annotations.NotNull;
import shaded.org.jetbrains.annotations.Nullable;

class WindowsThemeDetector
extends OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(WindowsThemeDetector.class);
    private static final String REGISTRY_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize";
    private static final String REGISTRY_VALUE = "AppsUseLightTheme";
    private final Set<Consumer<Boolean>> listeners = Collections.synchronizedSet(new HashSet());
    private DetectorThread detectorThread;

    WindowsThemeDetector() {
    }

    @Override
    public boolean isDark() {
        return Advapi32Util.registryValueExists(WinReg.HKEY_CURRENT_USER, REGISTRY_PATH, REGISTRY_VALUE) && Advapi32Util.registryGetIntValue(WinReg.HKEY_CURRENT_USER, REGISTRY_PATH, REGISTRY_VALUE) == 0;
    }

    @Override
    public synchronized void registerListener(@NotNull Consumer<Boolean> darkThemeListener) {
        boolean threadInterrupted;
        Objects.requireNonNull(darkThemeListener);
        boolean listenerAdded = this.listeners.add(darkThemeListener);
        boolean singleListener = listenerAdded && this.listeners.size() == 1;
        boolean bl = threadInterrupted = this.detectorThread != null && this.detectorThread.isInterrupted();
        if (singleListener || threadInterrupted) {
            this.detectorThread = new DetectorThread(this);
            this.detectorThread.start();
        }
    }

    @Override
    public synchronized void removeListener(@Nullable Consumer<Boolean> darkThemeListener) {
        this.listeners.remove(darkThemeListener);
        if (this.listeners.isEmpty()) {
            this.detectorThread.interrupt();
            this.detectorThread = null;
        }
    }

    private static final class DetectorThread
    extends Thread {
        private final Object lock = new Object();
        private final WindowsThemeDetector themeDetector;
        private boolean lastValue;

        DetectorThread(WindowsThemeDetector themeDetector) {
            this.themeDetector = themeDetector;
            this.lastValue = themeDetector.isDark();
            this.setName("Windows 10 Theme Detector Thread");
            this.setDaemon(true);
            this.setPriority(4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                boolean currentDetection = this.themeDetector.isDark();
                if (currentDetection != this.lastValue) {
                    this.lastValue = currentDetection;
                    logger.debug("Theme change detected: dark: {}", (Object)currentDetection);
                    for (Consumer<Boolean> listener : this.themeDetector.listeners) {
                        try {
                            listener.accept(currentDetection);
                        }
                        catch (RuntimeException e) {
                            logger.error("Caught exception during listener notifying ", e);
                        }
                    }
                }
                Iterator<Consumer<Boolean>> iterator = this.lock;
                synchronized (iterator) {
                    try {
                        this.lock.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }
    }
}

