/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.jul;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.slf4j.MDC;
import shaded.com.getsentry.raven.Raven;
import shaded.com.getsentry.raven.RavenFactory;
import shaded.com.getsentry.raven.config.Lookup;
import shaded.com.getsentry.raven.dsn.Dsn;
import shaded.com.getsentry.raven.dsn.InvalidDsnException;
import shaded.com.getsentry.raven.environment.RavenEnvironment;
import shaded.com.getsentry.raven.event.Event;
import shaded.com.getsentry.raven.event.EventBuilder;
import shaded.com.getsentry.raven.event.interfaces.ExceptionInterface;
import shaded.com.getsentry.raven.event.interfaces.MessageInterface;
import shaded.com.getsentry.raven.util.Util;

public class SentryHandler
extends Handler {
    public static final String THREAD_ID = "Raven-ThreadId";
    protected volatile Raven raven;
    protected String dsn;
    protected boolean printfStyle;
    protected String ravenFactory;
    protected String release;
    protected String environment;
    protected String serverName;
    protected Map<String, String> tags = Collections.emptyMap();
    protected Set<String> extraTags = Collections.emptySet();

    public SentryHandler() {
        this.setRavenFactory(Lookup.lookup("ravenFactory"));
        this.setRelease(Lookup.lookup("release"));
        this.setEnvironment(Lookup.lookup("environment"));
        this.setServerName(Lookup.lookup("serverName"));
        this.setTags(Lookup.lookup("tags"));
        this.setExtraTags(Lookup.lookup("extraTags"));
        this.retrieveProperties();
        this.setFilter(new DropRavenFilter());
    }

    public SentryHandler(Raven raven) {
        this();
        this.raven = raven;
    }

    protected static Event.Level getLevel(Level level) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            return Event.Level.ERROR;
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return Event.Level.WARNING;
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return Event.Level.INFO;
        }
        if (level.intValue() >= Level.ALL.intValue()) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    protected static List<String> formatMessageParameters(Object[] parameters) {
        ArrayList<String> formattedParameters = new ArrayList<String>(parameters.length);
        for (Object parameter : parameters) {
            formattedParameters.add(parameter != null ? parameter.toString() : null);
        }
        return formattedParameters;
    }

    protected void retrieveProperties() {
        String extraTagsProperty;
        String tagsProperty;
        String serverNameProperty;
        String environmentProperty;
        String releaseProperty;
        String ravenFactoryProperty;
        String className;
        LogManager manager = LogManager.getLogManager();
        String dsnProperty = manager.getProperty((className = SentryHandler.class.getName()) + ".dsn");
        if (dsnProperty != null) {
            this.setDsn(dsnProperty);
        }
        if ((ravenFactoryProperty = manager.getProperty(className + ".ravenFactory")) != null) {
            this.setRavenFactory(ravenFactoryProperty);
        }
        if ((releaseProperty = manager.getProperty(className + ".release")) != null) {
            this.setRelease(releaseProperty);
        }
        if ((environmentProperty = manager.getProperty(className + ".environment")) != null) {
            this.setEnvironment(environmentProperty);
        }
        if ((serverNameProperty = manager.getProperty(className + ".serverName")) != null) {
            this.setServerName(serverNameProperty);
        }
        if ((tagsProperty = manager.getProperty(className + ".tags")) != null) {
            this.setTags(tagsProperty);
        }
        if ((extraTagsProperty = manager.getProperty(className + ".extraTags")) != null) {
            this.setExtraTags(extraTagsProperty);
        }
        this.setPrintfStyle(Boolean.valueOf(manager.getProperty(className + ".printfStyle")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record) || RavenEnvironment.isManagingThread()) {
            return;
        }
        RavenEnvironment.startManagingThread();
        try {
            if (this.raven == null) {
                this.initRaven();
            }
            Event event = this.buildEvent(record);
            this.raven.sendEvent(event);
        }
        catch (Exception e) {
            this.reportError("An exception occurred while creating a new event in Raven", e, 1);
        }
        finally {
            RavenEnvironment.stopManagingThread();
        }
    }

    protected synchronized void initRaven() {
        try {
            if (this.dsn == null) {
                this.dsn = Dsn.dsnLookup();
            }
            this.raven = RavenFactory.ravenInstance(new Dsn(this.dsn), this.ravenFactory);
        }
        catch (InvalidDsnException e) {
            this.reportError("An exception occurred during the retrieval of the DSN for Raven", e, 4);
        }
        catch (Exception e) {
            this.reportError("An exception occurred during the creation of a Raven instance", e, 4);
        }
    }

    protected Event buildEvent(LogRecord record) {
        EventBuilder eventBuilder = new EventBuilder().withSdkName("raven-java:jul").withLevel(SentryHandler.getLevel(record.getLevel())).withTimestamp(new Date(record.getMillis())).withLogger(record.getLoggerName());
        String message = record.getMessage();
        if (record.getResourceBundle() != null && record.getResourceBundle().containsKey(record.getMessage())) {
            message = record.getResourceBundle().getString(record.getMessage());
        }
        String topLevelMessage = message;
        if (record.getParameters() == null) {
            eventBuilder.withSentryInterface(new MessageInterface(message));
        } else {
            String formatted;
            List<String> parameters = SentryHandler.formatMessageParameters(record.getParameters());
            try {
                topLevelMessage = formatted = this.formatMessage(message, record.getParameters());
            }
            catch (Exception e) {
                formatted = null;
            }
            eventBuilder.withSentryInterface(new MessageInterface(message, parameters, formatted));
        }
        eventBuilder.withMessage(topLevelMessage);
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            eventBuilder.withSentryInterface(new ExceptionInterface(throwable));
        }
        if (record.getSourceClassName() != null && record.getSourceMethodName() != null) {
            StackTraceElement fakeFrame = new StackTraceElement(record.getSourceClassName(), record.getSourceMethodName(), null, -1);
            eventBuilder.withCulprit(fakeFrame);
        } else {
            eventBuilder.withCulprit(record.getLoggerName());
        }
        Map<String, String> mdc = MDC.getMDCAdapter().getCopyOfContextMap();
        if (mdc != null) {
            for (Map.Entry<String, String> mdcEntry : mdc.entrySet()) {
                if (this.extraTags.contains(mdcEntry.getKey())) {
                    eventBuilder.withTag(mdcEntry.getKey(), mdcEntry.getValue());
                    continue;
                }
                eventBuilder.withExtra(mdcEntry.getKey(), mdcEntry.getValue());
            }
        }
        for (Map.Entry<String, String> tagEntry : this.tags.entrySet()) {
            eventBuilder.withTag(tagEntry.getKey(), tagEntry.getValue());
        }
        eventBuilder.withExtra(THREAD_ID, record.getThreadID());
        if (!Util.isNullOrEmpty(this.release)) {
            eventBuilder.withRelease(this.release.trim());
        }
        if (!Util.isNullOrEmpty(this.environment)) {
            eventBuilder.withEnvironment(this.environment.trim());
        }
        if (!Util.isNullOrEmpty(this.serverName)) {
            eventBuilder.withServerName(this.serverName.trim());
        }
        this.raven.runBuilderHelpers(eventBuilder);
        return eventBuilder.build();
    }

    protected String formatMessage(String message, Object[] parameters) {
        String formatted = this.printfStyle ? String.format(message, parameters) : MessageFormat.format(message, parameters);
        return formatted;
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SecurityException {
        RavenEnvironment.startManagingThread();
        try {
            if (this.raven != null) {
                this.raven.closeConnection();
            }
        }
        catch (Exception e) {
            this.reportError("An exception occurred while closing the Raven connection", e, 3);
        }
        finally {
            RavenEnvironment.stopManagingThread();
        }
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public void setPrintfStyle(boolean printfStyle) {
        this.printfStyle = printfStyle;
    }

    public void setRavenFactory(String ravenFactory) {
        this.ravenFactory = ravenFactory;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setTags(String tags) {
        this.tags = Util.parseTags(tags);
    }

    public void setExtraTags(String extraTags) {
        this.extraTags = Util.parseExtraTags(extraTags);
    }

    private class DropRavenFilter
    implements Filter {
        private DropRavenFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            String loggerName = record.getLoggerName();
            return loggerName == null || !loggerName.startsWith("shaded.com.getsentry.raven");
        }
    }
}

