/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.event.helper;

import java.util.ArrayList;
import java.util.Iterator;
import shaded.com.getsentry.raven.Raven;
import shaded.com.getsentry.raven.RavenContext;
import shaded.com.getsentry.raven.event.Breadcrumb;
import shaded.com.getsentry.raven.event.EventBuilder;
import shaded.com.getsentry.raven.event.User;
import shaded.com.getsentry.raven.event.helper.EventBuilderHelper;
import shaded.com.getsentry.raven.event.interfaces.UserInterface;

public class ContextBuilderHelper
implements EventBuilderHelper {
    private Raven raven;

    public ContextBuilderHelper(Raven raven) {
        this.raven = raven;
    }

    @Override
    public void helpBuildingEvent(EventBuilder eventBuilder) {
        ArrayList<Breadcrumb> breadcrumbs = new ArrayList<Breadcrumb>();
        RavenContext context = this.raven.getContext();
        Iterator<Breadcrumb> breadcrumbIterator = context.getBreadcrumbs();
        while (breadcrumbIterator.hasNext()) {
            breadcrumbs.add(breadcrumbIterator.next());
        }
        if (!breadcrumbs.isEmpty()) {
            eventBuilder.withBreadcrumbs(breadcrumbs);
        }
        if (context.getUser() != null) {
            eventBuilder.withSentryInterface(this.fromUser(context.getUser()));
        }
    }

    private UserInterface fromUser(User user) {
        return new UserInterface(user.getId(), user.getUsername(), user.getIpAddress(), user.getEmail());
    }
}

