/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.dbus.transport.junixsocket;

import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.transports.AbstractUnixTransport;
import org.freedesktop.dbus.exceptions.TransportConfigurationException;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.AFUNIXSocketExtensions;
import ru.turikhay.tlauncher.dbus.transport.junixsocket.UnixBusAddress;

public class JUnixSocketUnixTransport
extends AbstractUnixTransport {
    private final AFUNIXSocketAddress unixSocketAddress;
    private AFUNIXSocketChannel socket;
    private AFUNIXServerSocketChannel serverSocket;

    public JUnixSocketUnixTransport(UnixBusAddress address, TransportConfig transportConfig) throws TransportConfigurationException {
        super(address, transportConfig);
        if (!address.hasPath()) {
            throw new TransportConfigurationException("Native unix socket url has to specify 'path'");
        }
        try {
            this.unixSocketAddress = AFUNIXSocketAddress.of(address.getPath());
        }
        catch (SocketException e) {
            throw new TransportConfigurationException("Unable to resolve unix socket address", e);
        }
    }

    @Override
    protected boolean hasFileDescriptorSupport() {
        return AFSocket.supports(AFSocketCapability.CAPABILITY_FILE_DESCRIPTORS);
    }

    @Override
    protected SocketChannel connectImpl() throws IOException {
        if (this.getAddress().isListeningSocket()) {
            if (this.serverSocket == null || !this.serverSocket.isOpen()) {
                this.serverSocket = AFUNIXServerSocketChannel.open();
                this.serverSocket.bind(this.unixSocketAddress);
            }
            this.socket = this.serverSocket.accept();
        } else {
            this.socket = AFUNIXSocketChannel.open(this.unixSocketAddress);
        }
        this.socket.setAncillaryReceiveBufferSize(1024);
        this.socket.configureBlocking(true);
        return this.socket;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.socket != null) {
            if (this.socket.isOpen()) {
                this.socket.close();
            }
            this.socket = null;
        }
        if (this.serverSocket != null) {
            if (this.serverSocket.isOpen()) {
                this.serverSocket.close();
            }
            this.serverSocket = null;
        }
    }

    @Override
    public int getUid(SocketChannel sock) throws IOException {
        if (sock instanceof AFUNIXSocketExtensions) {
            AFUNIXSocketCredentials peerCredentials = ((AFUNIXSocketExtensions)((Object)sock)).getPeerCredentials();
            return (int)peerCredentials.getUid();
        }
        throw new IllegalArgumentException("Unable to handle unknown socket type: " + sock.getClass());
    }

    @Override
    protected boolean isAbstractAllowed() {
        return false;
    }
}

