/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.util;

import java.util.Arrays;

public class SplitArgs {
    private final String[] bootstrap;
    private final String[] launcher;

    public SplitArgs(String[] bootstrap, String[] launcher) {
        this.bootstrap = SplitArgs.emptyIfNull(bootstrap);
        this.launcher = SplitArgs.emptyIfNull(launcher);
    }

    public String[] getBootstrap() {
        return (String[])this.bootstrap.clone();
    }

    public String[] getLauncher() {
        return (String[])this.launcher.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitArgs splitArgs = (SplitArgs)o;
        return Arrays.equals(this.bootstrap, splitArgs.bootstrap) && Arrays.equals(this.launcher, splitArgs.launcher);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.bootstrap);
        result = 31 * result + Arrays.hashCode(this.launcher);
        return result;
    }

    public static SplitArgs splitArgs(String[] args) {
        String[] launcher;
        String[] bootstrap = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("--")) continue;
            bootstrap = new String[i];
            break;
        }
        if (bootstrap != null) {
            System.arraycopy(args, 0, bootstrap, 0, bootstrap.length);
            launcher = new String[args.length - bootstrap.length - 1];
            if (launcher.length > 0) {
                System.arraycopy(args, bootstrap.length + 1, launcher, 0, launcher.length);
            }
        } else {
            launcher = (String[])args.clone();
        }
        return new SplitArgs(bootstrap, launcher);
    }

    public String toString() {
        return "SplitArgs{bootstrap=" + Arrays.toString(this.bootstrap) + ", launcher=" + Arrays.toString(this.launcher) + '}';
    }

    private static String[] emptyIfNull(String[] s) {
        return s == null ? new String[]{} : s;
    }
}

