/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import ru.turikhay.tlauncher.bootstrap.util.WeakObjectPool;

public class Sha256Sign {
    private static final WeakObjectPool<MessageDigest> SHA256Pool = new WeakObjectPool<MessageDigest>(() -> {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException nsaE) {
            throw new Error(nsaE);
        }
    });

    public static WeakObjectPool.ObjectRef<MessageDigest> getDigest() {
        return SHA256Pool.get();
    }

    public static String toString(byte[] b) {
        return String.format(Locale.ROOT, "%064x", new BigInteger(1, b));
    }

    public static byte[] digest(byte[] b) {
        try {
            return Sha256Sign.digest(new ByteArrayInputStream(b));
        }
        catch (IOException e) {
            throw new Error("unexpected ioE", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] digest(InputStream in) throws IOException {
        WeakObjectPool.ObjectRef<MessageDigest> digestRef = SHA256Pool.get();
        MessageDigest digest = digestRef.get();
        try {
            int nread;
            byte[] dataBytes = new byte[1024];
            while ((nread = in.read(dataBytes)) != -1) {
                digest.update(dataBytes, 0, nread);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
        finally {
            digest.reset();
            digestRef.free();
        }
    }

    public static String calc(Path file) throws IOException {
        try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
            String string = Sha256Sign.toString(Sha256Sign.digest(input));
            return string;
        }
    }

    private Sha256Sign() {
    }
}

