/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.ui.swing;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import ru.turikhay.tlauncher.bootstrap.util.OS;

public class HTMLKitLinkListener
extends MouseAdapter {
    private static final Cursor HAND = Cursor.getPredefinedCursor(12);

    @Override
    public void mouseClicked(MouseEvent e) {
        String href;
        JEditorPane editor = (JEditorPane)e.getSource();
        if ((editor.isEnabled() || editor.isDisplayable()) && (href = HTMLKitLinkListener.getAnchorHref(e)) != null && e.getButton() == 1) {
            HTMLKitLinkListener.openLink(href);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        JEditorPane editor = (JEditorPane)e.getSource();
        if (editor.isEnabled() || editor.isDisplayable()) {
            editor.setCursor(HTMLKitLinkListener.getAnchorHref(e) == null ? Cursor.getDefaultCursor() : HAND);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JEditorPane editor = (JEditorPane)e.getSource();
        if (editor.isEnabled() || editor.isDisplayable()) {
            editor.setCursor(Cursor.getDefaultCursor());
        }
    }

    private static void openLink(String href) {
        URL url;
        try {
            url = new URL(href);
        }
        catch (MalformedURLException ignored) {
            return;
        }
        OS.openUrl(url);
    }

    private static String getAnchorHref(MouseEvent e) {
        AttributeSet anchor;
        Object hrefObject;
        Object anchorAttr;
        HTMLDocument htmlDocument;
        Element elem;
        HTML.Tag tag;
        JEditorPane editor = (JEditorPane)e.getSource();
        if (editor.getDocument() instanceof HTMLDocument && (tag = HTMLKitLinkListener.getTag(elem = (htmlDocument = (HTMLDocument)editor.getDocument()).getCharacterElement(editor.viewToModel(e.getPoint())))) == HTML.Tag.CONTENT && (anchorAttr = elem.getAttributes().getAttribute(HTML.Tag.A)) instanceof AttributeSet && (hrefObject = (anchor = (AttributeSet)anchorAttr).getAttribute(HTML.Attribute.HREF)) instanceof String) {
            return (String)hrefObject;
        }
        return null;
    }

    private static HTML.Tag getTag(Element elem) {
        AttributeSet attrs = elem.getAttributes();
        Object elementName = attrs.getAttribute("$ename");
        Object o = elementName != null ? null : attrs.getAttribute(StyleConstants.NameAttribute);
        return o instanceof HTML.Tag ? (HTML.Tag)o : null;
    }
}

