/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.ui;

import java.util.ResourceBundle;
import ru.turikhay.tlauncher.bootstrap.pasta.Pasta;
import ru.turikhay.tlauncher.bootstrap.pasta.PastaException;
import ru.turikhay.tlauncher.bootstrap.pasta.PastaLink;
import ru.turikhay.tlauncher.bootstrap.ui.SaveLogsAction;
import ru.turikhay.tlauncher.bootstrap.ui.UserInterface;
import ru.turikhay.tlauncher.bootstrap.ui.message.Button;
import ru.turikhay.tlauncher.bootstrap.ui.message.MessageHost;
import ru.turikhay.tlauncher.bootstrap.ui.message.ProcessMessage;
import ru.turikhay.tlauncher.bootstrap.ui.message.SingleButtonMessage;
import ru.turikhay.tlauncher.bootstrap.util.U;
import ru.turikhay.tlauncher.bootstrap.util.stream.OutputRedirectBuffer;

class PastaAction
implements Runnable {
    private final ResourceBundle b = UserInterface.getResourceBundle();
    private final MessageHost host;

    PastaAction(MessageHost host) {
        this.host = host;
    }

    @Override
    public void run() {
        this.host.showMessage(new ProcessMessage(this.b.getString("pasta.sending"), () -> {
            try {
                this.sendPasta();
            }
            catch (PastaException e) {
                U.log("[Pasta]", e);
                this.sendPastaFailed();
            }
        }));
    }

    private void sendPasta() throws PastaException {
        Pasta pasta = new Pasta(PastaAction.getLogsContent());
        PastaLink link = pasta.send();
        this.host.showMessage(new SingleButtonMessage(this.b.getString("pasta.success.text"), Button.openLink(this.b.getString("pasta.success.button"), link.getUrl())));
    }

    private void sendPastaFailed() {
        this.host.showMessage(new SingleButtonMessage(this.b.getString("pasta.fail.text"), new Button(this.b.getString("pasta.fail.button"), this::saveLogs)));
    }

    private void saveLogs() {
        new SaveLogsAction(this.host).run();
    }

    private static String getLogsContent() {
        return OutputRedirectBuffer.getBuffer();
    }
}

