/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.task;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import ru.turikhay.tlauncher.bootstrap.exception.FileLockedException;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import ru.turikhay.tlauncher.bootstrap.task.TaskInterruptedException;
import ru.turikhay.tlauncher.bootstrap.util.Sha256Sign;
import ru.turikhay.tlauncher.bootstrap.util.U;

public class DownloadTask
extends Task<Void> {
    private final List<URL> urlList;
    private final Path file;
    private final String sha256;

    public DownloadTask(String name, List<URL> urlList, Path file, String sha256) {
        super(name);
        if (Objects.requireNonNull(urlList, "urlList").isEmpty()) {
            throw new IllegalArgumentException("url list is empty");
        }
        this.urlList = new ArrayList<URL>(urlList);
        this.file = file;
        this.sha256 = sha256;
    }

    public DownloadTask(String name, URL url, Path file, String sha256) {
        this(name, Collections.singletonList(url), file, sha256);
    }

    @Override
    protected Void execute() throws Exception {
        this.updateProgress(-1.0);
        if (Files.isRegularFile(this.file, new LinkOption[0]) && this.sha256 != null) {
            this.log("File exists, checking checksum: ", this.sha256);
            String hash = Sha256Sign.calc(this.file);
            if (this.sha256.equalsIgnoreCase(hash)) {
                this.log("File is the same. Download skipped.");
                return null;
            }
            this.log("File might be corrupted: ", hash);
        }
        IOException error = null;
        for (URL url : this.urlList) {
            try {
                this.downloadUrl(url);
            }
            catch (FileLockedException locked) {
                this.log("File is locked:", locked);
                throw locked;
            }
            catch (IOException ioE) {
                this.log("Failed to download:", url, ioE);
                if (error == null) {
                    error = ioE;
                    continue;
                }
                error.addSuppressed(ioE);
                continue;
            }
            return null;
        }
        if (error != null) {
            throw error;
        }
        throw new RuntimeException("Failed to download");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadUrl(URL url) throws IOException, TaskInterruptedException {
        this.log("Downloading:", url);
        URLConnection connection = url.openConnection(U.getProxy());
        Path temp = Files.createTempFile("tlauncher", null, new FileAttribute[0]);
        try (InputStream in = connection.getInputStream();
             OutputStream out = Files.newOutputStream(temp, new OpenOption[0]);){
            int i;
            byte[] buffer = new byte[8192];
            long read = 0L;
            double contentLength = connection.getContentLengthLong();
            while ((i = in.read(buffer)) >= 0) {
                out.write(buffer, 0, i);
                read += (long)i;
                if (contentLength != 0.0) {
                    this.updateProgress((double)read / contentLength);
                }
                this.checkInterrupted();
            }
            this.log("Downloaded", read, " bytes out of", connection.getContentLengthLong());
            if (this.sha256 != null) {
                this.log("Checking SHA256... Expected: ", this.sha256);
                out.close();
                String gotSha256 = Sha256Sign.calc(temp);
                this.log("Got: ", gotSha256);
                if (!this.sha256.equalsIgnoreCase(gotSha256)) {
                    this.log("Invalid checksum");
                    throw new IOException("invalid checksum. expected: " + this.sha256 + "; got: " + gotSha256);
                }
            }
            this.log("Downloaded successfully, copying back...");
            out.close();
            boolean tryCopy = false;
            ArrayList<IOException> copyAttemptFailures = new ArrayList<IOException>();
            do {
                try {
                    Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
                    Files.copy(temp, this.file, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    if (copyAttemptFailures.size() == 5) {
                        this.log("File is locked. Giving up trying to copy it", e);
                        copyAttemptFailures.forEach(e::addSuppressed);
                        throw e;
                    }
                    copyAttemptFailures.add(e);
                    this.log("File is probably locked. Let's wait some time...", e);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interrupted) {
                        throw new TaskInterruptedException(this);
                    }
                    this.checkInterrupted();
                    tryCopy = true;
                }
            } while (tryCopy);
        }
        finally {
            Files.delete(temp);
        }
    }
}

