/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.launcher;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import ru.turikhay.tlauncher.bootstrap.json.Json;
import ru.turikhay.tlauncher.bootstrap.launcher.Launcher;
import ru.turikhay.tlauncher.bootstrap.launcher.LauncherNotFoundException;
import ru.turikhay.tlauncher.bootstrap.meta.LauncherMeta;
import ru.turikhay.tlauncher.bootstrap.meta.LocalLauncherMeta;
import ru.turikhay.tlauncher.bootstrap.util.OS;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;

public class LocalLauncher
extends Launcher {
    public static final String ENTRY_NAME = "ru/turikhay/tlauncher/meta.json";
    private final Path file;
    private final Path libFolder;
    private LocalLauncherMeta meta;

    public LocalLauncher(Path file, Path libFolder) throws LauncherNotFoundException {
        this.file = Objects.requireNonNull(file, "file");
        if (!Files.exists(file, new LinkOption[0])) {
            throw new LauncherNotFoundException("local");
        }
        this.libFolder = Objects.requireNonNull(libFolder, "libFolder");
    }

    public final Path getFile() {
        return this.file;
    }

    public final Path getLibFolder() {
        return this.libFolder;
    }

    @Override
    public LocalLauncherMeta getMeta() throws IOException {
        return LocalLauncher.findMetaEntry(this.file, LocalLauncherMeta.class);
    }

    @Override
    protected ToStringBuilder toStringBuilder() {
        return super.toStringBuilder().append("meta", this.meta).append("file", this.file == null ? null : this.file.toAbsolutePath()).append("libFolder", this.libFolder == null ? null : this.libFolder.toAbsolutePath());
    }

    public static Path getDefaultFileLocation(String shortBrand) {
        return OS.getDefaultFolder().resolve("bin").resolve(shortBrand.toLowerCase(Locale.ROOT) + ".jar");
    }

    public static Path getDefaultLibLocation() {
        return OS.getDefaultFolder().resolve("lib");
    }

    static <T extends LauncherMeta> T findMetaEntry(Path file, Class<T> clazz) throws IOException {
        InputStream input;
        if (!Files.exists(file, new LinkOption[0])) {
            throw new FileNotFoundException();
        }
        if (Files.isRegularFile(file, new LinkOption[0])) {
            input = LocalLauncher.getZipEntry(file);
        } else {
            if (!Files.isRegularFile(file = file.resolve(ENTRY_NAME), new LinkOption[0])) {
                throw new FileNotFoundException("target entry is not found: " + file.toAbsolutePath());
            }
            input = Files.newInputStream(file, new OpenOption[0]);
        }
        try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
            LauncherMeta launcherMeta = (LauncherMeta)Json.get().fromJson((Reader)reader, clazz);
            return (T)launcherMeta;
        }
    }

    private static InputStream getZipEntry(Path file) throws IOException {
        final ZipFile zip = new ZipFile(file.toFile());
        ZipEntry metaEntry = zip.getEntry(ENTRY_NAME);
        if (metaEntry == null) {
            IOException ioE = new IOException("could not find entry: ru/turikhay/tlauncher/meta.json");
            try {
                zip.close();
            }
            catch (IOException suppressed) {
                ioE.addSuppressed(suppressed);
            }
            throw ioE;
        }
        return new FilterInputStream(zip.getInputStream(metaEntry)){

            @Override
            public void close() throws IOException {
                super.close();
                zip.close();
            }
        };
    }
}

